/***********************************************************************

                                      CSDB Library, Version 1.7.a 
                                        Released: April 24th 1995 

       Header file of the TBASE class.
       Database class for records with a fixed length.

                                           Copyright(c) 1994,1995 
                                                           Combis 
                                                  The Netherlands 
***********************************************************************/

#ifndef __CSTBASE_H
#define __CSTBASE_H

#include <dir.h>
#include <stdio.h>
#include <string.h>
#include <alloc.h>
#include "cspage.h"


class TBASE: public PAGE
{

protected:

   U16	lenrec;
   U16	recpage;
   U16	rec_foot;
   U16	len_rec_plus_foot;
   S32	NUMREC;
   S32	lrco;
   S32	wrco;
   S32	rrco;
   S32	cur_rec;


protected:

   void check_rec(S32  l);

   S32	r2p(S32  rec)	 { return (1+(rec-1)/recpage); }
   U16	oinp(S32  rec)	 { return (((U16 )((rec-1)%recpage))*len_rec_plus_foot); }

   virtual void check_id(U32 id);
   virtual void set_id(void);

   void init_defaults(void);
   void init_vars(void);
   void vars2head(void);
   void head2vars(void);

////////////////////////////////////////////////////////////////////////
////////////////////// PUBLIC FUNCTIONS ////////////////////////////////
////////////////////////////////////////////////////////////////////////

public:
   TBASE(void);
   ~TBASE(void);


//////////////////////// Compatibility function ////////////////////////
   void speed_option_121(void)	 { smallest_page(); }


//////////////////////// Definition //////////////////////////////////////////
/* Inherited
   void page_size(U16 length);
   U16	page_size(void) ;
*/
   void smallest_page(void)	 { recpage=1; }
   int	define(CSCHAR *name,U16  reclen);

//////////////////////// Open & Close ////////////////////////////////////////
   int	open(CSCHAR *name,S16 kb=32);
   int	open(void)		   { return already_open(); }
   int	close(void);
   int	save(void);

//////////////////////// Locate, Read & Writes records	///////////////////////
   CSCHAR *locate_rec(S32  rec)    { lrco++; return load_page(r2p(rec))+oinp(rec); }
   CSCHAR *locate_rec_d(S32  rec)  { lrco++; return load_page_d(r2p(rec))+oinp(rec); }
   CSCHAR *locate_rec_l(S32  rec)  { lrco++; return load_page_l(r2p(rec))+oinp(rec); }
   CSCHAR *locate_rec_ld(S32  rec) { lrco++; return load_page_ld(r2p(rec))+oinp(rec); }
   void locate_double(S32  rec1,void *&d1,S32  rec2,void *&d2);
   void locate_double_d(S32  rec1,void *&d1,S32  rec2,void *&d2);

   void read_rec(  S32	rec, void *d);
   void write_rec( S32	rec, void *d);

//////////////////////// Add Records /////////////////////////////////////////
   S32	append_rec(void *data);
   S32	append_rec(void);

////////////////////////// Deleting ////////////////////////////////////////////
   void set_delet(S32  r,int tf);
   void undelet(void *d)  { *((CSCHAR *)d+lengthrec())=0; }
   void delet(void *d)	  { *((CSCHAR *)d+lengthrec())=1; }
   int	is_delet(void *d) { return *((CSCHAR *)d+lengthrec()); }

   int	is_delet(S32  l)  { return is_delet(locate_rec(l)); }
   void delet(S32  r)	  { set_delet(r,TRUE); }
   void undelet(S32  r )  { set_delet(r,FALSE); }

//////////////////////// Number of Records ///////////////////////////////////
   S32	numrec(void)	  { return NUMREC; }
   void set_numrec(S32	n){ NUMREC=n; set_num_page(r2p(n)); }
   void dec_numrec(void ) { NUMREC--; }

////////////////////////// Record Length ///////////////////////////////////////
   U16	lengthrec(void)   { return lenrec; }


////////////////////////// Current /////////////////////////////////////////////

   S32	set_current(S32  rec) { return cur_rec=max(min(rec,numrec()),0); }
   S32	current(void)	 { return cur_rec; }
   S32	skip(S32  delta) { S32	l=current(); return (set_current(l+delta)-l); }
   S32	next(S32  delta) { return skip(delta); }
   S32	prev(S32  delta) { return -skip(-delta); }


////////////////////////// Miscellaneous ///////////////////////////////////////
/* Inherited
   int	background(void)
*/
   int pack(void);
   int zap(void);
   void info(void);
   int empty(void);
   virtual int class_ID(void)  { return CS_CLID_TBASE; }



};

#endif
