/***********************************************************************

                                       CSA Library, Version 1.7.a 
                                        Released: April 24th 1995 

       Preprocessor commands to replace all the memory
       allocation functions with new ones which log
       and check the use of the heap.

                                           Copyright(c) 1994,1995 
                                                           Combis 
                                                  The Netherlands 
***********************************************************************/

#ifndef __CSMALLOC_H
#define __CSMALLOC_H


#include "alloc.h"
#include "malloc.h"
#include "stdlib.h"
#include "cstypes.h"


#if defined(CS_DEBUG)

  #define  csmalloc(x)	     cs_malloc(x,      __FILE__,__LINE__)
  #define  cscalloc(x,y)     cs_calloc(x,y,    __FILE__,__LINE__)
  #define  csrealloc(x,y)    cs_realloc(x,y,   __FILE__,__LINE__)
  #define  csfree(x)	     cs_free(x,        __FILE__,__LINE__)
  #define  csfarmalloc(x)    cs_farmalloc(x,   __FILE__,__LINE__)
  #define  csfarcalloc(x,y)  cs_farcalloc(x,y, __FILE__,__LINE__)
  #define  csfarrealloc(x,y) cs_farrealloc(x,y,__FILE__,__LINE__)
  #define  csfarfree(x)      cs_farfree(x,     __FILE__,__LINE__)

#else

  #define  csmalloc(x)	      ::malloc(x)
  #define  cscalloc(x,y)      ::calloc(x,y)
  #define  csrealloc(x,y)     ::realloc(x,y)
  #define  csfree(x)	      ::free(x)
  #define  csfarmalloc(x)     ::farmalloc(x)
  #define  csfarcalloc(x,y)   ::farcalloc(x,y)
  #define  csfarrealloc(x,y)  ::farrealloc(x,y)
  #define  csfarfree(x)       ::farfree(x)

#endif


void   alloc_logging(int TrueFalse,CSCHAR *name);
void   alloc_test(CSCHAR *fname,long line);
inline void  alloc_logging(int TrueFalse) { alloc_logging(TrueFalse,"malloc.log"); }

void far  * _Cdecl cs_farcalloc(unsigned long __nunits, unsigned long __unitsz,CSCHAR *fname,long line);
void far  * _Cdecl cs_farrealloc(void far * ptr,unsigned long __nunits, unsigned long __unitsz,CSCHAR *fname,long line);
void	    _Cdecl cs_farfree(void far *__block,CSCHAR *fname,long line);
void far  * _Cdecl cs_farmalloc(unsigned long __nbytes,CSCHAR *fname,long line);

void _FAR * _Cdecl cs_realloc(void _FAR *ptr, size_t __size,CSCHAR *fname,long line);
void _FAR * _Cdecl cs_calloc(size_t __nitems, size_t __size,CSCHAR *fname,long line);
void	    _Cdecl cs_free(void _FAR *__block,CSCHAR *fname,long line);
void _FAR * _Cdecl cs_malloc(size_t __size,CSCHAR *fname,long line);


#endif
