#include "ctype.h" 
#include "csa.h" 
#include "csdb.h" 

#define NAME_LENGTH	 40 
#define ADDRESS_LENGTH	 30 
#define CITY_LENGTH	 20 

////////// Indexes to be used with the 'order()' function./////////////
#define UNSORTED	 0
#define NAME_INDEX	 1 
#define ADDRESS_INDEX	 2 
#define CITY_INDEX	 3 
#define BIRTHDAY_INDEX	 4 

typedef struct 
{
   char   _name[NAME_LENGTH+1]; 
   char   _address[ADDRESS_LENGTH+1]; 
   char   _city[CITY_LENGTH+1]; 
   long   __birthday; 
   float  _salary; 
} nac_record;

class NAC
{
 protected:

   nac_record *static_rec;

   long current;
   int  dirty;
   int  is_open;
   int  iOrder;
   DATE  _birthday;


   int  (NAC::*bof_fun)(void);
   int  (NAC::*eof_fun)(void);
   int  (NAC::*skip_fun)(int delta);
   void (NAC::*top_fun)(void);
   void (NAC::*bottom_fun)(void);
   int  (NAC::*search_fun)(void *k);

   TBASE  db;
   BTREEa in1;		//Index on field name  
   BTREEa in2;		//Index on field address  
   BTREEa in3;		//Index on field city  
   BTREEl in4;		//Index on field birthday  

   int bof0(void)	{ return (current==1); }
   int bof1(void)	{ return in1.tBOF(); }
   int bof2(void)	{ return in2.tBOF(); }
   int bof3(void)	{ return in3.tBOF(); }
   int bof4(void)	{ return in4.tBOF(); }

   int eof0(void)	{ return (current==db.numrec()); }
   int eof1(void)	{ return in1.tEOF(); }
   int eof2(void)	{ return in2.tEOF(); }
   int eof3(void)	{ return in3.tEOF(); }
   int eof4(void)	{ return in4.tEOF(); }

   void top0(void)	{ current=1; }
   void top1(void)	{ in1.min_dat(&current); }
   void top2(void)	{ in2.min_dat(&current); }
   void top3(void)	{ in3.min_dat(&current); }
   void top4(void)	{ in4.min_dat(&current); }

   void bottom0(void)	{ current=db.numrec(); }
   void bottom1(void)	{ in1.max_dat(&current); }
   void bottom2(void)	{ in2.max_dat(&current); }
   void bottom3(void)	{ in3.max_dat(&current); }
   void bottom4(void)	{ in4.max_dat(&current); }

   int  search0(void * )	{ return TRUE; } 
   int  search1(void *k)	{ return in1.search_dat_ge(k,&current); }
   int  search2(void *k)	{ return in2.search_dat_ge(k,&current); }
   int  search3(void *k)	{ return in3.search_dat_ge(k,&current); }
   int  search4(void *k)	{ return in4.search_dat_ge(k,&current); }

   int  skip0(int delta); 
   int  skip1(int delta)	{ return in1.skip_dat(delta,&current); }
   int  skip2(int delta)	{ return in2.skip_dat(delta,&current); }
   int  skip3(int delta)	{ return in3.skip_dat(delta,&current); }
   int  skip4(int delta)	{ return in4.skip_dat(delta,&current); }

   void in1_ins_tok(void *s)	{ in1.insert(s,&current); }
   void in1_del_tok(void *s)	{ in1.delet(s,&current); }

   nac_record *locate_curr(void) { return (nac_record *)db.locate_rec(current); } 

   void tokenize(char *s,const char *delim,int len,void(NAC::*fun)(void *));

 public:

 //////////////////////////////// class constructor ////////////////////////////
   NAC(void); 

 //////////////////////////////// class destructor /////////////////////////////
   ~NAC(void);

 //////////////////////////////// current record number ////////////////////////
   long curr_rec(void)   { return current; }

 //////////////////////////////// define ///////////////////////////////////////
   void define(void);  

 //////////////////////////////// open & close ////////////////////////////////
   void open(void);  
   void close(void);  

 //////////////////////////////// delete //////////////////////////////////////
   int  is_delet(void)   { return db.is_delet(current); } 
   void undelet(void)    { db.undelet(current); }         
   void delet(void)      { db.delet(current); }           

   int  is_delet(long n) { return db.is_delet(n); } 
   void undelet(long n)  { db.undelet(n);         } 
   void delet(long n)    { db.delet(n);           } 

 //////////////////////////////// number of records ///////////////////////////
   long numrec(void)     { return db.numrec(); } 

 //////////////////////////////// import/export ///////////////////////////////
   int  import(char *s);
   int  export(char *s);
   int  to_DBASE(char *s);

 //////////////////////////////// read/write current record ///////////////////
   void write_rec2(void);
   void write_rec(void) { if(dirty) write_rec2(); }

   void read_rec(void);

 //////////////////////////////// reindexing //////////////////////////////////
   void reindex(void); 

 //////////////////////////////// append //////////////////////////////////////
   void append(void);        //Indexes are NOT updated.
   void append_blank(void);  //Indexes ARE updated.

 //////////////////////////////// data in header //////////////////////////////
   int data_2_header(void *p,U16 size) { return db.data_2_header(p,size); } 
   int header_2_data(void *p,U16 size) { return db.header_2_data(p,size); } 
   U16 max_data_in_header(void)        { return db.max_data_in_header();  } 

 //////////////////////////////// pack ////////////////////////////////////////
   void pack(void);

 //////////////////////////////// (change) active index ///////////////////////
   void order(int nr);    
   int  order(void)  { return iOrder; } 

 //////////////////////////////// testing begin/end ///////////////////////////
   int  tBOF(void)       { return (this->*bof_fun)(); } 
   int  tEOF(void)       { return (this->*eof_fun)(); } 

 //////////////////////////////// relocating //////////////////////////////////
   int  skip(int del); 
   void bottom(void)     { write_rec(); (this->*bottom_fun)(); read_rec(); }  
   void top(void)        { write_rec(); (this->*top_fun)(); read_rec(); }  
   void search(void *k)  { write_rec(); if(!(this->*search_fun)(k)) bottom(); read_rec(); }
   void go_to(long n);

 /////////////////////////reading fields //////////////////////////////////////
    char * name(void)           { return static_rec->_name; } 
    char * address(void)        { return static_rec->_address; } 
    char * city(void)           { return static_rec->_city; } 
    char * birthday(void)       { return (char *)_birthday; } 
    float  salary(void)         { return static_rec->_salary; } 

 /////////////////////////writing fields //////////////////////////////////////
    void   name(char *s)        { strncpy(static_rec->_name,s,NAME_LENGTH); dirty=TRUE; } 
    void   address(char *s)     { strncpy(static_rec->_address,s,ADDRESS_LENGTH); dirty=TRUE; } 
    void   city(char *s)        { strncpy(static_rec->_city,s,CITY_LENGTH); dirty=TRUE; } 
    void   birthday(char *s)    { _birthday=s; dirty=TRUE; } 
    void   salary(float f)      { static_rec->_salary=f; dirty=TRUE; } 

};