/***********************************************************************

                                       CSA Library, Version 1.7.a 
                                        Released: April 24th 1995 

       Elaborate string class.
       Contains functions to edit a string.
       (Assuming a non-graphical screen.)

                                           Copyright(c) 1994,1995 
                                                           Combis 
                                                  The Netherlands 
***********************************************************************/

#ifndef __CSEDSTR_H
#define __CSEDSTR_H


#ifndef __STDLIB_H
#include "stdlib.h"
#endif

#ifndef __STRING_H
#include "string.h"
#endif

#ifndef __CSTOOLS_H
#include "cstools.h"
#endif


////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////

class STR
{
protected:

  CSCHAR *s;
  int al_len;		  // Number of bytes allocated (including the 0 )

public:
  int length(void)	  { return strlen(s); }

//////////////////// String manipulation ///////////////////////

   void trim(void)	    { trim_string(s); }
   void upper(void)	    { strupr(s);      }
   void lower(void)	    { strlwr(s);      }
   void strip(CSCHAR *f)    { str_strip(s,f); }
   void filter(CSCHAR *f)   { filter_string(s,f); }
   void replace_one(CSCHAR *d,CSCHAR *r) { string_replace_ones(s,d,r); }
   int	replace_all(CSCHAR *d,CSCHAR *r) { return string_replace(s,d,r); }
   CSCHAR *find_sub(CSCHAR *sub)
	{
	   return strstr((CSCHAR *)s,(CSCHAR *)sub);
	}
   int	find_pos(CSCHAR *sub)
	{
	   CSCHAR *p=strstr((CSCHAR *)s,(CSCHAR *)sub);
	   return (p==NULL) ? -1: (int)(p-s);
	}

///////////////////// Constructors  ///////////////////////////
   STR( STR&);
   STR(uchar *);
   STR(CSCHAR *);
   STR(int len);
   STR(void);


///////////////////// Destructor  /////////////////////////////
   ~STR(void);


////////////////////// Operator overloading /////////////////////
   friend STR operator+( STR &s1, STR &s2);

   STR operator+( STR &s1);

   CSCHAR & operator[](int i);	// First byte is position 0.

   int operator==( STR &str)  { return !stricmp(str.s,s); }
   int operator<( STR &str)   { return (stricmp(s,str.s)<0); }
   int operator<=( STR &str)  { return (stricmp(s,str.s)<=0); }
   int operator>( STR &str)   { return (stricmp(s,str.s)>0); }
   int operator>=( STR &str)  { return (stricmp(s,str.s)>=0); }

   STR&  operator+=( STR &);
   STR&  operator+=( CSCHAR *);
   STR&  operator=(uchar *);
   STR&  operator=(CSCHAR *p)  { return operator=((uchar *)p); }
   STR&  operator=(uchar &);
   STR&  operator=(int &);
   STR&  operator=(long &);
   STR&  operator=(float &);
   STR&  operator=(double &);
   STR&  operator=( STR &);


////////////////////// Type casting  /////////////////////////////

   operator uchar*()   { return (uchar *)s; }
   operator CSCHAR*()  { return (CSCHAR *)s; }
   operator uchar()    { return *s; }
   operator int()      { return atoi(s); }
   operator long()     { return atol(s); }
   operator float()    { return (float)atof(s); }
   operator double()   { return atof(s); }



////////////////////// Allocation ///////////////////////////////

protected:
    void m_alloc(int n);      // Allocating
    void m_free(void);	      // Freeing allocated memory

public:
    void alloc_min(void);     // Minimizes the amount of allocated
			      // RAM (with respect to the string length).
			      // No data is lost.
    void alloc_adjust(int l); // Adjust the allocated amount of
			      // RAM to amount l, or to the (string length +1)
			      // whatever is more.
			      // No data is lost.
    void alloc_new(int n);    // Throws away the old string and the
			      // accompaning allocated memory.
			      // And allocates n new bytes without
			      // initializing!
			      // ALL DATA IS LOST.
    void alloc_max(int n);    // Allocates n bytes if not already
			      // available.
			      // No data is lost.
    void alloc_new_max(int n);// Allocates n bytes if not already
			      // available.
			      // ALL DATA IS LOST.

};



////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////


class EDSTR: public STR
{
protected:
  int vertical_exit;
  uchar *legs;	      // Allowable CSCHARacters
  int esc_allow;
  int change;
  int maxlen;	      // Max allowable length during editing
  int displen;	      // Max number of uchar displayed during editing.
  int exitkey;

private:

//////////////////// Template related /////////////////////////////////

  int go_left(int &l_pos,int &pos, uchar * tpt);
  int go_right(int &l_pos,int &pos, uchar * tpt);
  int go_home(int &l_pos,int &pos, uchar * tpt);
  int go_end(int &l_pos,int &pos, uchar * tpt);
  int go_bcks(int &l_pos,int &pos, uchar * tpt);
  int go_del(int &l_pos,int &pos, uchar * tpt);
  int ed_tpt(int &l_pos,int &pos,uchar *temp,uchar *eX_tpt,int TF);

////////////////////////////////////////////////////////////////////////

protected:
  int editstring(int &insert,int &l_pos,int &pos,uchar *l,int disp_len,int max_len,int edit_allow);
  int edit(int &insert,int &l_pos,int &pos);
  int browse(int &insert,int &l_pos,int &pos);
  void v_exit(int t)	  { vertical_exit=t; }

  void init(void);

public:

///////////////////// Constructores  /////////////////////


   EDSTR( EDSTR&);
   EDSTR(uchar *);
   EDSTR(int len);
   EDSTR(void);

   ~EDSTR(void);

  void change_reset(void) { change=FALSE; }
  void show(void);

  int ed_template(int &l_pos,int &pos,uchar *tpt);

//////////////////// String editing ////////////////////////////


   void legal(uchar *s)  { legs=s;     }
   void legal(CSCHAR *s) { legal((uchar *)s); }
   void max_len(int l)	 { maxlen=l;   }
   void disp_len(int l)  { displen=l;  }
   int	disp_len(void)	 { return displen; }
   void exit_key(int ke) { exitkey=ke; }
   int edit(void) ;
   int edit(uchar *l)	 { legal(l); return edit(); }
   int edit(uchar *l, int dl,int ml)
			 { legal(l); disp_len(dl); max_len(ml); return edit(); }
   int edit(int dl,int ml)
			 { disp_len(dl); max_len(ml); return edit(); }
   int browse(void) ;
   int browse(int dl,int ml)
			 { disp_len(dl); max_len(ml); return browse(); }
   int changed(void)	 { return change; }
   void escape_on(void)  { esc_allow=TRUE; }
   void escape_off(void) { esc_allow=FALSE; }
   void escape(int tf)	 { esc_allow=tf; }

//////////////////// Converting from EDSTR ////////////////////////
   int	  convert(uchar *);
   int	  convert(CSCHAR *s) { return convert((uchar *)s); }
   int	  convert(uchar &);
   int	  convert(CSCHAR &c) { return convert((uchar)c); }
   int	  convert(int &);
   int	  convert(float &);
   int	  convert(long &);
   int	  convert(double &);


////////////////////// Operator overloading /////////////////////
   friend EDSTR operator+( EDSTR &s1, EDSTR &s2);
   EDSTR operator+( EDSTR &s1);


   CSCHAR & operator[](int i)	{ return s[i];			}
   int operator==( EDSTR &str)	{ return !stricmp(str.s,s);	}
   int operator<( EDSTR &str)	{ return (stricmp(s,str.s)<0);	}
   int operator<=( EDSTR &str)	{ return (stricmp(s,str.s)<=0); }
   int operator>( EDSTR &str)	{ return (stricmp(s,str.s)>0);	}
   int operator>=( EDSTR &str)	{ return (stricmp(s,str.s)>=0); }

   EDSTR&  operator+=(EDSTR &);
   EDSTR&  operator+=(CSCHAR *);
   EDSTR&  operator=(uchar *);
   EDSTR&  operator=(CSCHAR *s) { return operator=((uchar *)s); }
   EDSTR&  operator=(uchar &);
   EDSTR&  operator=(CSCHAR &s) { return operator=((uchar)s); }
   EDSTR&  operator=(int &);
   EDSTR&  operator=(long &);
   EDSTR&  operator=(float &);
   EDSTR&  operator=(double &);
   EDSTR&  operator=(EDSTR &);


////////////////////// Type casting  /////////////////////////////
   operator uchar*()   { return (uchar *)s; }
   operator CSCHAR*()  { return (CSCHAR *)s; }
   operator uchar()    { return (uchar)*s; }
   operator CSCHAR()   { return (CSCHAR)*s; }
   operator int()      { return atoi(s); }
   operator long()     { return atol(s); }
   operator float()    { return (float)atof(s); }
   operator double()   { return atof(s); }



};


#endif
