/*
   CPPTask - A Multitasking Kernel For C++

   Version 1.0 08-12-91

   Ported by Rich Smith from:

   Public Domain Software written by
      Thomas Wagner
      Patschkauer Weg 31
      D-1000 Berlin 33
      West Germany

   This module contains the memory allocation functions that are needed.

   TSKALLOC.CPP - Dynamic memory allocation interface

   Subroutines
        tsk_alloc
        tsk_free
        operator new
        operator delete

*/

#include "task.hpp"

#include <stdlib.h>

farptr tsk_alloc (word size)
{
   farptr ptr;

   alloc_resource.request_resource (0L);
   ptr = malloc (size);
   alloc_resource.release_resource ();

   return ptr;
}


void tsk_free (farptr item)
{
   alloc_resource.request_resource (0L);
   free (item);
   alloc_resource.release_resource ();
}

void* operator new(size_t size)
{
   return tsk_alloc(size);
}


void operator delete(void* item)
{
   tsk_free(item);
}
