/*
   CPPTask - A Multitasking Kernel For C++

   Version 1.0 08-12-91

   Ported by Rich Smith from:

   Public Domain Software written by
      Thomas Wagner
      Patschkauer Weg 31
      D-1000 Berlin 33
      West Germany

   TSKRSC.CPP - Resource handling routines.

   Subroutines:
        resource::resource
        resource::~resource
        resource::request_resource
        resource::c_request_resource
        resource::check_resource
        resource::get_state
        resource::get_flags

*/

#include <stdio.h>

#include "task.hpp"
#include "tsklocal.hpp"

/*
   resource - initialise resource.
*/

resource::resource ()
{
  flags = 0;

  waiting = NULL;
  state = 1;
  owner = NULL;
}

/*
   ~resource - Kill all tasks waiting for the resource.
*/

resource::~resource ()
{
   CRITICAL;

   C_ENTER;
   tsk_kill_queue (&waiting);
   owner = NULL;
   state = 0;
   C_LEAVE;

}


/*
   request_resource - Wait until resource is available. If the resource
                      is free on entry, it is assigned to the task, and
                      the task continues to run.
                      If the task requesting the resource already owns it,
                      this routine returns 0.
*/

int far resource::request_resource (dword timeout)
{
   CRITICAL;

   C_ENTER;
   if (state || owner == tsk_current)
      {
      state = 0;
      owner = tsk_current;
      C_LEAVE;
      return 0;
      }
   tsk_current->set_retptr(NULL);
   tsk_wait (&waiting, timeout);
   return (int)tsk_current->get_retptr();
}


/*
   c_request_resource - If the resource is free on entry, it is assigned 
                        to the task, otherwise an error status is returned.
*/

int far resource::c_request_resource (void)
{
   int rv;
   CRITICAL;

   C_ENTER;
   if (rv = state)
      {
      state = 0;
      owner = tsk_current;
      }
   C_LEAVE;
   return (rv) ? 0 : -1;
}


/*
   release_resource - Release the resource. If there are tasks waiting for
                      the resource, it is assigned to the first waiting
                      task, and the task is made eligible.
*/

void far resource::release_resource (void)
{
   tcbptr curr;
   CRITICAL;

   if (owner != tsk_current)
      return;

   C_ENTER;
   if ((curr = waiting) == NULL)
      {
      state = 1;
      owner = NULL;
      C_LEAVE;
      return;
      }

   waiting = curr->tsk_runable ();
   owner = curr;
   C_LEAVE;
}


/*
   check_resource - returns 1 if the resource is available.
*/

int far resource::check_resource (void)
{
   return state;
}


int far asm_request_resource(resourceptr rsc, dword timeout)
{
    return rsc->request_resource(timeout);
}



void far asm_release_resource(resourceptr rsc)
{
    rsc->release_resource();
}

