#ifndef DECOMPRESS_CLS
#define DECOMPRESS_CLS

#ifdef __VMS
#define CHAR_IS_DISTINCT
#define VMS
#endif

#include <fstream.h>
// #include "type.h"

class cpifstream : public ifstream
	{
#ifdef VMS
		typedef unsigned char   uchar;
		typedef   signed char   schar;
		typedef unsigned short  uint;
		typedef   signed short  sint;

#else
		typedef unsigned char uchar;
		typedef   signed char schar;
		typedef unsigned int uint;
		typedef   signed int sint;
#endif

	public:
      const enum justify { CBUF_SIZE   = 16384,
                           HASH_LEN    = 4096 };

		cpifstream(void);
		cpifstream(const char *fn);
		~cpifstream();

		cpifstream& operator>> (char& c)			{getbuf(&c,sizeof(char)); return *this;};
		cpifstream& operator>> (short& s)			{getbuf(&s,sizeof(short)); return *this;};
		cpifstream& operator>> (int& i)			{getbuf(&i,sizeof(int)); return *this;};
		cpifstream& operator>> (long& l)			{getbuf(&l,sizeof(long)); return *this;};
		cpifstream& operator>> (float& f)			{getbuf(&f,sizeof(float)); return *this;};
		cpifstream& operator>> (double& d)			{getbuf(&d,sizeof(double)); return *this;};
		cpifstream& operator>> (long double& ld)	{getbuf(&ld,sizeof(long double)); return *this;};

		cpifstream& read(schar* s, int n)		{getbuf(s,n); return *this;};
		cpifstream& read(uchar* s, int n)	{getbuf(s,n); return *this;};
		cpifstream& operator>> (char *s);

		int get(void);
		int peek(void);
		int gcount(void) {int c=count; count=0; return c;};

		cpifstream& get(schar* s, int len, char c='\n')			{getbuf2((uchar *)s,len,c); return *this;};
		cpifstream& get(uchar* s, int len, char c='\n')   {getbuf2(s,len,c); return *this;};
#ifdef CHAR_IS_DISTINCT
		cpifstream& get(char*  s, int len, char c='\n')   {getbuf2((uchar *)s,len,c); return *this;};
#endif
		cpifstream& get(schar& c)							{c=get(); return *this;};
		cpifstream& get(uchar& c)							{c=get(); return *this;};
#ifdef CHAR_IS_DISTINCT
		cpifstream& get(char&  c)			{c=get(); return *this;};
#endif
		cpifstream& getline(schar* s, int len, char c='\n')		{getbuf2((uchar *)s,len,c,1); return *this;};
		cpifstream& getline(uchar* s, int len, char c='\n')		{getbuf2(s,len,c,1); return *this;};
#ifdef CHAR_IS_DISTINCT
		cpifstream& getline(char*  s, int len, char c='\n')		{getbuf2((uchar *)s,len,c,1); return *this;};
#endif
		cpifstream& ignore(int n=1, int delim=EOF);

        void open(const char *fn);
		int done(void) {return all_done;};
		filebuf* close(void);

// The following functions are defined so that they are NO OP's:

		cpifstream& putback(char) {return *this;};
		cpifstream& seekg(long) {return *this;};
		cpifstream& seekg(long, ios::seek_dir) {return *this;};

// ---

	private:

		void init(void);
		void clear(void);
		void decode(void);
		void getbuf(void* v, int l);
		void getbuf2(uchar* s, int l, char delim, char ed=0);
        sint decompress(uchar *inbuff, uint inbuff_len, uchar *outbuff);

		  uchar *inbuf;               // input buffer
		uchar *outbuf;				// output buffer after compression
		uint idx;					// output buffer index
        sint o_len;             // output buffer length
		uint all_done;
		uint count;
	};

#endif
