#include <stdio.h>
#include <stdlib.h>
#include "compress.h"

#ifdef DEBUG_MALLOC
#include <malloc.h>
#include <m$debug.h>
#endif

cpofstream::cpofstream(void) : idx(0)
	{
    inbuf = NULL;
	 outbuf = NULL;
    hash_table = NULL;
    }


cpofstream::cpofstream(const char *fn) : idx(0)
	{
    inbuf = NULL;
    outbuf = NULL;
    hash_table = NULL;
    init();         // allocate space for buffers
    remove(fn);     // make sure file gets proper attributes (VMS issue)
#ifdef VMS
	ofstream::open(fn, ios::out);
#else
	ofstream::open(fn, ios::binary | ios::out);
#endif
	}


cpofstream::~cpofstream()
	{
	flush();
	clear();
	}


void cpofstream::fillbuf(void* v, int l)
	{
	char *a;

	while (l--)
		{
		inbuf[idx]=*(char*)v;
		  if (++idx==cpofstream::CBUF_SIZE)
			encode();
			a = (char *)v;
			*a++;
			v = (void *)a;
//			char*)v)++;
		}
	}


cpofstream& cpofstream::operator<<(const char *s)
	{
	while (*s)
		{
		inbuf[idx]=*s;
        if (++idx==cpofstream::CBUF_SIZE)
			encode();
		s++;
		}
	inbuf[idx]=*s;			// have to do NULL also
	 if (++idx==cpofstream::CBUF_SIZE)
		encode();
	return *this;
	}


cpofstream& cpofstream::operator<<(void* v)
	{
	unsigned long l=(unsigned long)v;
	fillbuf(&l,sizeof(unsigned long));
     return *this;
	}


void cpofstream::open(const char *fn)
	{
	 init();                 // allocate space for buffers if needed
#ifdef VMS
	ofstream::open(fn, ios::out);
#else
	ofstream::open(fn, ios::binary | ios::out);
#endif
	}


filebuf* cpofstream::close(void)
	{
	flush();
//    clear();                    // deallocate buffers
//    return rdbuf()->close();
	 ofstream::close();
	 clear();
	 return rdbuf();
	 }


cpofstream& cpofstream::flush(void)
	{
    if(hash_table != NULL) {    //If NULL then stream has been closed
        if (idx)
            {
            encode();
            }
        ofstream::write((char*)&idx,sizeof(uint));           // write EO(compressed)F
        reset();
    }
    return *this;
	}


void cpofstream::encode(void)
	{
	sint n=compress(inbuf, idx, outbuf, hash_table, HASH_LEN);
	 ofstream::write((char*)&n,sizeof(sint));
//    printf("n: %d  %d\n", n, idx);
    if (n<0)
		n=-n;
	ofstream::write((char *)outbuf,n);
	idx=0;
	}


void cpofstream::init(void)
	{
	 if(inbuf == NULL)
				 inbuf=new uchar[cpofstream::CBUF_SIZE];
	 if(outbuf == NULL)
				  outbuf=new uchar[cpofstream::CBUF_SIZE];
	 if(hash_table == NULL)
				  hash_table=new uchar*[cpofstream::HASH_LEN];
	if((inbuf == NULL) ||
		(outbuf == NULL) ||
	   (hash_table == NULL)) {
        cerr << "Error: Could not allocate memory for COMPSTRM\n";
		exit(1);
	}
	reset();
	}


void cpofstream::clear(void)
	{
#ifndef VMS
#ifdef DEBUG_MALLOC
	if( farheapcheck() == _HEAPCORRUPT ) {
		printf( "Heap is corrupted.\n" );
		exit(-1);
	}
#endif
#endif
	 if(inbuf != NULL)  delete [] inbuf;
	 if(outbuf != NULL) delete [] outbuf;
	 if(hash_table != NULL) delete [] hash_table;
	 inbuf = NULL;
	 outbuf = NULL;
	 hash_table = NULL;
	}


void cpofstream::reset(void)
	{
	if(hash_table != NULL) {
	 for (int i=0;i<cpofstream::HASH_LEN;i++)
		{
		hash_table[i]=0L;
		}
	}
	}
