#include <stdio.h>
#include <stdlib.h>
#include "decpress.h"
#ifdef DEBUG
#include <malloc.h>
#include <m$debug.h>
#endif

cpifstream::cpifstream(void) : idx(0), o_len(0), all_done(0), count(0)
	{
    inbuf = NULL;
    outbuf = NULL;
    }


cpifstream::cpifstream(const char *fn) : idx(0), o_len(0), all_done(0), count(0)
	{
    inbuf = NULL;
    outbuf = NULL;
    init();
#ifdef VMS
	ifstream::open(fn, ios::in);
#else
	ifstream::open(fn, ios::binary | ios::in);
#endif
	flags(0);			// clear all flags (especially the skip white space flag)
	}


cpifstream::~cpifstream()
	{
	clear();
	}


cpifstream& cpifstream::operator>>(char* s)
	{
char c;

	do
		{
		if (idx==o_len)
			decode();
		*s=c=outbuf[idx++];
		s++;
		count++;
		} while (c);
	return *this;
	}


cpifstream& cpifstream::ignore(int n, int delim)
	{
	if (!n)
		return *this;

     char c;
	do
		{
		c=get();
		} while ( (c!=delim) && (--n!=0) && (!all_done) );
	return *this;
	}


int cpifstream::get(void)
	{
	if (all_done)
		return EOF;

	uchar c;
	getbuf(&c,sizeof(uchar));
	count++;
	return c;
	}


int cpifstream::peek(void)
	{
	if (all_done)
		return EOF;

	if (idx==o_len)
		decode();
	return outbuf[idx];
	}


void cpifstream::open(const char *fn)
	{
	init();
#ifdef VMS
	ifstream::open(fn, ios::in);
#else
	ifstream::open(fn, ios::binary | ios::in);
#endif
	flags(0);			// clear all flags (especially the skip white space flag)
	all_done=0;
	}


filebuf* cpifstream::close(void)
	{
	clear();
    ifstream::close();
    return rdbuf();
	}


void cpifstream::init(void)
	{
    if(inbuf == NULL)
             inbuf=new uchar[cpifstream::CBUF_SIZE];
    if(outbuf == NULL)
              outbuf=new uchar[cpifstream::CBUF_SIZE];

    if((inbuf == NULL) ||
	   (outbuf == NULL)) {
        cerr << "Error: Could not allocate memory for COMPSTRM\n";
		exit(1);
	}
	}


void cpifstream::clear(void)
	{
	if(inbuf != NULL)  delete inbuf;
	if(outbuf != NULL) delete outbuf;
    inbuf = NULL;
    outbuf = NULL;
	}


void cpifstream::decode(void)
	{
	idx=0;
    o_len = 0;
    istream::read((char*)&o_len,sizeof(sint));

    if ((o_len==0) || istream::eof())
		{
		all_done=1;
		return;
		}

	if (o_len<0)
		{
 //       printf("o_len: %d\n", o_len);
        o_len=0-o_len;
        istream::read((char *)outbuf,o_len);
		}
	else
		{
		istream::read((char *)inbuf,o_len);
//        printf("o_len: %d  ", o_len);
        o_len=decompress(inbuf,o_len,outbuf);
//        printf("%d\n", o_len);
        }
	}


void cpifstream::getbuf(void* v, int n)
	{
	char *a;
	while (n--)
		{
		if (idx==o_len)
			decode();
		*(char*)v=outbuf[idx++];
		a = (char *)v;
		*a++;
		v = (void *)a;
//		((char*)v)++;
		count++;
		}
	}


void cpifstream::getbuf2(uchar* s, int l, char delim, char ed)
	{
	if (all_done)
		return;
	if (l<2)			// read l-1 bytes, so l must be 2 or more
		{
		*s='\0';
		return;
		}

	char c;
	do
		{
		if (!ed)						// if we aren't extracting the delimeter
			{
			if (peek()==delim)				// don't extract delimiter
				{
				s++;						// necessary for s-- outside of loop
				break;
				}
			}
		*s++=c=get();
		} while ( (c!=delim) && (--l!=0) && (!all_done) );
	s--;
	*s='\0';
	}
