#ifndef COMPRESS_CLS
#define COMPRESS_CLS

#ifdef __VMS
#define CHAR_IS_DISTINCT
#define VMS
#endif

#include <fstream.h>
// #include "type.h"

class cpofstream : public ofstream
	{
#ifdef VMS
		typedef unsigned char   uchar;
		typedef   signed char   schar;
		typedef unsigned short  uint;
		typedef   signed short  sint;

#else
		typedef unsigned char uchar;
		typedef   signed char schar;
		typedef unsigned int uint;
		typedef   signed int sint;
#endif

	public:
      const enum justify { CBUF_SIZE   = 16384,
                           HASH_LEN    = 4096 };

		cpofstream(void);
        cpofstream(const char *fn);
		~cpofstream();

		cpofstream& operator<< (char c)		{fillbuf(&c,sizeof(char)); return *this;};
		cpofstream& operator<< (short s)		{fillbuf(&s,sizeof(short)); return *this;};
		cpofstream& operator<< (int i)		{fillbuf(&i,sizeof(int)); return *this;};
		cpofstream& operator<< (unsigned int i)		{fillbuf(&i,sizeof(unsigned int)); return *this;};
		cpofstream& operator<< (long l)		{fillbuf(&l,sizeof(long)); return *this;};
		cpofstream& operator<< (float f)		{fillbuf(&f,sizeof(float)); return *this;};
		cpofstream& operator<< (double d)		{fillbuf(&d,sizeof(double)); return *this;};
		cpofstream& operator<< (long double ld)	{fillbuf(&ld,sizeof(long double)); return *this;};
		cpofstream& operator<< (const char *s);
		cpofstream& operator<< (void* v);

		cpofstream& put(char c) 						{fillbuf(&c,sizeof(char)); return *this;};
		cpofstream& write(schar* s, sint n)	{fillbuf(s,n); return *this;};
		cpofstream& write(uchar* s, sint n)	{fillbuf(s,n); return *this;};
#ifdef CHAR_IS_DISTINCT
        cpofstream& write(char*  s, sint n) {fillbuf(s,n); return *this;};
#endif
        void open(const char *fn);
		filebuf* close(void);
		cpofstream& flush(void);

// The following functions are defined so that they are NO OP's:

		cpofstream& seekp(long pos) {return *this;};
		cpofstream& seekp(long, ios::seek_dir) {return *this;};
// ---

	private:

		void init(void);
		void reset(void);
		void clear(void);
		void encode(void);
		void fillbuf(void* v, int l);
        sint compress(uchar *inbuff, uint inbuff_len, uchar *outbuff, uchar *hash_tbl[], uint hash_len);

        uchar *inbuf;               // input buffer
		uchar *outbuf;				// output buffer after compression
		uchar **hash_table;			// hash table
        uint idx;                    // input buffer index
	};

#endif
