/*
  Explode.C
  Copyright (c) 1994 Jeffrey C. Moxon, CIS: 73561,1431
  Formerly a GIF file reader published in 'Bitmapped Graphics' by Steve Rimmer
  Return Value:
                0  Ok
                1  Files not ready
                2  Unexpected EOF
                3  Bad first code
                4  Bad LZW code
                5  Insufficient memory
*/

#include <malloc.h>
#include <stdio.h>

#define bits   8

 unsigned char far *firstcodestack;  /* Stack for first codes */
 unsigned char far *lastcodestack;  /* Statck for previous code */
 int far *codestack;  /* Stack for links */
 int far *wordmasktable;

/* Default functions in compress.c */
 extern void far disp_per(int cper);

  /* Pointer for percentage meter */
 extern void far (*_display_percent)(int);

 int unstore(FILE *sf, FILE *tf, int per_disp,  int s_per, int pw_byte);
 int load_block(FILE *sf, char far *buff);

 /* Random Number functions and variables */
 extern void set_seed(int seed);
 extern int  rnd(int range);
 extern long _XXX_SEED;    //RND generator
 extern void crypt(char far *string, int len);  //Set random seed, then call


int explode(
             FILE *sf,                         //Source File pointer
              FILE *tf,                        //Target File pointer
               int per_disp,                   //Percent intervals
                int s_per,                     //Starting percentage
		 int pw_byte)                  //Encryption byte
{
 int here;
 int bits2;
 int codesize;
 int codesize2;
 int nextcode;
 int thiscode;
 int oldtoken;
 int current_code;
 int old_code;
 int bitsleft;
 int c_per;
 int ret_val = 0;
 long OLD_XXX;

 unsigned long ten_percent;
 unsigned long c_pos;

 unsigned char b[255];
 unsigned char far *u;
 unsigned char far *p;
 unsigned char far *q;

 if (sf == NULL || tf == NULL)
  return(1);

 if (_display_percent == NULL)
     _display_percent = disp_per;

 /* Set random seed */
 OLD_XXX = _XXX_SEED;
 if (pw_byte)
  set_seed(pw_byte);
 else
  _XXX_SEED = 0;

 //Read in method of store
 here = fgetc(sf);

 if (here == 0x00)
 {
  ret_val = unstore(sf, tf, per_disp, s_per, pw_byte);
  goto done;
 }

   firstcodestack = calloc(4096, 1);
   lastcodestack = calloc(4096, 1);
   codestack = calloc(4096, 2);
   wordmasktable = calloc(16, 2);

  if (firstcodestack == NULL || lastcodestack == NULL ||
       codestack == NULL || wordmasktable == NULL)
  {
   ret_val = 5;
   goto done;
  }

 //Read in file's size
 fread(&ten_percent, sizeof(long), 1, sf);

 //Calculate 10 percent for display
 ten_percent = (long) ten_percent * per_disp;
 ten_percent /= 100;

 here = 0;
 p=q=b;
 bitsleft = 8;
 c_pos = 0;
 c_per = s_per;

 bits2 = 1 << bits;
 nextcode = bits2 + 2;
 codesize2 = 1 << (codesize = bits + 1);
 old_code=oldtoken=-1;


 wordmasktable[0] =  0x0000;
 wordmasktable[1] =  0x0001;
 wordmasktable[2] =  0x0003;
 wordmasktable[3] =  0x0007;
 wordmasktable[4] =  0x000f;
 wordmasktable[5] =  0x001f;
 wordmasktable[6] =  0x003f;
 wordmasktable[7] =  0x007f;
 wordmasktable[8] =  0x00ff;
 wordmasktable[9] =  0x01ff;
 wordmasktable[10] =  0x03ff;
 wordmasktable[11] =  0x07ff;
 wordmasktable[12] =  0x0fff;
 wordmasktable[13] =  0x1fff;
 wordmasktable[14] =  0x3fff;
 wordmasktable[15] =  0x7fff;


   // loop until something breaks
   for(;;)
   {
     if(bitsleft==8)
     {
      if(++p >= q)
       if ((q = (p = b) + load_block(sf, b)) < b)
       {
        ret_val = 2;
        goto done;
       }
      bitsleft = 0;
     }
     thiscode = *p;
     if ((current_code=(codesize+bitsleft)) <= 8)
     {
	*p >>= codesize;
	bitsleft = current_code;
     }
     else
     {
            if(++p >= q)
             if ((q = (p = b) + load_block(sf, b)) < b)
             {
              ret_val = 2;
              goto done;
             }

	     thiscode |= *p << (8 - bitsleft);
	     if(current_code <= 16) *p >>= (bitsleft=current_code-8);
	     else
	     {
                     if(++p >= q)
                      if ((q = (p = b) + load_block(sf, b)) < b)
                      {
                       ret_val = 2;
                       goto done;
                      }

		     thiscode |= *p << (16 - bitsleft);
		     *p >>= (bitsleft = current_code - 16);
	     }
     }
     thiscode &= wordmasktable[codesize];
     current_code = thiscode;

     if(thiscode == (bits2+1)) break;   // found EOI
     if(thiscode > nextcode)   //Error
     {
      ret_val = 3;
      goto done;
     }

     if(thiscode == bits2)
     {
	     nextcode = bits2 + 2;
	     codesize2 = 1 << (codesize = (bits + 1));
	     oldtoken = old_code = -1;
	     continue;
     }

     u = firstcodestack;

     if(thiscode==nextcode)
     {
	     if(old_code==-1)   //Error
             {
              ret_val = 4;
              goto done;
             }

	     *u++ = oldtoken;
	     thiscode = old_code;
     }

     while (thiscode >= bits2)
     {
	     *u++ = lastcodestack[thiscode];
	     thiscode = codestack[thiscode];
     }

      oldtoken = thiscode;

      do
      {
	if (here)
        {
	 fputc(thiscode, tf);
	   if (c_pos++ >= ten_percent)
	   {
	     _display_percent(c_per);
             c_per += per_disp;
             //Reset counter
	     c_pos = 0;
	    }

          }
	if (u <= firstcodestack) break;
       thiscode = *--u;
      } while(1);

      here = 1;

     if(nextcode < 4096 && old_code != -1)
     {
	     codestack[nextcode] = old_code;
	     lastcodestack[nextcode] = oldtoken;
	     if (++nextcode >= codesize2 && codesize < 12)
		 codesize2 = 1 << ++codesize;
     }
     old_code = current_code;
   }

 fflush(tf);
 _display_percent(100);

 done:

   if (firstcodestack != NULL) free(firstcodestack);
   if (lastcodestack != NULL) free(lastcodestack);
   if (codestack != NULL) free(codestack);
   if (wordmasktable != NULL) free(wordmasktable);

  _XXX_SEED = OLD_XXX;
 return(ret_val);
}

int unstore(FILE *sf, FILE *tf, int per_disp, int s_per, int pw_byte)
{
 int c;
 long percent;
 long c_pos;
 int c_per;

 c_pos = 0;
 c_per = s_per;

 _display_percent(0);
 fread(&percent, sizeof(long), 1, sf);

  //Calculate percentage at which to call disp_percent
 percent = (long) percent * per_disp;
 percent /= 100;

 while((c=fgetc(sf)) != EOF)
 {
  if (pw_byte)
   c ^= rnd(21531);

  fputc(c, tf);

   if (c_pos++ >= percent)
   {
    _display_percent(c_per);
    c_per += per_disp;
    c_pos = 0;
   }
 }

 _display_percent(100);
 return(0);  //Ok
}

int load_block(FILE *sf, char far *buff)
{
 register int block_size, num;

 block_size = fgetc(sf);

 if (block_size < 1) return(block_size);

 num = fread(buff, 1, block_size, sf);

 if (_XXX_SEED)
  crypt(buff, block_size);

return(num);
}
