/*

  Compress.c
  Copyright (c) 1994 Jeffrey C. Moxon, CIS: 73561,1431
  Formerly a GIF file writer published in 'Bitmapped Graphics' by Steve Rimmer

  Return Values:
                  0  File compressed ok
                  1  File stored
		  2  File was enlarged
		  3  Source file !Found
		  4  Target file !Found
                  5  Insufficient Memory
*/

#include <io.h>
#include <malloc.h>
#include <stdio.h>


#define largest_code    4095
#define table_size      5003
#define min_code_size   8

 int far *oldcode;
 int far *current_code;
 unsigned char far *newcode;

 int code_size;
 int clear_code;
 int eof_code;
 int bit_offset;
 int max_code;
 int free_code;
 int flush_code;  /* Set to 1 in flush */

 unsigned char far *code_buffer;
 long bytes_written;

 /* Default functions */
 void init_table(int far *current_code);
 void far disp_per(int cper) { if (cper); };  //<- World's smallest fcns!
 int far di_err(int fno) { if (fno); return(0);}; //These are just dummies in case no meter fcn is defined

 int store(FILE *sf, FILE *tf, int per_disp, int s_per, int pw_byte);
 void write_code(int code, FILE *tf);
 void flush(FILE *tf, int n);

 /* Random Number functions and variables */
 extern void set_seed(int seed);
 extern int  rnd(int range);
 extern long _XXX_SEED;    //RND generator
 extern void crypt(char far *string, int len);  //Set random seed, then call

 /* Pointer for percentage meter */
 void far (*_display_percent)(int);

int compress(
             FILE *sf,                          //Source File pointer
              FILE *tf,                         //Target File pointer
               int per_disp,                   //Percent intervals
                int s_per,                     //Starting percentage
		 int pw_byte)                  //Encryption seed
{

 int prefix_code;
 int suffix_char;
 int hx,d;
 long OLD_XXX;
 long percent;
 long c_pos, t_pos;
 long read = 0;
 int  num_larger = 0, num_flushed = 0;

 int c_per, ret_val = 0;

 if (sf == NULL || tf == NULL)
  return(3);

 if (_display_percent == NULL)
     _display_percent = disp_per;

  //Store position of target file in case we can't compress
  t_pos = ftell(tf);

  /* Allocate memory blocks */
   oldcode = calloc(table_size, 2);
   current_code = calloc(table_size, 2);
   newcode = calloc(table_size, 1);
   code_buffer = calloc(259, 1);

   if (oldcode == NULL || current_code == NULL ||
       newcode == NULL || code_buffer == NULL)
   {
    ret_val = 5;
    goto done;
   }

  /* write the file's original size */
  percent = filelength(fileno(sf));

  /* Store small files */
  if (percent < 250)
  {
   ret_val = store(sf, tf, per_disp, s_per, pw_byte);
   goto done;
  }

  //Indicate compression
  fputc(0x1, tf);

  fwrite(&percent, sizeof(long), 1, tf);


  //Make notice that we haven't flushed buffer yet
  flush_code = 0;
  bytes_written = 0;

  //Calculate percentage at which to call disp_percent
  percent = (long) percent * per_disp/100;

  c_pos = 0;
  c_per = s_per;

  rewind(sf);

  _display_percent(c_per);

  c_per = per_disp;

  /* Set random seed */
  OLD_XXX = _XXX_SEED;
  if (pw_byte)
   set_seed(pw_byte);
  else
   _XXX_SEED = 0;

	/* initialize the encoder */
	bit_offset=0;

	/* initialize the prefix */
	prefix_code = 0;
	init_table(current_code);

	/* get a character to compress */
	while((suffix_char = fgetc(sf)) != EOF)
	{
         read++;
	  if (c_pos++ >= percent)
	  {
	    _display_percent(c_per);

           /*
             Check to see if we are actually compressing the data, or if we
             are trying to compress LZW data.  This is tricky since the data
             does not exhibit any set behavior.  Usually, between 4 and 6
             flushes are needed to be sure.
           */

           if (num_flushed < 5 && flush_code)
           {
            flush_code = 0;
            num_flushed++;
            if (bytes_written > read) num_larger++;

            if (num_flushed > 3 && num_larger >= 2)
            {
             fseek(tf, t_pos, SEEK_SET);
	     ret_val = store(sf, tf, per_disp, s_per, pw_byte);
             goto done;
            }
           }

            c_per += per_disp;

           //Reset counter
	   c_pos = 0;
	  }

	  /* derive an index into the code table */
	  hx=(prefix_code ^ (suffix_char << 5)) % table_size;
	  d=1;

	  for(;;)
	  {
	   /* see if the code is in the table */
	   if(current_code[hx] == 0)
	   {

	     /* if not, put it there */
	     write_code(prefix_code, tf);
	     d = free_code;

	     /* find the next free code */
	     if(free_code <= largest_code)
	     {
		     oldcode[hx] = prefix_code;
		     newcode[hx] = suffix_char;
		     current_code[hx] = free_code;
		     free_code++;
	     }

	     /* expand the code size or scrap the table */
	     if(d == max_code)
	     {
		     if(code_size < 12)
		     {
		      code_size++;
		      max_code <<= 1;
		     }
		     else
		     {
		      write_code(clear_code, tf);
	              init_table(current_code);
		     }
	     }
	     prefix_code = suffix_char;
	     break;
	   }
	   if(oldcode[hx] == prefix_code && newcode[hx] == suffix_char)
	   {
		   prefix_code = current_code[hx];
		   break;
	   }
	   hx += d;
	   d += 2;
	   if(hx >= table_size) hx -= table_size;
	  }
        }

	/* write the prefix code */
	write_code(prefix_code, tf);

	/* and the end of file code */
	write_code(eof_code, tf);

	/* flush the buffer */
	if(bit_offset > 0) flush(tf, (bit_offset+7)/8);

	/* write a zero length block */
	flush(tf, 0);

        _display_percent(100);

 fseek(sf, 0, SEEK_END);
 fflush(tf);

done:

   if (oldcode != NULL) free(oldcode);
   if (current_code != NULL) free(current_code);
   if (newcode != NULL) free(newcode);
   if (code_buffer != NULL) free(code_buffer);

 _XXX_SEED = OLD_XXX;
 return(ret_val);        //OK
}


/* flush the code buffer */
void flush(FILE *tf, int n)
{

        if (_XXX_SEED)
         crypt(code_buffer, n);

	fputc(n,tf);
	fwrite(code_buffer,1,n,tf);

        bytes_written += n;
        flush_code = 1;

return;
}

/* write a code to the code buffer */
void write_code(int code, FILE *tf)
{
 long temp;
 int byte_offset, bits_left;

	byte_offset = bit_offset >> 3;
	bits_left = bit_offset & 7;

	if(byte_offset >= 254)
	{
		flush(tf, byte_offset);
		code_buffer[0] = code_buffer[byte_offset];
		bit_offset = bits_left;
		byte_offset = 0;
	}

	if(bits_left > 0)
	{
		temp = ((long) code << bits_left) | code_buffer[byte_offset];
		code_buffer[byte_offset]=temp;
		code_buffer[byte_offset+1]=(temp >> 8);
		code_buffer[byte_offset+2]=(temp >> 16);
	}
	else
	{
		code_buffer[byte_offset] = code;
		code_buffer[byte_offset+1]=(code >> 8);
	}
	bit_offset += code_size;

return;
}

 /* initialize the code table */
void init_table(int far *current_code)
{
 int i;
       code_size = min_code_size + 1;
       clear_code = (1 << min_code_size);
       eof_code = clear_code + 1;
       free_code = clear_code + 2;
       max_code = (1 << code_size);

       for(i = 0;i < table_size; i++)
        current_code[i] = 0;

return;
}

//Simply copy file
int store(FILE *sf, FILE *tf, int per_disp, int s_per, int pw_byte)
{
 int c;
 long percent;
 long c_pos;
 int c_per;

 c_pos = 0;
 c_per = s_per;

 //We should be at the point where we started writing
 percent = ftell(tf);
 chsize(fileno(tf), percent);

 _display_percent(0);

 //Indicate method of store
 fputc(0, tf);

 /* Write the files size */
 percent = filelength(fileno(sf));
 fwrite(&percent, sizeof(long), 1, tf);

  //Calculate percentage at which to call disp_percent
 percent = (long) percent * per_disp/100;

 rewind(sf);

 while((c = fgetc(sf)) != EOF)
 {
  if (pw_byte)
   c ^= rnd(21531);

  fputc(c, tf);

   if (c_pos++ >= percent)
   {
    _display_percent(c_per);
    c_per += per_disp;
    c_pos = 0;
   }
 }

  _display_percent(100);
 fflush(tf);
 return(1);  //Ok
}


