/*
  Compress file function.
*/

#include <conio.h>
#include <io.h>
#include <stdio.h>
#include <string.h>

extern void far (*_display_percent)(int);

extern int compress(
                    FILE *sf,                          //Source File pointer
                     FILE *tf,                         //Target File pointer
                      int per_disp,                    //Percent intervals
                       int s_per,                      //Starting percentage
		        int pw_byte);                  //Encryption seed

extern int explode(
                   FILE *sf,                         //Source File pointer
                    FILE *tf,                        //Target File pointer
                     int per_disp,                   //Percent intervals
                      int s_per,                     //Starting percentage
		       int pw_byte);                 //Encryption byte

void display_dots(int percent);

void main(int argc, char *argv[])
{
 FILE *sf;
 FILE *tf;

 strupr(argv[1]);
 strupr(argv[2]);
 strupr(argv[3]);

 if (argc != 4 || (argv[1][1] != 'C' && argv[1][1] != 'E'))
 {
  printf("Usage:  <operation>  <source>  <dest>\n");
  printf("Where operation is either -C to compress or -E to expand.\n");
  return;
 }

 if (access(argv[2], 4) != 0)
 {
  printf("Error accessing source file:  %s\n", argv[2]);
  return;
 }

 if (access(argv[3], 0) == 0)
 {
  printf("Destination already exists:  %s\n", argv[3]);
  return;
 }

 sf = fopen(argv[2], "rb");
 setvbuf(sf, NULL, _IOFBF, 8192);
 tf = fopen(argv[3], "w+b");
 setvbuf(sf, NULL, _IOFBF, 8192);

 printf("%s -> %s\n", argv[2], argv[3]);

 _display_percent = display_dots;

 if (argv[1][1] == 'C')
  argc = compress(sf, tf, 10, 0, 0);
 else
 {
  argc = explode(sf, tf, 10, 0, 0);
  fclose(sf);
  if (argc) unlink(argv[3]);
 }

 flushall();
 fcloseall();

 printf("\nReturn code:  %i\n", argc);

return;
}

void display_dots(int percent)
{

 if (percent < 100) putch('.');

return;
}