
#define MAXBAUD 115200L   /* This is the theoretical maximum Baud rate of  */
                          /* the 8250 UART used in the IBMPC.              */
                          /* In actuality the 8086 will not handle large   */
                          /* transfers of data at much above 9600. I'm     */
                          /* not real sure where the drop dead point is.   */
                          /* In testing the 8086 handled conversational    */
                          /* at 19200, but croked when asked to handle a   */
                          /* small file being typed. So keep it at 9600 or */
                          /* less.                                         */

/*
 * Communications port selection constants.
 */

#define COM1_PORT      0
#define COM2_PORT      1
#define COM3_PORT      2
#define COM4_PORT      3

/*
 * Parity settings for the 8250 UART.
 */

#define ODD_PARITY      1 /* Parity bit=1 if number of 1 bits in data is even */
#define NO_PARITY       2 /* No Parity bit generated. Also called NONE        */
#define EVEN_PARITY     3 /* Parity bit=1 if number of 1 bits in data is odd  */
#define MARK_PARITY     5 /* Parity bit always 1.                             */
#define SPACE_PARITY    7 /* Parity bit always 0.                             */

/*
 * Data Length settings for the 8250 UART.
 */

#define BITS_5          0
#define BITS_6          1
#define BITS_7          2
#define BITS_8          3

/*
 * Stop bit settings for the 8250 UART.
 */

#define STOP_1          0
#define STOP_2          1         /* If Data Length is 5 this setting */
                                  /* is for 1.5 stop bits. Otherwise  */
                                  /* it generates 2 stop bits.        */

/*
 * These are signals and addresses in the 8259 interrupt controller that
 * interfaces with the 8250 UART. They are not the same thing, but are
 * in the same subsystem. Not that it matters much, but this may keep you
 * from sounding stupid someday (like I do all the time).
 */

#define EOI             0x20      /* 8259 End of Interrupt signal.            */
#define ICR             0x20      /* 8259 Interrupt control Register          */
#define IMR             0x21      /* 8259 Interrupt mask Register             */

/*
 * Prototypes of communications support functions
 */

/*
 *  This routine sets the COM port for the right baud rate, parity,
 *  stop bits, data length, and xon/xoff flow control. It also allocates
 *  memory for the circular input buffer (combuf)
 */

void comopen (int port, long baud_rate, int parity,
              int stopbits, int data_len, int flw_flg);
/*
 * This routine releases the communications port and disables the IRQ.
 */

void comclose (int port);

/*
 * This routine gets a character from the circular buffer and clears an
 * XOFF (if on) when the buffer reaches a manageable level. A -1 is
 * returned if the buffer is empty;
 */

int combrd(int port);

/*
 * This routine will return characters from the combuff until it hits
 * one of the specified delimiters or the number characters = maxchrs or
 * timeout (upto 32767) seconds has passed. The target string will be
 * NUL terminated. The routine returns 0 = delimeter found, 1 = maxchrs
 * reached, or 2 = timed out. You must allocate at least maxchrs + 1
 * characters for your target string. The number of characters read is
 * returned in the int pointed to by maxchrs.
 */

int comswrd(int port, char *s, char *delims, int * maxchrs, int timeout);

/*
 * This routine will return characters from the combuff until it hits
 * one of the specified delimiters up to maxchrs. The target string will
 * be NUL terminated. Be aware that the NUL character is an implicit
 * delimiter. If no delimiter is found (maybe because it hasn't been
 * transmitted yet) you will get whatever is currently in the buffer
 * (upto maxchars). If the combuff is empty you will get back an empty
 * string. The routine returns 0 = delimiter found, 1 = maxchrs reached,
 * 2 = read until buffer empty without finding a delimiter.
 * Consider this a nowait string read (also called a greedy read).
 * You must allocate at least maxchrs + 1 characters for your target string.
 * The number of characters read are returned in the int pointed to by maxchrs
 */

int comsrd(int port, char *s, char *delims, int * maxchrs);

/*
 * This routine will return characters from the combuff until it hits
 * one of the specified delimiters (Not NUL) or the number of
 * characters = maxchrs or timeout (upto 32767) seconds has passed.
 * The routine returns 0 = delimeter found, 1 = maxchrs reached,
 * or 2 = timed out. The number of characters read is returned in
 * the int pointed to by maxchrs.
 */

int commwrd (int    port,
             char * s,
             char * delims,
             int  * maxchrs,
             int    timeout);

/*
 * This routine will return characters from the combuff until it hits
 * one of the specified delimiters up to maxchrs (Note: NUL is not a
 * valid delimiter here).
 * If no delimiter is found (maybe because it hasn't been
 * transmitted yet) you will get whatever is currently in the buffer
 * (upto maxchars). If the combuff is empty you will get back an empty
 * string. The routine returns 0 = delimiter found, 1 = maxchrs reached,
 * 2 = read until buffer empty without finding a delimiter.
 * Consider this a nowait block read (also called a greedy read).
 * The number of characters read are returned in the int pointed to
 * by maxchrs.
 */

int commrd (int port, char *s, char *delims, int * maxchrs);

/*
 * This routine puts a character out the COM port.
 */

void combwrt(int port, int c);

/*
 * This routine sends a NUL terminated string out the COM port.
 * It returns the number of characters written.
 */

int comswrt(int port, char *s);

/*
 * This routine writes the specified number of characters to the
 * specified port. It returns the number of characters written.
 */

int commwrt (int port, char *s, int ch_cnt);
