#define     _CLASSDLL
#include    <owl.h>
#include    <inputdia.h>
#include    <string.h>
#include    <stdlib.h>
#include    <stdio.h>
#include    <dos.h>
#pragma     hdrstop

//#define     _LF32
#include    "commdlg.h"
#include    "dlgtest.h"


///////////////////////////////////////////////////////////
//
//  Foreward References
//
///////////////////////////////////////////////////////////

_CLASSDEF(TDlgTestWin)
class TDlgTestWin;
_CLASSDEF( TCommDlg )
class TCommDlg;
_CLASSDEF( TGetOpenFileName )
class TGetOpenFileName;
_CLASSDEF( TGetSaveFileName )
class TGetSaveFileName;
_CLASSDEF( TPrintDlg )
class TPrintDlg;
_CLASSDEF( TChooseFont )
class TChooseFont;

LPSTR ConvertList(LPSTR);

#define Print(f, t, d) { char s[256]; \
                         sprintf(s,"%30.30s : "##f,t,d); \
                         pTDW->WriteLn(DC, (LPSTR)s);}
#define Print2(f, t, d1, d2) { char s[256]; \
                         sprintf(s,"%30.30s : "##f,t,d1,d2); \
                         pTDW->WriteLn(DC, (LPSTR)s);}


///////////////////////////////////////////////////////////
//
//  class TDlgTestWin, declarations
//
///////////////////////////////////////////////////////////

class TDlgTestWin : public TWindow
{
int         x, y;       // track TextOut position.

PTCommDlg   pcd;
PTGetOpenFileName ptgofn;
PTGetSaveFileName ptgsfn;
PTPrintDlg ptpd;
PTChooseFont ptcf;

public:

// Constructor
TDlgTestWin(PTWindowsObject AParent, LPSTR ATitle);

void GetWindowClass(WNDCLASS _FAR &);

// Commands
void CMGetOpenFileName( RTMessage ) = [CM_FIRST + CM_FILE_GOFN];
void CMGetSaveFileName( RTMessage ) = [CM_FIRST + CM_FILE_GSFN];
void CMPrintDlg( RTMessage ) = [CM_FIRST + CM_FILE_PRINT];
void CMChooseFont( RTMessage ) = [CM_FIRST + CM_OPT_CHOOSE_FONT];
void CMInvoke ( RTMessage ) = [CM_FIRST + CM_INVOKE];
void CMShowError ( RTMessage ) = [CM_FIRST + CM_SHOWERROR];
void CMGetFlags(RTMessage) = [CM_FIRST + CM_GETFLAGS];

// Paint and its utilities

virtual BOOL Write(HDC DC, LPSTR txt);
virtual BOOL WriteLn(HDC DC, LPSTR txt);
virtual void Paint(HDC DC, PAINTSTRUCT&);

};      // TDlgTestWin


///////////////////////////////////////////////////////////
//
//  virtual class TCommDlg - class to contain CommDlg structures,
//                  and their invokation and painting methods, etc.
//
///////////////////////////////////////////////////////////

_CLASSDEF( TCommDlg )
class TCommDlg
{
protected:
HWND            HWindow;
DWORD           Flags;
DWORD           Error;

public:
TCommDlg(HWND hWnd)
    {HWindow = hWnd; Flags=0L; Error=0L;}

virtual BOOL Invoke() = 0;      // calls COMMDLG.DLL
virtual BOOL Paint(PTDlgTestWin pTDW, HDC DC)
    {
    Print("%lu", "CommDlgExtendedError()", Error);
    pTDW->WriteLn(DC, " ");
    return TRUE;
    }

virtual char *nameOf() const {return "TCommDlg";}
virtual void UpdateError()  {Error = CommDlgExtendedError();}
virtual DWORD GetFlags() {return Flags;}
virtual void  SetFlags(DWORD f) {Flags=f;}
};      // TCommDlg


///////////////////////////////////////////////////////////
//
//  class TChooseFont : TCommDlg - handles ChooseFont()
//
///////////////////////////////////////////////////////////

_CLASSDEF( TChooseFont )
class TChooseFont : public TCommDlg
{
CHOOSEFONT    cf;
#ifdef _LF32
LOGFONT32     lf;
#else
LOGFONT       lf;
#endif
char          Style[256];

public:

//     Constructor
TChooseFont(HWND hWnd) : TCommDlg(hWnd)
{
memset(&cf,0,sizeof cf);
memset(&lf,0,sizeof lf);
cf.lStructSize = sizeof(CHOOSEFONT);
cf.hwndOwner = HWindow;
cf.hDC=0;
cf.lpLogFont=&lf;
cf.Flags=0;
cf.lpLogFont=&lf;
cf.rgbColors=0;
cf.lCustData=0;
cf.lpfnHook=NULL;
cf.lpTemplateName=NULL;
cf.hInstance=0;
cf.lpszStyle=(LPSTR)Style;
cf.nSizeMin=6;
cf.nSizeMax=12;
Style[0]='\0';
}          // Constructor

char *nameOf() const {return "TChooseFont";}

BOOL Invoke()
{
BOOL Ret; char b[33];
PRINTDLG  pd;

cf.Flags=Flags;
pd.lStructSize = sizeof(PRINTDLG);
pd.hwndOwner = HWindow;
pd.hDevMode = (HANDLE) NULL;
pd.hDevNames = (HANDLE) NULL;
pd.Flags = PD_RETURNDC | PD_RETURNDEFAULT;
pd.nFromPage = 0;
pd.hDC=0;
pd.nToPage = 0;
pd.nMinPage = 0;
pd.nMaxPage = 0;
pd.nCopies = 0;
pd.hInstance = (HANDLE) NULL;

if (PrintDlg(&pd) != 0) {
    if(pd.hDC)    {
        cf.hDC=pd.hDC;
        Ret=ChooseFont(&cf);
        cf.hDC=0;
        DeleteDC(pd.hDC);
        }
    else    MessageBox(HWindow, "PrintDlg() did not create device context",
                       "ChooseFont, PrintDlg() Error!", MB_OK);

    if (pd.hDevMode)
       GlobalFree(pd.hDevMode);
    if (pd.hDevNames)
       GlobalFree(pd.hDevNames);
}
else
    MessageBox(HWindow, ltoa(CommDlgExtendedError(),b,10),
                       "ChooseFont, PrintDlg() Error!", MB_OK);

return Ret;
}         // Invoke

BOOL Paint(PTDlgTestWin pTDW, HDC DC)
{
char    b[33];

TCommDlg::Paint(pTDW, DC);
Print("%lu", "DWORD lStructSize", cf.lStructSize);
Print("%d", "HWND hwndOwner", cf.hwndOwner);
Print("%d", "HDC hDC", cf.hDC);
pTDW->Write(DC,"Height:"); pTDW->Write(DC,itoa((WORD)lf.lfHeight,b,10));
pTDW->Write(DC,", Width:"); pTDW->Write(DC,itoa((WORD)lf.lfWidth,b,10));
pTDW->Write(DC,", Escapement:"); pTDW->Write(DC,itoa((WORD)lf.lfEscapement,b,10));
pTDW->Write(DC,", Orientation:"); pTDW->Write(DC,itoa((WORD)lf.lfOrientation,b,10));
pTDW->Write(DC,", Weight:"); pTDW->WriteLn(DC,itoa((WORD)lf.lfWeight,b,10));

if(lf.lfItalic) pTDW->Write(DC,"Italic ");
if(lf.lfUnderline) pTDW->Write(DC,"Underline ");
if(lf.lfStrikeOut) pTDW->Write(DC,"StrikeOut ");
switch (lf.lfCharSet) {
    case ANSI_CHARSET:
         pTDW->Write(DC,"ANSI_CHARSET ");
         break;

    case OEM_CHARSET:
         pTDW->Write(DC,"OEM_CHARSET ");
         break;

    case SYMBOL_CHARSET:
         pTDW->Write(DC,"SYMBOL_CHARSET ");
         break;

    case SHIFTJIS_CHARSET:
         pTDW->Write(DC,"SHIFTJIS_CHARSET ");
         break;

    default:
         pTDW->Write(DC,"unknown ");
    }

pTDW->Write(DC,", Prec:");
pTDW->Write(DC,itoa(lf.lfOutPrecision,b,10));
pTDW->Write(DC,", Clip:");
pTDW->Write(DC,itoa(lf.lfClipPrecision,b,10));
pTDW->Write(DC,", Qual:");
pTDW->Write(DC,itoa(lf.lfQuality,b,10));
pTDW->Write(DC,", Pit&Fam:");
pTDW->Write(DC,itoa(lf.lfPitchAndFamily,b,10));
pTDW->Write(DC,", ");
pTDW->Write(DC,(LPSTR) lf.lfFaceName);
pTDW->WriteLn(DC," ");

Print("%d", "int iPointSize", cf.iPointSize);
Print("%8.8lX", "DWORD Flags", cf.Flags);
Print("%8.8lX", "DWORD rgbColors", cf.rgbColors);
Print("\"%s\"", "LPSTR lpszStyle", cf.lpszStyle);
Print("%d", "int nFontType", cf.nFontType);

return TRUE;
}       // Paint

};         // TChooseFont


///////////////////////////////////////////////////////////
//
//  class TPrintDlg : TCommDlg - handles PrintDlg()
//
///////////////////////////////////////////////////////////

_CLASSDEF( TPrintDlg )
class TPrintDlg : public TCommDlg
{
PRINTDLG    pd;

public:

//     Constructor
TPrintDlg(HWND hWnd) : TCommDlg(hWnd)
{
pd.lStructSize = sizeof(PRINTDLG);
pd.hwndOwner = HWindow;
pd.hDevMode=NULL;
pd.hDevNames=NULL;
pd.hDC=0;
pd.Flags=0;
pd.nFromPage=0;
pd.nToPage=0;
pd.nMinPage=0;
pd.nMaxPage=9;
pd.nCopies=0;
pd.hInstance=NULL;
pd.lCustData=0;
pd.lpfnPrintHook=0;
pd.lpfnSetupHook=0;
pd.lpPrintTemplateName=NULL;
pd.lpSetupTemplateName=NULL;
pd.hPrintTemplate=0;
pd.hSetupTemplate=0;
}

char *nameOf() const {return "TPrintDlg";}

BOOL Invoke()
{
BOOL Ret;
pd.Flags = Flags;
if(pd.hDC) {DeleteDC(pd.hDC); pd.hDC=0;}
Ret = PrintDlg(&pd);
Error = CommDlgExtendedError();
return Ret;
}

BOOL Paint(PTDlgTestWin pTDW, HDC DC)
{
TCommDlg::Paint(pTDW, DC);
Print("%lu", "DWORD lStructSize", pd.lStructSize);
Print("%d", "HWND hwndOwner", pd.hwndOwner);
if(pd.hDevMode)      {
    PDEVMODE dm; char b[33];
    Print("%d = ", "HANDLE hDevMode", pd.hDevMode);
    if((dm=(PDEVMODE)GlobalLock(pd.hDevMode))!=NULL)    {
        pTDW->Write(DC,dm->dmDeviceName);
        pTDW->Write(DC,", SpecVer:");
        pTDW->Write(DC,itoa(dm->dmSpecVersion, b, 16));
        pTDW->Write(DC,", DrvVer: ");
        pTDW->WriteLn(DC,itoa(dm->dmDriverVersion, b, 16));
        pTDW->Write(DC,"dmSize - sizeof(DEVMODE):");
        pTDW->Write(DC,itoa(dm->dmSize-sizeof(DEVMODE),b,10));
        pTDW->Write(DC,", dmDriverExtra:");
        pTDW->Write(DC,itoa(dm->dmDriverExtra,b,10));
        pTDW->Write(DC,", Copies:");
        pTDW->Write(DC,itoa(dm->dmCopies,b,10));
        pTDW->Write(DC,", PrtQual:");
        pTDW->WriteLn(DC,itoa(dm->dmPrintQuality,b,10));
        GlobalUnlock(pd.hDevMode);
        }
    else pTDW->WriteLn(DC,"Could not GlobalLock(pd.hDevMode)!!!");
    }
else
    Print("%d", "HANDLE hDevMode", pd.hDevMode);

if(pd.hDevNames)      {
    PDEVNAMES dn; char b[33]; LPSTR p;
    Print("%d = ", "HANDLE hDevNames", pd.hDevNames);
    if((dn=(PDEVNAMES)GlobalLock(pd.hDevNames))!=NULL)    {
        p=(LPSTR)dn;
        pTDW->Write(DC,&p[dn->wDriverOffset]); pTDW->Write(DC,", ");
        pTDW->Write(DC,&p[dn->wDeviceOffset]); pTDW->Write(DC,", ");
        pTDW->Write(DC,&p[dn->wOutputOffset]); pTDW->Write(DC,", wDefault=");
        pTDW->WriteLn(DC,itoa(dn->wDefault,b,10));
        GlobalUnlock(pd.hDevNames);
        }
    else pTDW->WriteLn(DC,"Could not GlobalLock(pd.hDevNames)!!!");
    }
else
    Print("%d", "HANDLE hDevNames", pd.hDevNames);

Print("%d", "HANDLE hDC", pd.hDC);
Print("%8.8lX", "DWORD Flags", pd.Flags);
Print("%d", "WORD nFromPage", pd.nFromPage);
Print("%d", "WORD nToPage", pd.nToPage);
Print("%d", "WORD nMinPage", pd.nMinPage);
Print("%d", "WORD nMaxPage", pd.nMaxPage);
Print("%d", "WORD nCopies", pd.nCopies);
/*
    HANDLE  hInstance;
    DWORD   lCustData;
    FARPROC lpfnPrintHook;
    FARPROC lpfnSetupHook;
    LPSTR   lpPrintTemplateName;
    LPSTR   lpSetupTemplateName;
    HANDLE  hPrintTemplate;
    HANDLE  hSetupTemplate;
*/

return TRUE;
}

};      // TPrintDlg


///////////////////////////////////////////////////////////
//
//  class TGetOpenFileName : TCommDlg - handles GetOpenFileName()
//
///////////////////////////////////////////////////////////

_CLASSDEF( TGetOpenFileName )
class TGetOpenFileName : public TCommDlg
{
char            strFile[256],
                strTitle[96];
OPENFILENAME    ofn;

public:

//     Constructor
TGetOpenFileName(HWND hWnd) :
    TCommDlg(hWnd)
{
ofn.lStructSize = sizeof ofn;
ofn.hwndOwner = HWindow;
ofn.hInstance = NULL;
ofn.lpstrFilter = (LPSTR)"C files\0*.c\0Header files\0*.h\0";
ofn.lpstrCustomFilter = NULL;
ofn.nMaxCustFilter = NULL;
ofn.nFilterIndex = 1;
ofn.lpstrFile = (LPSTR)strFile;
ofn.nMaxFile = sizeof strFile;
ofn.lpstrFileTitle = (LPSTR)strTitle;
ofn.nMaxFileTitle = sizeof strTitle;
ofn.lpstrInitialDir = (LPSTR)NULL;
ofn.lpstrTitle = (LPSTR)NULL;
ofn.Flags = 0;
ofn.nFileOffset = 0;
ofn.nFileExtension = 0;
ofn.lpstrDefExt = (LPSTR)"def";
ofn.lCustData = 0;
ofn.lpfnHook = NULL;
ofn.lpTemplateName = NULL;
strFile[0] = '\0';
strTitle[0] = '\0';
}

char *nameOf() const {return "TGetOpenFileName";}

BOOL Invoke()
{
BOOL Ret;
ofn.Flags = Flags;
Ret = GetOpenFileName(&ofn);
Error = CommDlgExtendedError();
return Ret;
}

BOOL Paint(PTDlgTestWin pTDW, HDC DC)
{
TCommDlg::Paint(pTDW, DC);
Print("%lu", "DWORD lStructSize", ofn.lStructSize);
Print("%d", "HWND hwndOwner", ofn.hwndOwner);
Print("%d", "HANDLE hInstance", ofn.hInstance);
Print2("%04.4X:%04.4X =", "LPSTR lpstrFilter",
    FP_SEG(ofn.lpstrFilter), FP_OFF(ofn.lpstrFilter));
pTDW->Write(DC, "\""); pTDW->Write(DC, ConvertList(ofn.lpstrFilter));
pTDW->WriteLn(DC, "\"");
Print2("%04.4X:%04.4X =", "LPSTR lpstrCustomFilter",
    FP_SEG(ofn.lpstrCustomFilter), FP_OFF(ofn.lpstrCustomFilter));
pTDW->Write(DC, "\""); pTDW->Write(DC, ConvertList(ofn.lpstrCustomFilter));
pTDW->WriteLn(DC, "\"");
Print("%ld", "DWORD nMaxCustFilter", ofn.nMaxCustFilter);
Print("%ld", "DWORD nFilterIndex", ofn.nFilterIndex);
Print("\"%s\"", "LPSTR lpstrFile", ofn.lpstrFile);
Print("%ld", "DWORD nMaxFile", ofn.nMaxFile);
Print("\"%s\"", "LPSTR lpstrFileTitle", ofn.lpstrFileTitle);
Print("%ld", "DWORD nMaxFileTitle", ofn.nMaxFileTitle);
Print("\"%s\"", "LPSTR lpstrInitialDir", ofn.lpstrInitialDir);
Print("\"%s\"", "LPSTR lpstrTitle", ofn.lpstrTitle);
Print("%8.8lX", "DWORD Flags", ofn.Flags);
Print("%d", "WORD nFileOffset", ofn.nFileOffset);
Print("%d", "WORD nFileExtension", ofn.nFileExtension);
Print("\"%s\"", "LPSTR lpstrDefExt", ofn.lpstrDefExt);
Print("%ld", "DWORD lCustData", ofn.lCustData);
Print2("%04.4X:%04.4X", "FARPROC lpfnHook",
    FP_SEG(ofn.lpfnHook), FP_OFF(ofn.lpfnHook));
Print("\"%s\"", "LPSTR lpTemplateName", ofn.lpTemplateName);

return TRUE;
}

};   // TGetOpenFileName


///////////////////////////////////////////////////////////
//
//  class GetSaveFileName : TCommDlg - handles GetSaveFileName()
//
///////////////////////////////////////////////////////////

_CLASSDEF( TGetSaveFileName )
class TGetSaveFileName : public TCommDlg
{
char            strFile[256],
                strTitle[96];
OPENFILENAME    ofn;

public:

//     Constructor
TGetSaveFileName(HWND hWnd) :
    TCommDlg(hWnd)
{
ofn.lStructSize = sizeof ofn;
ofn.hwndOwner = HWindow;
ofn.hInstance = NULL;
ofn.lpstrFilter = (LPSTR)"C files\0*.c\0Header files\0*.h\0";
ofn.lpstrCustomFilter = NULL;
ofn.nMaxCustFilter = NULL;
ofn.nFilterIndex = 1;
ofn.lpstrFile = (LPSTR)strFile;
ofn.nMaxFile = sizeof strFile;
ofn.lpstrFileTitle = (LPSTR)strTitle;
ofn.nMaxFileTitle = sizeof strTitle;
ofn.lpstrInitialDir = (LPSTR)NULL;
ofn.lpstrTitle = (LPSTR)NULL;
ofn.Flags = 0;
ofn.nFileOffset = 0;
ofn.nFileExtension = 0;
ofn.lpstrDefExt = (LPSTR)"def";
ofn.lCustData = 0;
ofn.lpfnHook = NULL;
ofn.lpTemplateName = NULL;
strFile[0] = '\0';
strTitle[0] = '\0';
}

char *nameOf() const {return "TGetSaveFileName";}

BOOL Invoke()
{
BOOL Ret;
ofn.Flags = Flags;
Ret = GetSaveFileName(&ofn);
Error = CommDlgExtendedError();
return Ret;
}

BOOL Paint(PTDlgTestWin pTDW, HDC DC)
{
TCommDlg::Paint(pTDW, DC);
Print("%lu", "DWORD lStructSize", ofn.lStructSize);
Print("%d", "HWND hwndOwner", ofn.hwndOwner);
Print("%d", "HANDLE hInstance", ofn.hInstance);
Print2("%04.4X:%04.4X =", "LPSTR lpstrFilter",
    FP_SEG(ofn.lpstrFilter), FP_OFF(ofn.lpstrFilter));
pTDW->Write(DC, "\""); pTDW->Write(DC, ConvertList(ofn.lpstrFilter));
pTDW->WriteLn(DC, "\"");
Print2("%04.4X:%04.4X =", "LPSTR lpstrCustomFilter",
    FP_SEG(ofn.lpstrCustomFilter), FP_OFF(ofn.lpstrCustomFilter));
pTDW->Write(DC, "\""); pTDW->Write(DC, ConvertList(ofn.lpstrCustomFilter));
pTDW->WriteLn(DC, "\"");
Print("%ld", "DWORD nMaxCustFilter", ofn.nMaxCustFilter);
Print("%ld", "DWORD nFilterIndex", ofn.nFilterIndex);
Print("\"%s\"", "LPSTR lpstrFile", ofn.lpstrFile);
Print("%ld", "DWORD nMaxFile", ofn.nMaxFile);
Print("\"%s\"", "LPSTR lpstrFileTitle", ofn.lpstrFileTitle);
Print("%ld", "DWORD nMaxFileTitle", ofn.nMaxFileTitle);
Print("\"%s\"", "LPSTR lpstrInitialDir", ofn.lpstrInitialDir);
Print("\"%s\"", "LPSTR lpstrTitle", ofn.lpstrTitle);
Print("%8.8lX", "DWORD Flags", ofn.Flags);
Print("%d", "WORD nFileOffset", ofn.nFileOffset);
Print("%d", "WORD nFileExtension", ofn.nFileExtension);
Print("\"%s\"", "LPSTR lpstrDefExt", ofn.lpstrDefExt);
Print("%ld", "DWORD lCustData", ofn.lCustData);
Print2("%04.4X:%04.4X", "FARPROC lpfnHook",
    FP_SEG(ofn.lpfnHook), FP_OFF(ofn.lpfnHook));
Print("\"%s\"", "LPSTR lpTemplateName", ofn.lpTemplateName);

return TRUE;
}

};   // TGetSaveFileName


///////////////////////////////////////////////////////////
//
//  class TDlgTestWin, implementation
//
///////////////////////////////////////////////////////////

// Constructor
TDlgTestWin::TDlgTestWin(PTWindowsObject AParent, LPSTR ATitle) :
    TWindow(AParent, ATitle)
{
AssignMenu( "COMMANDS" );
x = y = 0;
pcd = NULL;
ptgofn = new TGetOpenFileName( HWindow );
ptgsfn = new TGetSaveFileName( HWindow );
ptpd = new TPrintDlg( HWindow );
ptcf = new TChooseFont( HWindow );
}


// Overide GetWindowClass

void TDlgTestWin::GetWindowClass(WNDCLASS _FAR & AWndClass)
{
TWindow::GetWindowClass(AWndClass);
AWndClass.hIcon=LoadIcon( GetApplication()->hInstance, "ICON_1");
}


// Command Messages

void TDlgTestWin::CMGetOpenFileName( RTMessage )
{
pcd = ptgofn;
InvalidateRect(HWindow, NULL, TRUE);
}

void TDlgTestWin::CMGetSaveFileName( RTMessage )
{
pcd = ptgsfn;
InvalidateRect(HWindow, NULL, TRUE);
}

void TDlgTestWin::CMPrintDlg( RTMessage )
{
pcd = ptpd;
InvalidateRect(HWindow, NULL, TRUE);
}

void TDlgTestWin::CMChooseFont( RTMessage )
{
pcd = ptcf;
InvalidateRect(HWindow, NULL, TRUE);
}

void TDlgTestWin::CMInvoke ( RTMessage )
{
if( pcd )   {
    pcd->Invoke();
    InvalidateRect(HWindow, NULL, TRUE);
    }
}

void TDlgTestWin::CMGetFlags(RTMessage)
{
char s[256], *title;
DWORD f;

if(pcd) {
    title = pcd->nameOf();
    wsprintf(s, "%08.8lx", pcd->GetFlags());
    if(GetApplication()->ExecDialog(new TInputDialog(this,title,
      "Input DWORD Flags (hex):",s,sizeof(s))) == IDOK)
        {
        sscanf(s, "%lx", &f);
        pcd->SetFlags(f);
        }

    InvalidateRect(HWindow, NULL, TRUE);
    }
}

void TDlgTestWin::CMShowError ( RTMessage )
{
if( pcd )   {
    pcd->UpdateError();
    InvalidateRect(HWindow, NULL, TRUE);
    }
}


// Paint utilities

BOOL TDlgTestWin::Write(HDC DC, LPSTR txt)
{
int     len = strlen(txt);
DWORD   ext;

if(!TextOut(DC, x, y, txt, len))
    return FALSE;
ext = GetTextExtent(DC, txt, len);
x += LOWORD(ext);
return TRUE;
}

BOOL TDlgTestWin::WriteLn(HDC DC, LPSTR txt)
{
int     len = strlen(txt);
DWORD   ext;

if(!TextOut(DC, x, y, txt, len))
    return FALSE;
ext = GetTextExtent(DC, txt, len);
x = 0; y += HIWORD(ext);
return TRUE;
}

void TDlgTestWin::Paint(HDC DC, PAINTSTRUCT&)
{
HANDLE  hPrevFont;

x = y = 0;
if(pcd) {
    Write(DC, "                         Object Name = ");
    WriteLn(DC, pcd->nameOf());
    WriteLn(DC, " ");
    hPrevFont = SelectObject(DC, GetStockObject(OEM_FIXED_FONT));
    pcd->Paint(this, DC);
    SelectObject(DC, hPrevFont);
    }
}


///////////////////////////////////////////////////////////
//
//  class TDlgTestApp
//
///////////////////////////////////////////////////////////

class TDlgTestApp : public TApplication
{
public:

// Constructor
TDlgTestApp(LPSTR AName, HANDLE hInstance, HANDLE hPrevInstance,
             LPSTR lpCmdLine, int nCmdShow) : TApplication(AName,
                   hInstance, hPrevInstance, lpCmdLine, nCmdShow) {};

virtual void InitMainWindow()
    {
    MainWindow = new TDlgTestWin(NULL, Name);
    }

};      // TDlgTestApp



///////////////////////////////////////////////////////////
//
//  WinMain
//
///////////////////////////////////////////////////////////

int PASCAL WinMain( HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpCmdLine, int nCmdShow )
{
TDlgTestApp DlgTestApp( "COMMDLG.DLL Test", hInstance, hPrevInstance,
                        lpCmdLine, nCmdShow );
DlgTestApp.Run();
return DlgTestApp.Status;
}


///////////////////////////////////////////////////////////
//
// "Helper" functions.
//
///////////////////////////////////////////////////////////

LPSTR ConvertList(LPSTR s)
{
static char  t[340];    // Should be long enough...
int          i=0;

if (!s) return "NULL";
do  {
    t[i++]=*(s++);
    if(!(*s))  {
        t[i++] = '\\';
        t[i++] = '0';
        t[i++] = ' ';
        s++;
        }

    } while(*s);

t[i++]='\0';
return t;
}
