//----------------------------------------------------------------------------
// Copyright (c) 1995, 1995 by Borland International, All Rights Reserved
//
// Description:
//----------------------------------------------------------------------------
#ifndef ComboGad_H
#define ComboGad_H

#if !defined(OWL_APPLICAT_H)
# include <owl/applicat.h>
#endif
#if !defined(OWL_WINDOW_H)
# include <owl/window.h>
#endif
#if !defined(OWL_CONTROLB_H)
# include <owl/controlb.h>
#endif
#include "ComboGad.rh"

class TComboBox;
class TStatusBar;
class TEdit;

const int IdComboBox = 10;
const int IdEdit = 11;

//
// class TCommandControlBar
// ~~~~~ ~~~~~~~~~~~~~~~~~~
// The purpose of this class is to catch the WM_COMMAND messages from
// the children controls and do something with them.
//
class TCommandControlBar : public TControlBar {
  public:
    TCommandControlBar(TWindow* parent = 0, TTileDirection direction = Horizontal,
      TFont* font = new TGadgetWindowFont, TModule* module = 0);

  protected:
    void CbnSelChange();

  DECLARE_RESPONSE_TABLE(TCommandControlBar);
};


//
// class TComboGadApp
// ~~~~~ ~~~~~~~~~~~~
class TComboGadApp : public TApplication {
  public:
    TComboGadApp();
   ~TComboGadApp();
    void InitMainWindow();
    void InitInstance();

    TEdit*              Edit;
    TComboBox*          ComboBox;
    TCommandControlBar* ControlBar;
    TStatusBar*         StatusBar;
};

//
// class TComboGadWindow
// ~~~~~ ~~~~~~~~~~~~~~~
class TComboGadWindow : public TWindow {
  public:
    TComboGadWindow();
   ~TComboGadWindow();

    void  SetupWindow();
    void  CleanupWindow();

  DECLARE_RESPONSE_TABLE(TComboGadWindow);
};

#endif


