//----------------------------------------------------------------------------
// Copyright (c) 1995, 1995 by Borland International, All Rights Reserved
//
// Description:
//----------------------------------------------------------------------------
#include <owl/owlpch.h>
#if !defined(OWL_DECFRAME_H)
# include <owl/decframe.h>
#endif
#if !defined(OWL_CONTROLG_H)
# include <owl/controlg.h>
#endif
#if !defined(OWL_CONTROLB_H)
# include <owl/controlb.h>
#endif
#if !defined(OWL_COMBOBOX_H)
# include <owl/combobox.h>
#endif
#if !defined(OWL_STATUSBA_H)
# include <owl/statusba.h>
#endif
#if !defined(OWL_EDIT_H)
# include <owl/edit.h>
#endif
#include "ComboGad.h"

//
// Application constructor
//
TComboGadApp::TComboGadApp() :
  TApplication()
{
}

//
// Application destructor
//
TComboGadApp::~TComboGadApp()
{
}

//
// InitMainWindow
//
void
TComboGadApp::InitMainWindow()
{
  TDecoratedFrame* frame = new TDecoratedFrame(0, "Test application",
    new TComboGadWindow);

  // Decorations
  //
  ControlBar = new TCommandControlBar(frame);
  frame->Insert(*ControlBar, TDecoratedFrame::Top);

  // Create the combobox
  //
  ComboBox = new TComboBox(0, IdComboBox, 0, 0, 200, 100, CBS_DROPDOWN, 0);
  TControlGadget* comboGadget = new TControlGadget(*ComboBox);
  ControlBar->Insert(*comboGadget);

  // Add a separator
  //
  ControlBar->Insert(*new TSeparatorGadget());

  // Create an edit control
  //
  Edit = new TEdit(0, IdEdit, 0, 0, 0, 150, 24);
  TControlGadget* editGadget = new TControlGadget(*Edit);
  ControlBar->Insert(*editGadget);

  // Status bar
  //
  StatusBar = new TStatusBar(frame);
  frame->Insert(*StatusBar, TDecoratedFrame::Bottom);

  SetMainWindow(frame);
}

//
// InitInstance
//
void
TComboGadApp::InitInstance()
{
  TApplication::InitInstance();

  // Add stuff to combobox
  //
  if (ComboBox && ComboBox->IsWindow()) {
    ComboBox->AddString("Snowy");
    ComboBox->AddString("Great Horned");
    ComboBox->AddString("Barn");
  }

  // Set the edit control text
  //
  if (Edit && Edit->IsWindow()) {
    Edit->SetText("Hello world!");
  }
}


//
// OwlMain
//
int
OwlMain(int /*argc*/, char* /*argv*/ [])
{
  TComboGadApp app;
  return app.Run();
}

