//----------------------------------------------------------------------------
// Copyright (c) 1995, 1995 by Borland International, All Rights Reserved
//
// Description:
//----------------------------------------------------------------------------
#include <owl/owlpch.h>
#if !defined(OWL_EDIT_H)
# include <owl/edit.h>
#endif
#if !defined(OWL_COMBOBOX_H)
# include <owl/combobox.h>
#endif
#include "ComboGad.h"

//
//
//
TCommandControlBar::TCommandControlBar(TWindow* parent, TTileDirection direction,
  TFont* font, TModule* module)
:
  TControlBar(parent, direction, font, module)
{
}


DEFINE_RESPONSE_TABLE1(TCommandControlBar, TControlBar)
  EV_CBN_SELCHANGE(IdComboBox, CbnSelChange),
END_RESPONSE_TABLE;

//
//
//
void
TCommandControlBar::CbnSelChange()
{
  // Change the edit control's text to match combobox
  //
  char buffer[80];
  TComboGadApp* app = TYPESAFE_DOWNCAST(GetApplication(), TComboGadApp);
  if (app)
    if (app->ComboBox && app->ComboBox->IsWindow())  {
      app->ComboBox->GetSelString(buffer, 80);
      if (app->Edit && app->Edit->IsWindow())
        app->Edit->SetText(buffer);
    }
}
