/*************************************************************************/
/*                                                                       */
/*         MicroFaces Unlimited ColorList Box and Dialog Example         */
/*         Version 1.00                                                  */
/*         Author Steven C. Leach CIS 73577,175                          */
/*         Put into the Public Domain                                    */
/*                                                                       */
/*         Requires Borland C++ Version 3.0                              */
/*                  Applications FrameWork & OWL Libraries               */
/*                                                                       */
/*         History: Begin Work 15 June 1992                              */
/*         23 June 1992 Finish Basic Dialog Boxes                        */
/*                                                                       */
/*                                                                       */
/*************************************************************************/

#include    <string.h>
#include	<ctype.h>


#include <owl.h>
#include <edit.h>
#include <listbox.h>
#include <dialog.h>
#include <bwcc.h>
#include <commdlg.h>

#include "colordlg.hpp"
#include "dlgid.h"
#include "global.h"


/************************************************************
* TColorListDlg Implementation :
*************************************************************/

// Constructor to Fill in Information
TColorListDlg::TColorListDlg(PTWindowsObject AParent,LPSTR AName)
:TDialog(AParent,AName)
{
 
	bCanClose = FALSE;

	crEditColor = RGB(255,255,255);

	pTColorBox = new TColorListBox(this,IDC_COLORLIST,10,10,50,100);

}

void TColorListDlg::~TColorListDlg(void)
{

}

// To Initialize Items in Dialog Box
void	TColorListDlg::SetupWindow(void)
{
	int i;
	char cClipLevStr[7];
	char * cpPtr;
    RECT rColorList;

	TDialog::SetupWindow();

	// I use the Blackframe I put in the Dialog Box Using Rescource Worshop
	// To Size the ColorList Box Since I am Too Lazy to Implement
	// Something that can be used an extension of the Rescource Workshop
	GetWindowRect(GetDlgItem(HWindow,IDC_COLORLISTFRAME),&rColorList);
	ScreenToClient(HWindow,(POINT *)(&rColorList));
	ScreenToClient(HWindow,(POINT*)(&(rColorList.right)));
	MoveWindow(pTColorBox->HWindow,
		rColorList.left,rColorList.top,
		rColorList.right-rColorList.left,rColorList.bottom-rColorList.top,TRUE);


	// Convert Numbers into Strings of a very Specific Type
	// This is Very Dependent on what you Want to Do
	// Construct your own Strings
	for(i = 0; i < gnList; i ++){
		cpPtr = cClipLevStr + wsprintf(cClipLevStr,"%u",gwColorVals[i]/10);
		*cpPtr++ = '.';
		cpPtr += wsprintf(cpPtr,"%1u",gwColorVals[i]%10);
		*cpPtr++ = '%';
        *cpPtr++ = '\0';
		*cpPtr = '\0';
		pTColorBox->AddColString(gcrColor[i],cClipLevStr);
	}
}

BOOL	TColorListDlg::CanClose(void)
{
	return(bCanClose);
}


void TColorListDlg::Cancel(RTMessage Msg)
{
	bCanClose = TRUE;
    TDialog::Cancel(Msg);

}

void TColorListDlg::Ok(RTMessage Msg)
{
	char cClipLevStr[7];
	char * cpStrPtr;
	int i;
	
	bCanClose = FALSE;

	i = (int)pTColorBox->GetCount();

	if(i > 0){
		bCanClose = TRUE;
		gnList = i;
		for(i = 0; i < gnList; i ++){
			/** Transfer Color information **/
			gcrColor[i] = pTColorBox->GetColor(i);

			/** Extract ClipLevels from List Box **/
			cpStrPtr = cClipLevStr + pTColorBox->GetString(cClipLevStr,i)-1;
			*cpStrPtr = '\0';
			cpStrPtr = strchr(cClipLevStr,'.');
			if(cpStrPtr){
				while(*cpStrPtr)
					*cpStrPtr++ = *(cpStrPtr+1);
			}
			gwColorVals[i] = atoi(cClipLevStr);
		}
	}
    TDialog::Ok(Msg);
}


void	TColorListDlg::COLORLIST(RTMessage Msg)
{
 
	switch(Msg.LP.Hi){
		case LBN_DBLCLK:{
		}
		break;
		case LBN_SELCHANGE:
		{
			int iCurSel;
			char cCurStr[10];

			iCurSel = (int)SendDlgItemMsg(IDC_COLORLIST,LB_GETCURSEL,0,0L);
			*cCurStr = '\0';
			SendDlgItemMsg(IDC_COLORLIST,LB_GETTEXT,iCurSel,(LONG)cCurStr);
			SetDlgItemText(HWindow,IDC_CLIPEDIT,cCurStr);
			crEditColor = pTColorBox->GetColor(iCurSel);

			InvalidateRect(HWindow,NULL,FALSE);
		}
		break;


		default:
        break;
    }
}

void	TColorListDlg::CLIPADD	(RTMessage)
{
	char cClipStr[8],cListStr[8];
	char * cpClipStrEnd,*cpStrPtr;
	int i,iListNum;

	*cClipStr ='\0';

	i = GetDlgItemText(HWindow,IDC_CLIPEDIT,cClipStr,6)-1;
	if(i < 1){
		MessageBox(HWindow,"No Clip Level","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return;
	}

	cpClipStrEnd = cClipStr + i ;

	// First Make Sure Decimal Point is There
	if((cpStrPtr = strchr(cClipStr,'.')) == NULL){
	// If LAst Character is Digit Move Pointer Down One
    // Otherwise OverWrite CHaracter
		if(isdigit(*cpClipStrEnd))
			cpClipStrEnd++;

    // Add Decimal Point and Zero To End of String
		*cpClipStrEnd++ = '.';
        *cpClipStrEnd++ = '0';
		*cpClipStrEnd = '\0';
        cpClipStrEnd --;
	}
	else{// Make Sure There Are Not Too Many Digits
		i = 0;
        cpStrPtr++;
		while(isdigit(*cpStrPtr)){
			i ++;
			cpStrPtr++;
		}
		if(i > 1){
			MessageBox(HWindow,"Too Many Decimal Places","ERROR",MB_OK|MB_ICONEXCLAMATION);
			return;
		}
		else if (i ==0){/** There is no Zero AfterThe Decimal Point **/
			cpClipStrEnd++;
			*cpClipStrEnd++ = '0';
			*cpClipStrEnd = '\0';
            cpClipStrEnd --;
        }

    }

    /** Make Sure there is a % Character at the End of the Line **/
	if(*cpClipStrEnd != '%'){
		cpClipStrEnd ++;
	   *cpClipStrEnd++ = '%';
	   *cpClipStrEnd = '\0';

	}

// Now Check To see if This is a Duplicate of One Already in the List Box
	
	iListNum = pTColorBox->GetCount();
	if(iListNum > 0){
		for(i = 0; i < iListNum; i ++){
			pTColorBox->GetString(cListStr,i);
			if(strcmp(cListStr,cClipStr)==0)
            	break; // Found a Match That Should Not Be There
		}
		if(i >= iListNum){
			pTColorBox->AddColString(crEditColor,cClipStr);
			InvalidateRect(HWindow,NULL,FALSE);
        }
		else
			MessageBox(HWindow,"Duplicate ClipLevel Not Allowed","ERROR",MB_OK|MB_ICONEXCLAMATION);
			
	}
    else{
		pTColorBox->AddColString(crEditColor,cClipStr);
		InvalidateRect(HWindow,NULL,FALSE);
	}

}

void	TColorListDlg::CLIPDELETE (RTMessage)
{
	int iDelete;
	char cDelMsg[40];
	char cClipStr[10];

	iDelete = pTColorBox->GetSelIndex();

	if(iDelete >= 0){
		pTColorBox->GetString(cClipStr,iDelete);
		wsprintf(cDelMsg,"Delete %s ClipLevel",cClipStr);
		if(MessageBox(HWindow,cDelMsg,"DELETE CLIPLEVEL",MB_YESNO|MB_ICONQUESTION) == IDYES){
			pTColorBox->DeleteString(iDelete);

		/** We Have to REmove the Color Associated with the Clip Level **/
			InvalidateRect(HWindow,NULL,TRUE);
		}
	}
	else{
		MessageBox(HWindow,"No ClipLevel Selected","ERROR",MB_OK|MB_ICONEXCLAMATION);
	}
}

void TColorListDlg::WMPaint(void)
{
   HDC hDC;
   PAINTSTRUCT ps;
   HBRUSH	hBorderBrush,hFillBrush;

	hDC = BeginPaint(HWindow,&ps);

	hBorderBrush = (HBRUSH)GetStockObject(BLACK_BRUSH);

	GetWindowRect(GetDlgItem(HWindow,IDC_CLIPEDIT),&rEditColor);

	ScreenToClient(HWindow,(POINT *)(&rEditColor));
	ScreenToClient(HWindow,(POINT*)(&(rEditColor.right)));
	OffsetRect(&rEditColor,0,rEditColor.bottom-rEditColor.top);


	/** Draw in the Color Below the Edit Control **/
	FrameRect(hDC,&rEditColor,hBorderBrush);
	InflateRect(&rEditColor,-1,-1);
	hFillBrush = CreateSolidBrush(crEditColor);
	FillRect(hDC,&rEditColor,hFillBrush);
	DeleteObject(hFillBrush);

	EndPaint(HWindow,&ps);
}

void TColorListDlg::WMLBUTTONDOWN(RTMessage Msg)
{
 	POINT ptMouseLoc;

	ptMouseLoc = MAKEPOINT(Msg.LParam);

	if(PtInRect(&rEditColor,ptMouseLoc)){
// ObjectWindows - (C) Copyright 1992 by Borland International
//
// Cmdlgap.cpp - Common Dialogs example in OWL

// Beginning of file cmdlgap.cpp
/***************************************************************************
Using the CHOOSECOLOR structure and the Windows 3.1 API call ChooseColor(),
eases the selection of colors for the programmer and for the user.  The
comments for the File Open dialog regarding the help file and the structure
size also apply to the color dialog.
****************************************************************************/

		CHOOSECOLOR ccTemp;
		COLORREF crTemp[16];    // Important, sometimes unused, array

		ccTemp.lStructSize = sizeof( CHOOSECOLOR );
		ccTemp.hwndOwner = HWindow;
		ccTemp.hInstance = 0;
		// CC_RGBINIT flag makes this the default color
		ccTemp.rgbResult = crEditColor; //MODIFY SCLEACH
/* 
lpCustColors must be set to a valid array of 16 COLORREF's, even if it
is not used.  If it isn't you will probably fail with a GP fault in
COMMDLG.DLL.
*/
		ccTemp.lpCustColors = crTemp;
		ccTemp.Flags = CC_FULLOPEN | CC_RGBINIT | CC_SHOWHELP;
		ccTemp.lCustData = 0L;
		ccTemp.lpfnHook = NULL;
		ccTemp.lpTemplateName = NULL;

		if( ChooseColor( &ccTemp ) == TRUE ){
			//MODIFY SCLEACH
			crEditColor = ccTemp.rgbResult;
			InvalidateRect(HWindow,&rEditColor,FALSE);
			// END MODIFY
		}

	}


}

/***********************************************************************
*  TColorListBox Implementation                                        *
*  16 Sept 1992                                                        *
*  Steven C. Leach                                                     *
************************************************************************/

void	TColorListBox::TColorListBox(PTWindowsObject AParent , int AnId,
	int X, int Y, int W , int H)
	:TListBox(AParent , AnId,X,Y,W,H)
{
	int i;

	ID = AnId;
	SetRect(&rListBox,X,Y,X+W,Y+H);
	
	crpTColor = (COLORREF*)new COLORREF[MAX_COLORVALS];
	if(crpTColor == NULL){
		MessageBox(HWindow,"NO COLORREF MEMORY","MEMORY ERROR",MB_OK|MB_ICONEXCLAMATION);
	}
	else{
		for(i = 0; i < gnList; i ++)
			crpTColor[i] = gcrColor[i];
	}

	rpListRect = (RECT*)new RECT[MAX_COLORVALS];
	if(rpListRect == NULL){
		MessageBox(HWindow,"NO LIST RECT MEMORY","MEMORY ERROR",MB_OK|MB_ICONEXCLAMATION);
	}

	/** Do Not Let the List Box Sort the Items Independently **/
	Attr.Style &= ~(LBS_SORT);

	// Make Sure the List Box has A Constant Width
	// Allocate Space for Strings
	// Let It Know That I will be Drawing in the Items in the List Box
	Attr.Style |= LBS_DISABLENOSCROLL | LBS_OWNERDRAWFIXED | LBS_HASSTRINGS ;

}

void	TColorListBox::~TColorListBox()
{
	if(crpTColor)
		delete[] crpTColor;

	if(rpListRect)
		delete[] rpListRect;
}

void	TColorListBox::WMPaint(RTMessage)
{

	HDC hDC;
 	HBRUSH hBorderBrush,hFillBrush;
	RECT rItem;
	int i,iTopItem;
	PAINTSTRUCT ps;
	char cStr[10];

	hBorderBrush = (HBRUSH)GetStockObject(BLACK_BRUSH);


	hDC = BeginPaint(HWindow,&ps);

	GetWindowRect(GetDlgItem(Parent->HWindow,ID),&rListBox);
	ScreenToClient(HWindow,(POINT *)(&rListBox));
	ScreenToClient(HWindow,(POINT*)(&(rListBox.right)));
	//rListBox Now Contains Rect of Listbox in Dialog Window Coordinates

	iTopItem = (int)SendDlgItemMessage(Parent->HWindow,ID,LB_GETTOPINDEX,0,0L);
	for(i = iTopItem; i < GetCount(); i ++){
		SendDlgItemMessage(Parent->HWindow,ID,LB_GETITEMRECT,i,(LONG)(&rItem));
		OffsetRect(&rItem,rListBox.left,rListBox.top);
		//OffsetRect(&rItem,rItem.left-rItem.right,0);

		/** If Bottom Of Item Rect is Less than List Bottom Then Bail Out **/
		if(rItem.bottom > rListBox.bottom)
			break;

		rItem.right = (rItem.left +rItem.right) /2;
		FrameRect(hDC,&rItem,hBorderBrush);

		/** Save Rect for Mouse Button Down Events **/
		CopyRect((rpListRect+i),&rItem);

		InflateRect(&rItem,-1,-1);
		hFillBrush = CreateSolidBrush(crpTColor[i]);
		FillRect(hDC,&rItem,hFillBrush);
		DeleteObject(hFillBrush);

		GetString(cStr,i);

		TextOut(hDC,rItem.right+10,rItem.top,(LPSTR)cStr,lstrlen(cStr));
	}

	EndPaint(HWindow,&ps);


	//TListBox::WMPaint(Msg);

}


COLORREF TColorListBox::GetColor(int index)
{
	if(index >= 0 && index < GetCount())
		return(crpTColor[index]);
	else
		return -1;
}

COLORREF TColorListBox::GetSelColor()
{
	int iSelIndex = GetSelIndex();
	if(iSelIndex >= 0)
		return(crpTColor[iSelIndex]);
	else
		return iSelIndex;
}

int	TColorListBox::ChangeColor(COLORREF crColor,int Index)
{
	if(Index >= 0 && Index < GetCount()){
		crpTColor[Index] = crColor;
		return(Index);
	}
	else
		return -1;

}


void	TColorListBox::ClearList(void)
{
	int i;
	int nList = GetCount();

	for(i = 0; i < nList; i ++){
		SetRectEmpty((rpListRect+i));
		crpTColor[i] = RGB(0,0,0);
	}

	TListBox::ClearList();
}

int		TColorListBox::DeleteString(int Index)
{
	int i;
	int nList = GetCount();
	if(Index >=0 && Index < nList){
		if(Index == nList -1)
			return TListBox::DeleteString(Index);
		else{
			for(i = Index; i < nList; i ++)
				crpTColor[i] = crpTColor[i+1];
			return TListBox::DeleteString(Index);
		}
	}
	else
		return(-1);
}

int		TColorListBox::DeleteColString(int Index)
{
	int i;
	int nList = GetCount();
	if(Index >=0 && Index < nList){
		if(Index == nList -1)
			return TListBox::DeleteString(Index);
		else{
			for(i = Index; i < nList; i ++)
				crpTColor[i] = crpTColor[i+1];
			return TListBox::DeleteString(Index);
		}
	}
	else
		return(-1);
}

int		TColorListBox::WhichIndex(LPSTR AString)
{
	int nList = GetCount();
	int i,iOrder;
	char cListStr[10];

    // No Items in List Box
	if(nList < 1)
		return 1;

    // 1 Item in the List Box
	if(nList < 2){
		GetString(cListStr,0);
		iOrder = lstrcmpi(AString,cListStr);
		if( iOrder < 0)
			return(2);
        /** Error Strings are the Same **/
		else if (iOrder == 0)
			return(-1);
		else
			return(0);
	}

    // More than 1 Item in the List Box
	for(i = 0 ; i < nList-1; i ++){
		GetString(cListStr,i);
		iOrder = lstrcmpi(AString,cListStr);
		if(iOrder == 0)
			return(-1);
		else if(iOrder >0)
			return(i);
    }


 	return(nList);
}

int		TColorListBox::AddColString(COLORREF crColor,LPSTR AString)
{
	int iInsertIndex = WhichIndex(AString);
	int i;
    int nList = GetCount();

	if(iInsertIndex < 0)
		return(iInsertIndex);

	if(iInsertIndex < nList){
		for(i = nList; i>iInsertIndex ;i--){
         	crpTColor[i] = crpTColor[i-1];
		}
		crpTColor[iInsertIndex] = crColor;
		return TListBox::InsertString(AString,iInsertIndex);
	}
	else{ 
		crpTColor[nList] = crColor;
	
		return TListBox::AddString(AString);
	}
}

int		TColorListBox::InsertColString(COLORREF crColor,LPSTR AString,int Index)
{
	int nList = GetCount();
	int i;

	if(Index == -1){
		crpTColor[nList] = crColor;
	}
	else if (Index >= 0 && Index < nList){
		for(i = nList-1; i <= Index; i --)
			crpTColor[i+1] = crpTColor[i];

		crpTColor[Index] = crColor;
	}
	else
		return -10;

	return TListBox::InsertString(AString,Index);
}

void TColorListBox::WMVScroll(RTMessage Msg)
{
	InvalidateRect(HWindow,NULL,FALSE);
	TListBox::WMVScroll(Msg);
}

void	TColorListBox::WMLButtonDown(RTMessage Msg)
{
	int i;
	int nList = GetCount();
	int iTopItem = (int)SendDlgItemMessage(Parent->HWindow,ID,LB_GETTOPINDEX,0,0L);
	POINT ptMouseLoc = MAKEPOINT(Msg.LParam);

	for(i = iTopItem; i < nList; i ++){
		if(PtInRect((rpListRect+i),ptMouseLoc))
			break;
	}

	if(i < nList){
// ObjectWindows - (C) Copyright 1992 by Borland International
//
// Cmdlgap.cpp - Common Dialogs example in OWL

// Beginning of file cmdlgap.cpp
/***************************************************************************
Using the CHOOSECOLOR structure and the Windows 3.1 API call ChooseColor(),
eases the selection of colors for the programmer and for the user.  The
comments for the File Open dialog regarding the help file and the structure
size also apply to the color dialog.
****************************************************************************/

		CHOOSECOLOR ccTemp;
		COLORREF crTemp[16];    // Important, sometimes unused, array

		ccTemp.lStructSize = sizeof( CHOOSECOLOR );
		ccTemp.hwndOwner = HWindow;
		ccTemp.hInstance = 0;

		// CC_RGBINIT flag makes this the default color
		ccTemp.rgbResult = crpTColor[i];  //MODIFY SCLEACH
/*
lpCustColors must be set to a valid array of 16 COLORREF's, even if it
is not used.  If it isn't you will probably fail with a GP fault in
COMMDLG.DLL.
*/
		ccTemp.lpCustColors = crTemp;
		ccTemp.Flags = CC_FULLOPEN | CC_RGBINIT | CC_SHOWHELP;
		ccTemp.lCustData = 0L;
		ccTemp.lpfnHook = NULL;
		ccTemp.lpTemplateName = NULL;

		if( ChooseColor( &ccTemp ) == TRUE ){
		//MODIFY SCLEACH
			crpTColor[i] = ccTemp.rgbResult;
			InvalidateRect(HWindow,rpListRect+i,FALSE);
		// END MODIFY
		}
		//MODIFY SCLEACH
		/** Make Sure this is the Currently Selected
		 ** Item in the List Box
         **/
        SetSelIndex(i);
		// END MODIFY

	}
	else
		TListBox::WMLButtonDown(Msg);
    
}