/* ckcker.h -- Symbol and macro definitions for C-Kermit */

/*
 Author: Frank da Cruz (fdc@columbia.edu, FDCCU@CUVMA.BITNET),
 Columbia University Center for Computing Activities.
 First released January 1985.
 Copyright (C) 1985, 1990, Trustees of Columbia University in the City of New 
 York.  Permission is granted to any individual or institution to use, copy, or
 redistribute this software so long as it is not sold for profit, provided this
 copyright notice is retained. 
*/

/* Codes for what we are doing now */

#define W_NOTHING 0			/* Nothing */
#define W_SEND    1			/* SENDing or MAILing */
#define W_RECV    2			/* RECEIVEing or GETting */
#define W_REMO    4			/* Doing a REMOTE command */

/* Terminal modes */
#define VT100     0			/* Also for VT52 mode */
#define TEKTRONIX 1

#ifdef OS2				/* Keytable return values */
#define ODSR 2
#define IDSR 3
#define OCTS 4
#endif

/* Normal packet and window size */

#define MAXPACK 94			/* Maximum unextended packet size */
					/* Can't be more than 94! */
#define MAXWS 31			/* Maximum window size */
					/* Can't be more than 31! */

/* Maximum long packet size for sending packets */
/* Override these from cc command line via -DMAXSP=nnn */

#ifdef DYNAMIC
#ifndef MAXSP
#define MAXSP 9024
#endif /* MAXSP */
#else  /* not DYNAMIC */
#ifndef MAXSP
#define MAXSP 2048
#endif /* MAXSP */
#endif /* DYNAMIC */

/* Maximum long packet size for receiving packets */
/* Override these from cc command line via -DMAXRP=nnn */

#ifdef DYNAMIC
#ifndef MAXRP 
#define MAXRP 9024
#endif /* MAXRP */
#else  /* not DYNAMIC */
#ifndef MAXRP 
#define MAXRP 2048
#endif /* MAXRP */
#endif /* DYNAMIC */

#ifdef VMS				/* Dynamic or not, */
#undef MAXSP				/* VMS seems to have an intrinsic */
#define MAXSP 1920			/* limit of about 1920. */
#undef MAXRP
#define MAXRP 1920
#endif /* VMS */

/* Default sizes for windowed packet buffers */
/* Override these from cc command line via -DSBSIZ=nnn, -DRBSIZ=nnn */

#ifdef DYNAMIC
#ifndef SBSIZ 
#define SBSIZ 9050
#endif /* SBSIZ */
#ifndef RBSIZ 
#define RBSIZ 9050
#endif /* RBSIZ */
#else  /* not DYNAMIC */
#ifndef SBSIZ
#define SBSIZ (MAXPACK * (MAXWS + 1))
#endif /* SBSIZ */
#ifndef RBSIZ
#define RBSIZ (MAXPACK * (MAXWS + 1))
#endif /* RBSIZ */
#endif /* DYNAMIC */

#ifdef VMS				/* VMS again... */
#undef SBSIZ
#define SBSIZ 1930
#undef RBSIZ
#define RBSIZ 1930
#endif

/* Kermit parameters and defaults */

#define CTLQ	   '#'			/* Control char prefix I will use */
#define MYEBQ	   '&'			/* 8th-Bit prefix char I will use */
#define MYRPTQ	   '~'			/* Repeat count prefix I will use */

#define MAXTRY	    10			/* Times to retry a packet */
#define MYPADN	    0			/* How many padding chars I need */
#define MYPADC	    '\0'		/* Which padding character I need */

#define DMYTIM	    7			/* Default timeout interval to use. */
#define URTIME	    10			/* Timeout interval to use on me. */
#define DSRVTIM     0			/* Default server cmd wait timeout. */

#define DEFTRN	    0			/* Default line turnaround handshake */
#define DEFPAR	    0			/* Default parity */
#define MYEOL	    CR			/* Incoming packet terminator. */

#define DRPSIZ	    90			/* Default incoming packet size. */
#define DSPSIZ	    90			/* Default outbound packet size. */

#define DDELAY      5			/* Default delay. */
#define DSPEED	    9600		/* Default line speed. */

/* Files */

#define ZCTERM      0	    	/* Console terminal */
#define ZSTDIO      1		/* Standard input/output */
#define ZIFILE	    2		/* Current input file (SEND, etc) (in) */
#define ZOFILE      3	    	/* Current output file (RECEIVE, GET) (out) */
#define ZDFILE      4	    	/* Current debugging log file (out) */
#define ZTFILE      5	    	/* Current transaction log file (out) */
#define ZPFILE      6	    	/* Current packet log file (out) */
#define ZSFILE      7		/* Current session log file (out) */
#define ZSYSFN	    8		/* Input/Output from a system function */
#define ZRFILE      9           /* Local file for READ (in) */
#define ZWFILE     10           /* Local file for WRITE (out) */
#define ZNFILS     11	    	/* How many defined file numbers */

/*
 Buffered file i/o is used to avoid gratuitous function calls while encoding a
 packet.  The previous way involved 2 nested function calls for EACH character
 of the file.  This way, we only do 2 calls per K of data.  This reduces
 packet encoding time to 1% of its former cost.  Originally added by Paul
 Placeway.
*/
#ifdef VMS		/* In VMS, allow for longest possible RMS record */
#ifdef DYNAMIC
#define INBUFSIZE 32766	/* File input buffer size */
#define OBUFSIZE 32766 	/* File output buffer size */
#else
#define INBUFSIZE 4096	/* File input buffer size */
#define OBUFSIZE 4096 	/* File output buffer size */
#endif /* DYNAMIC */
#else  /* Not VMS */	/* For all others, just use a 1K buffer */
#define INBUFSIZE 1024
#define OBUFSIZE 1024
#endif /* VMS */

/* get the next char; sorta like a getc() macro */
#define zminchar() (((--zincnt)>=0) ? ((int)(*zinptr++) & 0377) : zinfill())

/* stuff a character into the input buffer */
#define zmstuff(c) zinptr--, *zinptr = c, zincnt++

/* put a character to a file, like putchar() macro */
#define zmchout(c) \
((*zoutptr++=(CHAR)(c)),(((++zoutcnt)>=OBUFSIZE)?zoutdump():0))

/* Screen functions */

#define SCR_FN 1    	/* filename */
#define SCR_AN 2    	/* as-name */
#define SCR_FS 3 	/* file-size */
#define SCR_XD 4    	/* x-packet data */
#define SCR_ST 5      	/* File status: */
#define   ST_OK   0   	/*  Transferred OK */
#define   ST_DISC 1 	/*  Discarded */
#define   ST_INT  2     /*  Interrupted */
#define   ST_SKIP 3 	/*  Skipped */
#define   ST_ERR  4 	/*  Fatal Error */
#define SCR_PN 6    	/* packet number */
#define SCR_PT 7    	/* packet type or pseudotype */
#define SCR_TC 8    	/* transaction complete */
#define SCR_EM 9    	/* error message */
#define SCR_WM 10   	/* warning message */
#define SCR_TU 11	/* arbitrary undelimited text */
#define SCR_TN 12   	/* arbitrary new text, delimited at beginning */
#define SCR_TZ 13   	/* arbitrary text, delimited at end */
#define SCR_QE 14	/* quantity equals (e.g. "foo: 7") */

/* Macros */

#define tochar(ch)  (((ch) + SP ) & 0xFF )	/* Number to character */
#define xunchar(ch) (((ch) - SP ) & 0xFF )	/* Character to number */
#define ctl(ch)     (((ch) ^ 64 ) & 0xFF )	/* Controllify/Uncontrollify */
#define unpar(ch)   (((ch) & 127) & 0xFF )	/* Clear parity bit */

/* Symbols for File Attributes */

#define AT_ALL   0			/* All of them */
#define AT_ALLY  1			/* All of them on (Yes) */
#define AT_ALLN  2			/* All of them off (no) */
#define AT_LENK  3			/* Length in K */
#define AT_TYPE  4			/* File Type */
#define AT_DATE  5			/* Creation date */
#define AT_CREA  6			/* Creator */
#define AT_ACCT  7			/* Account */
#define AT_AREA  8			/* Area */
#define AT_PSWD  9			/* Password for area */
#define AT_BLKS 10			/* Blocksize */
#define AT_ACCE 11			/* Access */
#define AT_ENCO 12			/* Encoding */
#define AT_DISP 13			/* Disposition */
#define AT_LPRO 14			/* Local Protection */
#define AT_GPRO 15			/* Generic Protection */
#define AT_SYSI 16			/* System ID */
#define AT_RECF 17			/* Record Format */
#define AT_SYSP 18			/* System-Dependent Parameters */
#define AT_LENB 19			/* Length in Bytes */

/* Structure definitions for Kermit file attributes */
/* All strings come as pointer and length combinations */
/* Empty string (or for numeric variables, -1) = unused attribute. */

struct zstr {             /* string format */
    int len;	          /* length */
    char *val;            /* value */
};
struct zattr {            /* Kermit File Attribute structure */
    long lengthk;         /* (!) file length in K */
    struct zstr type;     /* (") file type (text or binary) */
    struct zstr date;     /* (#) file creation date [yy]yymmdd[ hh:mm[:ss]] */
    struct zstr creator;  /* ($) file creator id */
    struct zstr account;  /* (%) file account */
    struct zstr area;     /* (&) area (e.g. directory) for file */
    struct zstr passwd;   /* (') password for area */
    long blksize;         /* (() file blocksize */
    struct zstr access;   /* ()) file access: new, supersede, append, warn */
    struct zstr encoding; /* (*) encoding (transfer syntax) */
    struct zstr disp;     /* (+) disposition (mail, message, print, etc) */
    struct zstr lprotect; /* (,) protection (local syntax) */
    struct zstr gprotect; /* (-) protection (generic syntax) */
    struct zstr systemid; /* (.) ID for system of origin */
    struct zstr recfm;    /* (/) record format */
    struct zstr sysparam; /* (0) system-dependent parameter string */
    long length;          /* (1) exact length on system of origin */
    struct zstr charset;  /* (2) transfer syntax character set */
    struct zstr reply;    /* This goes last, used for attribute reply */
};

/* Kermit packet information structure */

struct pktinfo {			/* Packet information structure */
    CHAR *bf_adr;			/*  buffer address */
    int   bf_len;			/*  buffer length */
    CHAR *pk_adr;			/* Packet address within buffer */
    int   pk_len;			/*  length of data within buffer */
    int   pk_typ;			/*  packet type */
    int   pk_seq;			/*  packet sequence number */
    int   pk_flg;			/*  ack'd bit */
    int   pk_rtr;			/*  retransmission count */
};
