////////////////////////////////////////////////////////////////////////
//	Application	: Sample16.exe and Sample32.exe
//	File Name		: TestTab.cpp
//	Date				: March 17, 1995
//	Remarks			: Dialog class to demonstrate Tab Control
////////////////////////////////////////////////////////////////////////
//	COPYRIGHT
//  	Sapient Technology, Inc.
//  	Copyright  1994, 1995. All Rights Reserved.
//	AUTHOR
//  	Ravi Prakash
////////////////////////////////////////////////////////////////////////

#include "testtab.hpp"
#include <ccckit.hpp>

// Application instance
extern HINSTANCE hInst;

// Used by all instances - will not cause a problem since only
// 1 dialog can be in focus at a time
static EDITMSG Data;


TestTab::TestTab( HWND w, HINSTANCE inst, int id )
			:	Dialog( w, inst, id )
{
	if( id == TABTOPDLGTEST )
  	retMsg = DLG_EXIT_TABTOP;
	if( id == TABLEFTDLGTEST )
		retMsg = DLG_EXIT_TABLEFT;
	if( id == TABBOTDLGTEST )
		retMsg = DLG_EXIT_TABBOT;
	if( id == TABRIGHTDLGTEST )
		retMsg = DLG_EXIT_TABRIGHT;
}


TestTab::~TestTab()
{
	if( _rcLoad )
		delete _rcLoad;
}


BOOL TestTab::WmInitDialog( HWND hwnd, HWND cw, LPARAM lp )
{
/*  WE DON'T USE CTL3DXX.DLL ANYMORE - WE HAVE OUR OWN STATIC/BUTTONS
		AND EVEN A VIRTUAL COMBOBOX!
#if defined(__WIN32__) || defined(__FLAT__)
	HINSTANCE ctl3dInst = (HINSTANCE)GetModuleHandle( "CTL3D32.DLL" );
#else
	HINSTANCE ctl3dInst = (HINSTANCE)GetModuleHandle( "CTL3DV2.DLL" );
#endif
*/
	item1 = item2 = item3 = 1;

	Dialog::WmInitDialog( hwnd, cw, lp );

	RegisterUserMsg( TAB_SELCHANGE );
	RegisterUserMsg( VCOMBO_NEEDDATA );

	_rcLoad = new ResourceLoader( hwnd, hInst, /*ctl3dInst ? TRUE :*/ FALSE );
	_tab = GetDlgItem( hwnd, IDC_TAB );
	if( _tab )
	{
		char title[ 64 ];
		lstrcpy( title, "Client Data|Client Survey|Credit Data" );
		SendMessage( _tab, TAB_SETTEXT, (WPARAM)0, (LPARAM)title );
	}

	if( _rcLoad )
	{ // Always need a centre box for resload to work properly
		_centre = GetDlgItem( hwnd, TABCENTER );
		_rcLoad->SetOffSets( _centre );
/*
		if( ctl3dInst )
			_rcLoad->EnableCtl3d( ctl3dInst );
*/
		_rcLoad->AddDlg( TABGENERAL, hInst );
		_rcLoad->AddDlg( TABSURVEY, hInst );
		_rcLoad->AddDlg( TABCREDIT, hInst );
		DestroyWindow( _centre );
	}

	// First Tab data
	lstrcpy( ClInfo.FName, "Christophe" );
	lstrcpy( ClInfo.LName, "Prakash" );
	ClInfo.Address[ 0 ] = 0;
	lstrcpy( ClInfo.DOB, "11/22/1993" );
	ClInfo.SSN[ 0 ] = 0;
	// Second Tab data
	ClSurvey.SMagazine = TRUE;
	ClSurvey.SFriend = FALSE;
	ClSurvey.SCatalog = FALSE;
	ClSurvey.SRadio = FALSE;
	ClSurvey.SZip[ 0 ] = 0;
	ClSurvey.SPhone[ 0 ] = 0;
	lstrcpy( ClSurvey.SIncome, "120000." );
	lstrcpy( ClSurvey.SState[ 0 ], "DC" );
	lstrcpy( ClSurvey.SState[ 1 ], "MD" );
	lstrcpy( ClSurvey.SState[ 2 ], "CA" );
	lstrcpy( ClSurvey.SState[ 3 ], "DE" );
	lstrcpy( ClSurvey.SState[ 4 ], "AZ" );
	lstrcpy( ClSurvey.SState[ 5 ], "VA" );
	ClSurvey.LastState = 1;
	// Third Tab data
	lstrcpy( ClCredit.CrLimit, "35000." );
	ClCredit.CrNum[ 0 ] = 0;
	ClCredit.CrBad = TRUE;
	ClCredit.CrFair = FALSE;
	ClCredit.CrGood = FALSE;
	ClCredit.CrExel = FALSE;
	lstrcpy( ClCredit.CrCard[ 0 ], "American Express" );
	lstrcpy( ClCredit.CrCard[ 1 ], "Discover Card" );
	lstrcpy( ClCredit.CrCard[ 2 ], "Master Card" );
	lstrcpy( ClCredit.CrCard[ 3 ], "Visa Card" );
	ClCredit.LastCard = 1;

	PostMessage( hwnd, TAB_SELCHANGE, (WPARAM)1, (LPARAM)0 );

	return TRUE;
}


BOOL TestTab::HandleUserMsg( HWND, UINT m, WPARAM wp, LPARAM lp )
{
	if( m == TAB_SELCHANGE )
	{
		if( _rcLoad )
		{
			if( (int)lp != _rcLoad->CurrDlg() )
			{
				switch( _rcLoad->CurrDlg() )
				{
					case	0:
						ManageClInfo( FALSE );
						break;
					case	1:
						ManageClSurvey( FALSE );
						break;
					case	2:
						ManageClCredit( FALSE );
						break;
				}
				_rcLoad->HideDlg( TRUE );
				_rcLoad->ShowDlg( (int)lp, TRUE ); // Create hidden
				switch( (int)lp )
				{
					case	0:
						ManageClInfo( TRUE );
						break;
					case	1:
						ManageClSurvey( TRUE );
						break;
					case	2:
						ManageClCredit( TRUE );
						break;
				}
				_rcLoad->ShowDlg( (int)lp, FALSE ); // Now show them
			}
			else
			{
				if( wp )
				{
					ManageClInfo( TRUE );
					_rcLoad->ShowDlg( (int)lp );
				}
			}
		}
		return TRUE;
	}

	if( m == VCOMBO_NEEDDATA )
	{
		int i = _rcLoad->CurrDlg();
		LPVCOMBODATA data = (LPVCOMBODATA)lp;
		if( i == 1 )
		{
			lstrcpy( data->cText, ClSurvey.SState[ (int)data->rowNum - 1 ] );
			return TRUE;
		}

		if( i == 2 )
		{
			lstrcpy( data->cText, ClCredit.CrCard[ (int)data->rowNum - 1 ] );
			return TRUE;
		}
	}

	return FALSE;
}


// NOTES
// TAB_SETTAB does send a TAB_SELCHANGE message. So after sending
// this message you cn be sure that you will receive a TAB_SELCHANGE if
// everything well well.
// TAB_SETTAB returns 1L if successful else a 0L. Check for it
// TAB_TOGGLETAB returns 1L if successful else a 0L. Check for it
// A return value of 0L means that things were were not SET OK.
void TestTab::WmCommand( HWND, int id, HWND, UINT )
{
	if( id == IDOK || id == IDCANCEL )
		PostMessage( GetParent(), retMsg, (WPARAM)0, (LPARAM)0 );
	else
	{
		switch( id )
		{
			case	IDC_SEL1:
				SendMessage( _tab, TAB_SETTAB, (WPARAM)0, (LPARAM)0 );
//				SendMessage( w, TAB_SELCHANGE, (WPARAM)0, (LPARAM)0 );
				break;
			case	IDC_SEL2:
				SendMessage( _tab, TAB_SETTAB, (WPARAM)0, (LPARAM)1 );
//				SendMessage( w, TAB_SELCHANGE, (WPARAM)0, (LPARAM)1 );
				break;
			case	IDC_SEL3:
				SendMessage( _tab, TAB_SETTAB, (WPARAM)0, (LPARAM)2 );
//				SendMessage( w, TAB_SELCHANGE, (WPARAM)0, (LPARAM)2 );
				break;

			case	IDC_TOGGLE1:
				item1 = !item1;
				SendMessage( _tab, TAB_TOGGLETAB, (WPARAM)item1, (LPARAM)0 );
				break;
			case	IDC_TOGGLE2:
				item2 = !item2;
				SendMessage( _tab, TAB_TOGGLETAB, (WPARAM)item2, (LPARAM)1 );
				break;
			case	IDC_TOGGLE3:
				item3 = !item3;
				SendMessage( _tab, TAB_TOGGLETAB, (WPARAM)item3, (LPARAM)2 );
				break;
		}
	}
}


void TestTab::ManageClInfo( BOOL create )
{
	HWND dlg;
	dlg = GetWnd();
	if( create )
	{
		// Setup general dlg
		_ln = GetDlgItem( dlg, IDC_LNAME );
		_fn = GetDlgItem( dlg, IDC_FNAME );
		_add = GetDlgItem( dlg, IDC_ADD );
		_dob = GetDlgItem( dlg, IDC_DOB );
		_ssn = GetDlgItem( dlg, IDC_SSN );
		lstrcpy( Data.editTxt, "###-##-####" );
		SendMessage( _ssn, EDIT_SETMASK, (WPARAM)0, (LPARAM)&Data );

		lstrcpy( Data.editTxt, ClInfo.FName );
		SendMessage( _fn, EDIT_SETTEXT, (WPARAM)0, (LPARAM)&Data );
		lstrcpy( Data.editTxt, ClInfo.LName );
		SendMessage( _ln, EDIT_SETTEXT, (WPARAM)0, (LPARAM)&Data );
		lstrcpy( Data.editTxt, ClInfo.Address );
		SendMessage( _add, EDIT_SETTEXT, (WPARAM)0, (LPARAM)&Data );
		lstrcpy( Data.editTxt, ClInfo.DOB );
		SendMessage( _dob, EDIT_SETTEXT, (WPARAM)0, (LPARAM)&Data );
		lstrcpy( Data.editTxt, ClInfo.SSN );
		SendMessage( _ssn, EDIT_SETTEXT, (WPARAM)0, (LPARAM)&Data );

		SetFocus( _fn );
	}
	else
	{
		SendMessage( _fn, EDIT_GETTEXT, (WPARAM)0, (LPARAM)&Data );
		lstrcpy( ClInfo.FName, Data.editTxt );
		SendMessage( _ln, EDIT_GETTEXT, (WPARAM)0, (LPARAM)&Data );
		lstrcpy( ClInfo.LName, Data.editTxt );
		SendMessage( _add, EDIT_GETTEXT, (WPARAM)0, (LPARAM)&Data );
		lstrcpy( ClInfo.Address, Data.editTxt );
		SendMessage( _dob, EDIT_GETTEXT, (WPARAM)0, (LPARAM)&Data );
		lstrcpy( ClInfo.DOB, Data.editTxt );
		SendMessage( _ssn, EDIT_GETTEXT, (WPARAM)0, (LPARAM)&Data );
		lstrcpy( ClInfo.SSN, Data.editTxt );
	}
}


void TestTab::ManageClSurvey( BOOL create )
{
	HWND dlg;
	dlg = GetWnd();
	if( create )
	{
		if( !dlg )
		{
			MessageBox( 0, "GetWnd() failed.", "ERROR", MB_OK );
			return;
		}
		// Setup survey dlg
		_szip 	= GetDlgItem( dlg, IDC_SZIP );
		_sphone = GetDlgItem( dlg, IDC_SPHONE );
		_sincome= GetDlgItem( dlg, IDC_SINCOME );
		_sstate	= GetDlgItem( dlg, IDC_SSTATE );

		lstrcpy( Data.editTxt, "#####-####" );
		SendMessage( _szip, EDIT_SETMASK, (WPARAM)0, (LPARAM)&Data );
		lstrcpy( Data.editTxt, "(###)###-####" );
		SendMessage( _sphone, EDIT_SETMASK, (WPARAM)0, (LPARAM)&Data );

		lstrcpy( Data.editTxt, ClSurvey.SZip );
		SendMessage( _szip, EDIT_SETTEXT, (WPARAM)0, (LPARAM)&Data );
		lstrcpy( Data.editTxt, ClSurvey.SPhone );
		SendMessage( _sphone, EDIT_SETTEXT, (WPARAM)0, (LPARAM)&Data );
		lstrcpy( Data.editTxt, ClSurvey.SIncome );
		SendMessage( _sincome, EDIT_SETTEXT, (WPARAM)0, (LPARAM)&Data );

		CheckDlgButton( dlg, IDC_SMAG, (UINT)ClSurvey.SMagazine );
		CheckDlgButton( dlg, IDC_SFRIEND, (UINT)ClSurvey.SFriend );
		CheckDlgButton( dlg, IDC_SCATALOG, (UINT)ClSurvey.SCatalog );
		CheckDlgButton( dlg, IDC_SRADIO, (UINT)ClSurvey.SRadio );

		// Virtual ComboBox
		SendMessage( _sstate, VCOMBO_SETCOUNT, (WPARAM)0, (LPARAM)6 );
		SendMessage( _sstate, VCOMBO_SETCURSEL, (WPARAM)0, (LPARAM)ClSurvey.LastState );
		SetFocus( _szip );
	}
	else
	{
		SendMessage( _szip, EDIT_GETTEXT, (WPARAM)0, (LPARAM)&Data );
		lstrcpy( ClSurvey.SZip, Data.editTxt );
		SendMessage( _sphone, EDIT_GETTEXT, (WPARAM)0, (LPARAM)&Data );
		lstrcpy( ClSurvey.SPhone, Data.editTxt );
		SendMessage( _sincome, EDIT_GETTEXT, (WPARAM)0, (LPARAM)&Data );
		lstrcpy( ClSurvey.SIncome, Data.editTxt );

		ClSurvey.SMagazine = (BOOL)IsDlgButtonChecked( dlg, IDC_SMAG );
		ClSurvey.SFriend = (BOOL)IsDlgButtonChecked( dlg, IDC_SFRIEND );
		ClSurvey.SCatalog = (BOOL)IsDlgButtonChecked( dlg, IDC_SCATALOG );
		ClSurvey.SRadio = (BOOL)IsDlgButtonChecked( dlg, IDC_SRADIO );
		ClSurvey.LastState = (int)SendMessage( _sstate, VCOMBO_GETCURSEL,
																								(WPARAM)0, (LPARAM)0 );
	}
}


void TestTab::ManageClCredit( BOOL create )
{
	HWND dlg;
	dlg = GetWnd();
	if( create )
	{
		_crlimit	= GetDlgItem( dlg, IDC_CRLIMIT );
		_crnum		= GetDlgItem( dlg, IDC_CRNUM );
		_crcard   = GetDlgItem( dlg, IDC_CRCARD );

		lstrcpy( Data.editTxt, "####-####-####-####" );
		::SendMessage( _crnum, EDIT_SETMASK, (WPARAM)0, (LPARAM)&Data );

		lstrcpy( Data.editTxt, ClCredit.CrLimit );
		::SendMessage( _crlimit, EDIT_SETTEXT, (WPARAM)0, (LPARAM)&Data );
		lstrcpy( Data.editTxt, ClCredit.CrNum );
		::SendMessage( _crnum, EDIT_SETTEXT, (WPARAM)0, (LPARAM)&Data );

		CheckDlgButton( dlg, IDC_BADR,  (UINT)ClCredit.CrBad );
		CheckDlgButton( dlg, IDC_FAIRR, (UINT)ClCredit.CrFair  );
		CheckDlgButton( dlg, IDC_GOODR, (UINT)ClCredit.CrGood );
		CheckDlgButton( dlg, IDC_EXCELR,(UINT)ClCredit.CrExel );

		// Virtual ComboBox
		SendMessage( _crcard, VCOMBO_SETCOUNT, (WPARAM)0, (LPARAM)4 );
		SendMessage( _crcard, VCOMBO_SETCURSEL, (WPARAM)0, (LPARAM)ClCredit.LastCard );
		::SetFocus( _crlimit );
	}
	else
	{
		::SendMessage( _crlimit, EDIT_GETTEXT, (WPARAM)0, (LPARAM)&Data );
		lstrcpy( ClCredit.CrLimit, Data.editTxt );
		::SendMessage( _crnum, EDIT_GETTEXT, (WPARAM)0, (LPARAM)&Data );
		lstrcpy( ClCredit.CrNum, Data.editTxt );

		ClCredit.CrBad = (BOOL)IsDlgButtonChecked( dlg, IDC_BADR );
		ClCredit.CrFair = (BOOL)IsDlgButtonChecked( dlg, IDC_FAIRR );
		ClCredit.CrGood = (BOOL)IsDlgButtonChecked( dlg, IDC_GOODR );
		ClCredit.CrExel = (BOOL)IsDlgButtonChecked( dlg, IDC_EXCELR );
		ClCredit.LastCard = (int)SendMessage( _crcard, VCOMBO_GETCURSEL,
																								(WPARAM)0, (LPARAM)0 );
	}
}
