////////////////////////////////////////////////////////////////////////
//	Application	: Sample16.exe and Sample32.exe
//	File Name		: TestScrb.cpp
//	Date				: March 14, 1995
//	Remarks			: Dialog class to demonstarte Virtual Scroll Bars
////////////////////////////////////////////////////////////////////////
//	COPYRIGHT
//  	Sapient Technology, Inc.
//  	Copyright  1994, 1995. All Rights Reserved.
//	AUTHOR
//  	Ravi Prakash
////////////////////////////////////////////////////////////////////////

#include "testscrb.hpp"
#include <ccckit.hpp>

VirtualScrollBars::VirtualScrollBars( HWND w, HINSTANCE inst, int id )
			:	Dialog( w, inst, id )
{
	hResult = CreateSolidBrush( RGB(0, 0, 0) );
	_redBrush = CreateSolidBrush( RGB( 255, 0, 0 ) );
	_greenBrush = CreateSolidBrush( RGB( 0, 255, 0 ) );
	_blueBrush = CreateSolidBrush( RGB( 0, 0, 255 ) );
}


VirtualScrollBars::~VirtualScrollBars()
{
	if( hResult )
		DeleteObject( hResult );
	if( _redBrush )
		DeleteObject( _redBrush );
	if( _greenBrush )
		DeleteObject( _greenBrush );
	if( _blueBrush )
		DeleteObject( _blueBrush );
}


BOOL VirtualScrollBars::WmInitDialog(HWND hwnd, HWND cw, LPARAM lp )
{
	Dialog::WmInitDialog( hwnd, cw, lp );
	_rWnd = GetDlgItem( hwnd, IDC_RED );
	_gWnd = GetDlgItem( hwnd, IDC_GREEN );
	_bWnd = GetDlgItem( hwnd, IDC_BLUE );
	RegisterUserMsg( WM_CTLCOLOR );
	RegisterUserMsg( WM_CTLCOLORSCROLLBAR );
	RegisterUserMsg( EXSB_VSCROLL );

	SetWindowText( GetDlgItem( hwnd, IDC_RV ), "  0" );
	SetWindowText( GetDlgItem( hwnd, IDC_GV ), "  0" );
	SetWindowText( GetDlgItem( hwnd, IDC_BV ), "  0" );

	SendMessage( _rWnd, EXSB_SETLLIMIT, (WPARAM)0, (LPARAM)0 );
	SendMessage( _gWnd, EXSB_SETLLIMIT, (WPARAM)0, (LPARAM)0 );
	SendMessage( _bWnd, EXSB_SETLLIMIT, (WPARAM)0, (LPARAM)0 );
	SendMessage( _rWnd, EXSB_SETULIMIT, (WPARAM)0, (LPARAM)255 );
	SendMessage( _gWnd, EXSB_SETULIMIT, (WPARAM)0, (LPARAM)255 );
	SendMessage( _bWnd, EXSB_SETULIMIT, (WPARAM)0, (LPARAM)255 );

	SendMessage( _rWnd, EXSB_SETBARPOS, (WPARAM)0, (LPARAM)0 );
	SendMessage( _gWnd, EXSB_SETBARPOS, (WPARAM)0, (LPARAM)0 );
	SendMessage( _bWnd, EXSB_SETBARPOS, (WPARAM)0, (LPARAM)0 );

	return TRUE;
}


void VirtualScrollBars::WmDrawItem( HWND hwnd, const DRAWITEMSTRUCT FAR* lpDrawItem )
{
	if( lpDrawItem->hwndItem == GetDlgItem( hwnd, IDC_RESULT) && lpDrawItem->itemAction == ODA_DRAWENTIRE )
	{
		HBRUSH oldB = (HBRUSH)::SelectObject( lpDrawItem->hDC, hResult );
		HPEN oldP = (HPEN)::SelectObject( lpDrawItem->hDC, ::GetStockObject(NULL_PEN) );
		::Rectangle( lpDrawItem->hDC, lpDrawItem->rcItem.left,
							lpDrawItem->rcItem.top, lpDrawItem->rcItem.right,
							lpDrawItem->rcItem.bottom );
		::SelectObject( lpDrawItem->hDC, oldB );
		::SelectObject( lpDrawItem->hDC, oldP );
	}
}


BOOL VirtualScrollBars::HandleUserMsg( HWND w, UINT m, WPARAM, LPARAM lp )
{
#if defined(__WIN32__) || defined(__FLAT__)
	if( m == WM_CTLCOLORSCROLLBAR )
	{
		if( (HWND)(lp) == _rWnd )
			return (BOOL)_redBrush;
		if( (HWND)(lp) == _gWnd )
			return (BOOL)_greenBrush;
		if( (HWND)(lp) == _bWnd )
			return (BOOL)_blueBrush;
	}
#else
	if( m == WM_CTLCOLOR )
	{
		if( (HWND)LOWORD(lp) == _rWnd )
			return (BOOL)_redBrush;
		if( (HWND)LOWORD(lp) == _gWnd )
			return (BOOL)_greenBrush;
		if( (HWND)LOWORD(lp) == _bWnd )
			return (BOOL)_blueBrush;
	}
#endif
	if( m == EXSB_VSCROLL )
	{
		char tmp[ 5 ];
		LPSCROLLMSG sm = (LPSCROLLMSG)lp;
		wsprintf( tmp, "%3d", sm->nVal );
#if defined(__WIN32__) || defined(__FLAT__)
		if( (HWND)sm->hWnd == _rWnd )
#else
		if( (HWND)LOWORD(sm->hWnd) == _rWnd )
#endif
			SetWindowText( GetDlgItem( w, IDC_RV ), tmp );

#if defined(__WIN32__) || defined(__FLAT__)
		if( (HWND)sm->hWnd == _gWnd )
#else
		if( (HWND)LOWORD(sm->hWnd) == _gWnd )
#endif
			SetWindowText( GetDlgItem( w, IDC_GV ), tmp );

#if defined(__WIN32__) || defined(__FLAT__)
		if( (HWND)sm->hWnd == _bWnd )
#else
		if( (HWND)LOWORD(sm->hWnd) == _bWnd )
#endif
			SetWindowText( GetDlgItem( w, IDC_BV ), tmp );

		int r, g, b;
		r = (int)(short)SendMessage( _rWnd, EXSB_GETBARPOS, (WPARAM)0, (LPARAM)0 );
		g = (int)(short)SendMessage( _gWnd, EXSB_GETBARPOS, (WPARAM)0, (LPARAM)0 );
		b = (int)(short)SendMessage( _bWnd, EXSB_GETBARPOS, (WPARAM)0, (LPARAM)0 );
		if( hResult )
			DeleteObject( hResult );
		hResult = (HBRUSH)CreateSolidBrush( RGB( r, g, b ) );
		InvalidateRect( GetDlgItem( w, IDC_RESULT), NULL, TRUE );
		UpdateWindow( GetDlgItem( w, IDC_RESULT) );
		return TRUE;
	}

	return FALSE;
}


void VirtualScrollBars::WmCommand( HWND, int id, HWND, UINT )
{
	if( id == IDOK || id == IDCANCEL )
		PostMessage( GetParent(), DLG_EXIT_SB, (WPARAM)0, (LPARAM)0 );
}
