////////////////////////////////////////////////////////////////////////
//	Application	: Sample16.exe and Sample32.exe
//	File Name		: TestCaln.cpp
//	Date				: March 17, 1995
//	Remarks			: Dialog class to demonstrate Calendar Control
////////////////////////////////////////////////////////////////////////
//	COPYRIGHT
//  	Sapient Technology, Inc.
//  	Copyright  1994, 1995. All Rights Reserved.
//	AUTHOR
//  	Ravi Prakash
////////////////////////////////////////////////////////////////////////
#include "testcaln.hpp"
#include <stdlib.h>

static char *WeekDays[] =
{ "Sunday", "Monday", "Tuesday", "Wednesday",
	"Thursday", "Friday", "Saturday" };


TestCalendar::TestCalendar( HWND w, HINSTANCE inst, int id )
			:	Dialog( w, inst, id )
{
}


TestCalendar::~TestCalendar()
{
}


BOOL TestCalendar::WmInitDialog(HWND hwnd, HWND cw, LPARAM lp )
{
	Dialog::WmInitDialog( hwnd, cw, lp );
	_cal = GetDlgItem( hwnd, IDC_CAL );
	_dow = GetDlgItem( hwnd, IDC_DOW );
	_moy = GetDlgItem( hwnd, IDC_MONTH );
	_dom = GetDlgItem( hwnd, IDC_DAY );
	_yr  = GetDlgItem( hwnd, IDC_YEAR );
	_date= GetDlgItem( hwnd, IDC_DATE );

	RegisterUserMsg( CAL_SELCHANGE );

	if( _cal )
	{
		CALMSG _cm;
		SendMessage( _yr, EDIT_NUMFORMAT, (WPARAM)0, (LPARAM)0 );
		SendMessage( _yr, EDIT_READONLY, (WPARAM)1, (LPARAM)0 );
		SendMessage( _dom, EDIT_READONLY, (WPARAM)1, (LPARAM)0 );
		SendMessage( _moy, EDIT_READONLY, (WPARAM)1, (LPARAM)0 );
		SendMessage( _dow, EDIT_READONLY, (WPARAM)1, (LPARAM)0 );
		if( SendMessage( _cal, CAL_GETDATE, (WPARAM)0, (LPARAM)&_cm ) )
			TransferValues( &_cm );
	}

	return TRUE;
}


BOOL TestCalendar::HandleUserMsg( HWND, UINT m, WPARAM, LPARAM lp )
{
	if( m == CAL_SELCHANGE )
	{
		LPCALMSG _cm = (LPCALMSG)lp;
		TransferValues( _cm );
		return TRUE;
	}
	return FALSE;
}


void TestCalendar::WmCommand( HWND w, int id, HWND, UINT )
{
	if( id == IDOK || id == IDCANCEL )
		PostMessage( GetParent(), DLG_EXIT_CAL, (WPARAM)0, (LPARAM)0 );

	if( id == IDC_SETDATE )
	{
		EDITMSG _editMsg;
		CALMSG _calMsg;
		short int val;
		SendMessage( _date, EDIT_GETTEXT, (WPARAM)0, (LPARAM)&_editMsg );
		val = (short int)atoi( _editMsg.editTxt );
		_calMsg.calMonth = val;
		val = (short int)atoi( _editMsg.editTxt + 3 );
		_calMsg.calDom = val;
		val = (short int)atoi( _editMsg.editTxt + 6 );
		_calMsg.calYear = val;
		if( !SendMessage( _cal, CAL_SETDATE, (WPARAM)0, (LPARAM)&_calMsg ) )
			MessageBox( w, "Invalid Date string", "Date Error", MB_OK );
		isCommandDone = TRUE;
	}
}


void TestCalendar::TransferValues( LPCALMSG _cmsg )
{
	EDITMSG _editMsg;
	wsprintf( _editMsg.editTxt, "%s", WeekDays[ _cmsg->calDow ] );
	SendMessage( _dow, EDIT_SETTEXT, (WPARAM)0, (LPARAM)&_editMsg );
	wsprintf( _editMsg.editTxt, "%02d", _cmsg->calMonth );
	SendMessage( _moy, EDIT_SETTEXT, (WPARAM)0, (LPARAM)&_editMsg );
	wsprintf( _editMsg.editTxt, "%02d", _cmsg->calDom );
	SendMessage( _dom, EDIT_SETTEXT, (WPARAM)0, (LPARAM)&_editMsg );
	wsprintf( _editMsg.editTxt, "%4d", _cmsg->calYear );
	SendMessage( _yr, EDIT_SETTEXT, (WPARAM)0, (LPARAM)&_editMsg );

	wsprintf( _editMsg.editTxt, "%02d/%02d/%4d", _cmsg->calMonth,
												_cmsg->calDom, _cmsg->calYear );
	SendMessage( _date, EDIT_SETTEXT, (WPARAM)0, (LPARAM)&_editMsg );
}
