////////////////////////////////////////////////////////////////////////
//	Application	: Sample16.exe and Sample32.exe
//	File Name		: ResLoad.cpp
//	Date				: March 14, 1995
//	Remarks			: Dialog class Manager to Manage Tab Dialogs
////////////////////////////////////////////////////////////////////////
//	COPYRIGHT
//  	Sapient Technology, Inc.
//  	Copyright  1994, 1995. All Rights Reserved.
//	AUTHOR
//  	Ravi Prakash
////////////////////////////////////////////////////////////////////////

#include "resload.hpp"

static BOOL FAR PASCAL(*ctl3dSubclassCtl)( HWND ) = 0;

ResourceLoader::ResourceLoader( HWND pWnd, HINSTANCE hInst, BOOL ctl3d )
{
	_parentWnd = pWnd;
	_hInst = hInst;
	_numDlgs = 0;
	_currDlg = 0;
	_useCtl3d = ctl3d;
}


ResourceLoader::~ResourceLoader()
{
	if( _numDlgs )
	{
		for( int i = 0; i < _numDlgs; i++ )
			DestroyDlg( i );
	}
}


void ResourceLoader::EnableCtl3d( HINSTANCE ctl3dInst )
{
	if( _useCtl3d )
	{
		if( !ctl3dSubclassCtl )
		 (FARPROC)ctl3dSubclassCtl = GetProcAddress( ctl3dInst, "Ctl3dSubclassCtl" );
	}
}


BOOL ResourceLoader::AddDlg( LPCSTR resId, HINSTANCE resInst, BOOL hide )
{
	BOOL retVal = FALSE;
	HWND wnd = CreateDialogParam( resInst, resId, _parentWnd, NULL, NULL );
	if( wnd )
	{
		retVal = LoadControls( wnd );
		// Create the controls only if its the first sub-dlg
		if( retVal && _numDlgs == 1 )
			CreateDlgControls( _numDlgs - 1, hide );
	}
	return retVal;
}


BOOL ResourceLoader::AddDlg( int resId, HINSTANCE resInst, BOOL hide )
{
	BOOL retVal = FALSE;
	HWND wnd = CreateDialogParam( resInst, MAKEINTRESOURCE(resId),
																							_parentWnd, NULL, NULL );
	if( wnd )
	{
		retVal = LoadControls( wnd );
		// Create the controls only if its the first sub-dlg
		if( retVal && _numDlgs == 1 )
			CreateDlgControls( _numDlgs - 1, hide );
	}
	return retVal;
}


void ResourceLoader::SetOffSets( HWND center )
{
	_centerWnd = center;
}


BOOL ResourceLoader::HideDlg( BOOL cDestroy )
{
	LPDLGCTRLS ctrl = _dlgList[ _currDlg ];
	while( ctrl )
	{
		if( IsWindow(ctrl->cHwnd) )
		{
			if( cDestroy )
			{
				DestroyWindow( ctrl->cHwnd );
				ctrl->cHwnd = 0;
			}
			else
			{ // Turn OFF the WS_VISIBLE attribute in our variable too
				ctrl->windowStyle &= (~WS_VISIBLE);
				ShowWindow( ctrl->cHwnd, SW_HIDE );
				// Bug in IsDialogMessage() involving mnemonics.
				if( SendMessage( ctrl->cHwnd, WM_GETDLGCODE, (WPARAM)0, (LPARAM)0 ) == DLGC_STATIC )
					SetWindowText( ctrl->cHwnd, "" );
			}
		}
		ctrl = ctrl->nextCtrl;
	}
	if( cDestroy )
		_dlgStat[ _currDlg ] = FALSE;
	return TRUE;
}


BOOL ResourceLoader::ShowDlg( int nDlg, BOOL hide )
{
	if( nDlg >= 0 && nDlg < _numDlgs )
	{
		if( !_dlgStat[ nDlg ] )
			CreateDlgControls( nDlg, hide );
	}

	if( hide )
	{
		_currDlg = nDlg;
		return TRUE;
	}

	LPDLGCTRLS ctrl = _dlgList[ nDlg ];
	while( ctrl )
	{
		if( ctrl->cHwnd )
		{
			// Bug in IsDialogMessage() involving mnemonics in Win3.x atleast.
			if( SendMessage( ctrl->cHwnd, WM_GETDLGCODE, (WPARAM)0, (LPARAM)0 ) == DLGC_STATIC )
				SetWindowText( ctrl->cHwnd, ctrl->windowText );
			if( !( ctrl->windowStyle & WS_VISIBLE ) )
				ShowWindow( ctrl->cHwnd, SW_SHOW );
		}
		ctrl = ctrl->nextCtrl;
	}
	_currDlg = nDlg;
	return TRUE;
}


LPDLGCTRLS ResourceLoader::MakeNode()
{
	LPDLGCTRLS node = new DLGCTRLS;
	return node;
}


BOOL ResourceLoader::DestroyDlg( int nDlg )
{
	LPDLGCTRLS node, anchor;
	if( nDlg >= 0 && nDlg < _numDlgs )
	{
		anchor = _dlgList[ nDlg ];
		node = anchor;
		while( node )
		{
			anchor = node->nextCtrl;
			delete node;
			node = anchor;
		}
		_dlgList[ nDlg ] = 0;
		return TRUE;
	}
	return FALSE;
}


BOOL ResourceLoader::LoadControls( HWND dlg )
{
	BOOL retVal = TRUE;
	HWND ctrl = GetWindow( dlg, GW_CHILD );
	LPDLGCTRLS anchor = 0, node, cnode = 0;
	RECT	r, c;
	LPPOINT	p;

	GetWindowRect( _centerWnd, &c );
	p = (LPPOINT)&c;
	ScreenToClient( _parentWnd, p );

	while( ctrl && retVal )
	{
		node = MakeNode();
		if( !node )
			retVal = FALSE;
		else
		{
			node->dwExStyle = GetWindowLong( ctrl, GWL_EXSTYLE );
			node->windowStyle = GetWindowLong( ctrl, GWL_STYLE );
			GetClassName( ctrl, node->className, 16 );
			GetWindowText( ctrl, node->windowText, 32 );
			node->id = GetDlgCtrlID( ctrl );
			GetWindowRect( ctrl, &r );
			p = (LPPOINT)&r;
			ScreenToClient( dlg, p );
			p++;
			ScreenToClient( dlg, p );
			node->x = r.left + c.left;
			node->y = r.top + c.top;
			GetWindowRect( ctrl, &r );
			node->w = r.right - r.left;// + 1;
			node->h = r.bottom - r.top;// + 1;
			node->cHwnd = 0;

			if( lstrcmpi( node->className, "COMBOBOX" ) == 0 )
			{
				if( (node->windowStyle & CBS_DROPDOWNLIST) == CBS_DROPDOWNLIST ||
					(node->windowStyle & CBS_DROPDOWN) == CBS_DROPDOWN )
					node->h += 50;
			}

			// Must add especially for ctl3d controls
			if( _useCtl3d && lstrcmpi( node->className, "EDIT" ) == 0 ||
					lstrcmpi( node->className, "COMBOBOX" ) == 0 ||
					lstrcmpi( node->className, "LISTBOX" ) == 0)
				node->windowStyle |= WS_BORDER;

			node->nextCtrl = 0;
			if( !anchor )
			{
				anchor = node;
				cnode = anchor;
			}
			else
			{
				cnode->nextCtrl = node;
				cnode = node;
			}
			ctrl = GetWindow( ctrl, GW_HWNDNEXT );
		}
	}

	if( anchor )
	{
		_dlgList[ _numDlgs ] = anchor;
		_dlgStat[ _numDlgs ] = FALSE;
		_numDlgs++;
	}

	if( !retVal )
	{
		if( anchor )
			DestroyDlg( _numDlgs - 1 );
	}

	DestroyWindow( dlg );

	return retVal;
}


void ResourceLoader::CreateDlgControls( int nDlg, BOOL hide )
{
	LPDLGCTRLS ctrl = _dlgList[ nDlg ];
	HFONT hf = (HFONT)SendMessage( _parentWnd, WM_GETFONT, (WPARAM)0, (LPARAM)0 );
	while( ctrl )
	{
		if( hide )
			ctrl->windowStyle &= (~WS_VISIBLE);
		else
			ctrl->windowStyle |= WS_VISIBLE;
		ctrl->cHwnd = CreateWindowEx( ctrl->dwExStyle, ctrl->className,
																 ctrl->windowText, ctrl->windowStyle,
																 ctrl->x, ctrl->y, ctrl->w, ctrl->h,
																	_parentWnd, (HMENU)ctrl->id, _hInst, NULL );
		if( ctrl->cHwnd )
		{
			if( _useCtl3d )
				ctl3dSubclassCtl( ctrl->cHwnd );
			SendMessage( ctrl->cHwnd, WM_SETFONT, (WPARAM)hf, MAKELPARAM(0,0) );
		}
		ctrl = ctrl->nextCtrl;
	}
	_dlgStat[ nDlg ] = TRUE;
}



