////////////////////////////////////////////////////////////////////////
//	Application	: Sample16.exe and Sample32.exe
//	File Name		: Dialog.cpp
//	Date				: March 14, 1995
//	Remarks			: This file contains a generic class for dialog boxes
////////////////////////////////////////////////////////////////////////
//	COPYRIGHT
//  	Sapient Technology, Inc.
//  	Copyright  1994, 1995. All Rights Reserved.
//	AUTHOR
//  	Ravi Prakash
////////////////////////////////////////////////////////////////////////

#include "dialog.hpp"

static ManageDlgLink *DlgLinkMgr = 0;

// Manage Dialog Links

ManageDlgLink::~ManageDlgLink()
{
	if( dlgChain )
	{
		LPDLGLINK tmp = dlgChain->nextStruct;
		if( tmp )
		{
			while( tmp )
			{
				delete dlgChain;
				dlgChain = tmp;
				tmp = dlgChain->nextStruct;
			}
			// The last one left
			delete dlgChain;
		}
		else	// Means only head left
		{
			delete dlgChain;
		}
	}
}


BOOL ManageDlgLink::InsertLink( HWND w, LPVOID lpv )
{
	LPDLGLINK tmp = new DLGLINK;
	if( tmp )
	{
		numLinks++;
		tmp->wnd = w;
		tmp->dlgClass = lpv;
		tmp->nextStruct = 0;
		tmp->prevStruct = 0;
		if( !dlgChain )
		{
			dlgChain = tmp;
			return TRUE;
		}
		else
		{
			LPDLGLINK tmp2 = dlgChain;
			while( tmp2->nextStruct )
				tmp2 = tmp2->nextStruct;
			tmp2->nextStruct = tmp;
			tmp->prevStruct = tmp2;
			return TRUE;
		}
	}
	return FALSE;
}


BOOL ManageDlgLink::DeleteLink( HWND w )
{
	LPDLGLINK tmp = dlgChain;
	while( tmp && tmp->wnd != w )
		tmp = tmp->nextStruct;
	if( tmp )
	{
		numLinks--;
		if( tmp->prevStruct )
		{
			tmp->prevStruct->nextStruct = tmp->nextStruct;
			if( tmp->nextStruct )
				tmp->nextStruct->prevStruct = tmp->prevStruct;
			delete tmp;
		}
		else	// head
		{
			if( tmp->nextStruct )
			{
				tmp->nextStruct->prevStruct = 0;
				dlgChain = tmp->nextStruct;
			}
			else
				dlgChain = 0;
			delete tmp;
		}
		return TRUE;
	}
	return FALSE;
}


LPDLGLINK ManageDlgLink::FetchLink( HWND w )
{
	LPDLGLINK tmp = dlgChain;
	while( tmp && tmp->wnd != w )
		tmp = tmp->nextStruct;

	return tmp;
}


// Generic Dialog Procedure
BOOL WINAPI DialogProc( HWND w, UINT Msg, WPARAM wp, LPARAM lp )
{
	BOOL retVal = FALSE;
	if( DlgLinkMgr == 0 )
		DlgLinkMgr = new ManageDlgLink;

	LPDLGLINK link = DlgLinkMgr->FetchLink( w );
	if( !link )
	{
		if( Msg == WM_INITDIALOG )
		{
			Dialog *dlg = (Dialog *)lp;
			if( !DlgLinkMgr->InsertLink( w, (LPVOID)dlg ) )
			{
				dlg->Destroy();
				retVal = TRUE;
			}
			else
			{
				link = DlgLinkMgr->FetchLink( w );
				retVal = ((Dialog *)link->dlgClass)->ManageDlgMessage( w, Msg, wp, lp );
			}
		}
	}
	else
		retVal = ((Dialog *)link->dlgClass)->ManageDlgMessage( w, Msg, wp, lp );
	return retVal;
}


// Dialog class
Dialog::Dialog( HWND w, HINSTANCE hinst, int resId )
{
	dlgWnd = 0;
	dlgParent	= w;
	dlgInst	= hinst;
	dlgResId = resId;
	numUserMsg = 0;
}


Dialog::~Dialog()
{
	Destroy();
	if( DlgLinkMgr )
	{	// Remove ourselves from list
		if( DlgLinkMgr->DeleteLink( dlgWnd ) )
		{ // If we are the last in link the get rid of manager
			if( DlgLinkMgr->NumLinks() == 0 )
			{
				delete DlgLinkMgr;
				DlgLinkMgr = 0;
			}
		}
	}
}


int Dialog::Run( BOOL modal )
{
	isModal = modal;
	return Create();
}


void Dialog::Destroy( int clsId )
{
	if( !isModal )
	{
		if( IsWindow( dlgWnd ) )
			DestroyWindow( dlgWnd );
	}
	else
	{
		if( IsWindow( dlgWnd ) )
			EndDialog( dlgWnd, clsId );
	}
}


short int	Dialog::RegisterUserMsg( UINT msg )
{
	if( numUserMsg < NUM_USER_MESSAGE )
	{
		userMsg[ numUserMsg ] = msg;
		numUserMsg++;
		return (short int)(numUserMsg - 1);
	}
	return -1;
}


BOOL Dialog::WmInitDialog( HWND w, HWND, LPARAM )
{
	if( isModal )
  	dlgWnd = w;

	return TRUE;
}


void Dialog::WmCommand( HWND, int id, HWND, UINT )
{
	isCommandDone = TRUE;
	switch( id )
	{
		case IDOK:
			Destroy( IDOK );
			break;

		case IDCANCEL:
			Destroy();
			break;

		default:
			isCommandDone = FALSE;
			break;
	}
}


void Dialog::WmParentNotify( HWND, UINT, HWND, int )
{
}


void Dialog::WmHScroll( HWND, HWND, UINT, int )
{
}


void Dialog::WmVScroll( HWND, HWND, UINT, int )
{
}


void Dialog::WmDrawItem( HWND, const DRAWITEMSTRUCT FAR* )
{
}


BOOL Dialog::IsUserMsg( UINT msg )
{
	BOOL found = FALSE;
	short int i;
	for( i = 0; i < numUserMsg && !found; i++ )
	{
		if( userMsg[ i ] == msg )
			found = TRUE;
	}
	return found;
}


int Dialog::Create()
{
	int ret;
	if( isModal )
		ret = DialogBoxParam( dlgInst, MAKEINTRESOURCE(dlgResId),
													dlgParent, (DLGPROC)DialogProc, (LPARAM)(LPVOID)this );
	else
	{
		dlgWnd = CreateDialogParam( dlgInst, MAKEINTRESOURCE(dlgResId),
											dlgParent, (DLGPROC)DialogProc, (LPARAM)(LPVOID)this );
		if( dlgWnd )
		{
			ShowWindow( dlgWnd, SW_SHOW );
			ret = 1;
		}
	}

	return ret;
}


BOOL Dialog::ManageDlgMessage( HWND w, UINT Msg, WPARAM wParam, LPARAM lParam )
{
	BOOL isProcessed = TRUE;

	switch( Msg )
	{
		// Start up function instead of WM_CREATE etc.
		case WM_INITDIALOG:
			isProcessed = (BOOL)HANDLE_WM_INITDIALOG( w, wParam, lParam, WmInitDialog );
			break;

		// For All control messages
		case WM_COMMAND:
			HANDLE_WM_COMMAND( w, wParam, lParam, WmCommand );
      isProcessed = isCommandDone;
			break;

		// For Mouse clicks on control
		case WM_PARENTNOTIFY:
			HANDLE_WM_PARENTNOTIFY( w, wParam, lParam, WmParentNotify );
			break;

		// For Scroll Bar Controls in Dialog
		case WM_HSCROLL:
			HANDLE_WM_HSCROLL( w, wParam, lParam, WmHScroll );
			break;

		case WM_VSCROLL:
			HANDLE_WM_VSCROLL( w, wParam, lParam, WmVScroll );
			break;

		case WM_DRAWITEM:
			HANDLE_WM_DRAWITEM( w, wParam, lParam, WmDrawItem );
			break;

		default:
			if( IsUserMsg( Msg ) )
      	return HandleUserMsg( w, Msg, wParam, lParam );
			else
				isProcessed = FALSE;
			break;
	}
  isCommandDone = FALSE;
	return isProcessed;
}

