////////////////////////////////////////////////////////////////////////
//	Application	: Sample16.exe and Sample32.exe
//	File Name		: Main.cpp
//	Date				: March 14, 1995
//	Remarks			: This file has the main code for winmain and the main
//								window.  The code is written using message crakers
//								allow for 16bit and 32bit compiles.
////////////////////////////////////////////////////////////////////////
//	COPYRIGHT
//  	Sapient Technology, Inc.
//  	Copyright  1994, 1995. All Rights Reserved.
//	AUTHOR
//  	Ravi Prakash
////////////////////////////////////////////////////////////////////////

#include "main.hpp"
#include "testscrb.hpp"
#include "testspin.hpp"
#include "testlbox.hpp"
#include "testtab.hpp"
#include "testcaln.hpp"
#include "testedit.hpp"

// Static vars
static AboutDlg *aboutDlg = 0;
static CCCKPriceDlg *priceDlg = 0;
static TestSpin *spinDlg = 0;
static VirtualScrollBars *vsb = 0;
static TestListBox *lboxDlg = 0;
static TestTab *tabTop = 0;
static TestTab *tabLeft = 0;
static TestTab *tabBot = 0;
static TestTab *tabRight = 0;
static TestCalendar *calDlg = 0;
static TestEdit *editDlg = 0;

#define		DLG_EXIT_ABOUT		WM_USER + 13000
#define		DLG_EXIT_PRICES		WM_USER + 13007


#if defined(__WIN32__) || defined(__FLAT__)
const char appName[] = "Custom Controls Collection Kit [CCCKIT32.DLL]";
const char aboutCaption[] = "About Sample32.exe";
const char CCCkitName[] = "CCCKIT32.DLL";
const char wClass[] = "STI_WIN32";
const char infoClass[] = "STI_INFO32";
const char appIcon[] = "SAMPLE32ICO";
#else
const char appName[] = "Custom Controls Collection Kit [CCCKIT.DLL]";
const char aboutCaption[] = "About Sample16.exe";
const char CCCkitName[] = "CCCKIT.DLL";
const char wClass[] = "STI_WIN16";
const char infoClass[] = "STI_INFO16";
const char appIcon[] = "SAMPLE16ICO";
#endif

// Shared handle
HINSTANCE hInst			= 0;
static HINSTANCE hPrevInst	= 0;
static int nCmdShow = 0;
static void		CleanUpApp();
static int		MessageLoop( void );
static BOOL		DlgMessage( LPMSG );
static int		RegisterMainWindow();


// Cleanup operation
void CleanUpApp()
{
	if( aboutDlg )
		delete aboutDlg;
	aboutDlg = 0;
	if( priceDlg )
		delete priceDlg;
	priceDlg = 0;
	if( vsb )
		delete vsb;
	vsb = 0;
	if( spinDlg )
		delete spinDlg;
	spinDlg = 0;
	if( lboxDlg )
		delete lboxDlg;
	lboxDlg = 0;
	if( tabTop )
		delete tabTop;
	tabTop = 0;
	if( tabLeft )
		delete tabLeft;
	tabLeft = 0;
	if( tabBot )
		delete tabBot;
	tabBot = 0;
	if( tabRight )
		delete tabRight;
	tabRight = 0;
	if( calDlg )
		delete calDlg;
	calDlg = 0;
	if( editDlg )
		delete editDlg;
	editDlg = 0;
}

// Message loop
BOOL DlgMessage( LPMSG msg )
{
	BOOL ret = FALSE;
	if( aboutDlg )
		ret = IsDialogMessage( aboutDlg->GetWnd(), msg );
	if( priceDlg )
		ret = IsDialogMessage( priceDlg->GetWnd(), msg );
	if( !ret && spinDlg )
		ret = IsDialogMessage( spinDlg->GetWnd(), msg );
	if( !ret && vsb )
		ret = IsDialogMessage( vsb->GetWnd(), msg );
	if( !ret && lboxDlg )
		ret = IsDialogMessage( lboxDlg->GetWnd(), msg );
	if( !ret && tabTop )
		ret = IsDialogMessage( tabTop->GetWnd(), msg );
	if( !ret && tabLeft )
		ret = IsDialogMessage( tabLeft->GetWnd(), msg );
	if( !ret && tabBot )
		ret = IsDialogMessage( tabBot->GetWnd(), msg );
	if( !ret && tabRight )
		ret = IsDialogMessage( tabRight->GetWnd(), msg );
	if( !ret && calDlg )
		ret = IsDialogMessage( calDlg->GetWnd(), msg );
	if( !ret && editDlg )
		ret = IsDialogMessage( editDlg->GetWnd(), msg );
	return ret;
}

int MessageLoop( void )
{
	MSG msg;

	while( GetMessage( &msg, NULL, 0, 0 ) )
	{
		if( !DlgMessage( &msg ) )
		{
			TranslateMessage( &msg );
			DispatchMessage( &msg );
		}
	}
	return msg.wParam;
}


int RegisterMainWindow()
{
	WNDCLASS wndclass;   // Structure used to register Windows class.

	wndclass.style         = CS_HREDRAW | CS_VREDRAW;
	wndclass.lpfnWndProc   = (WNDPROC)MainWindow::WndProc;
	wndclass.cbClsExtra    = 0;
	// Reserve extra bytes for each instance of the window;
	// we will use these bytes to store the this pointer
	wndclass.cbWndExtra    = sizeof( MainWindow * );
	wndclass.hInstance     = hInst;
	wndclass.hIcon         = LoadIcon( hInst, appIcon );
	wndclass.hCursor       = LoadCursor( NULL, IDC_ARROW );
	wndclass.hbrBackground = (HBRUSH)GetStockObject( WHITE_BRUSH );
	wndclass.lpszMenuName  = MAKEINTRESOURCE(SAMPLE_MENU);
	wndclass.lpszClassName = wClass;

	if( !RegisterClass( &wndclass ) )
		return 0;

	return 1;
}

// Info stuff prototypes
LRESULT WINAPI InfoWndProc( HWND , UINT , WPARAM , LPARAM  );
void InfoPaint( HWND );
void CheckInfoSize( HWND, int, int );

static char InfoData[ 24 ][ 80 ] =
{
	"                 *** THANK YOU FOR EVALUATING OUR PRODUCT ***",
	"",
	"Now you can share the benefit of a high quality product with a low cost",
	"marketing strategy.  No glitzy advertisements, no glossy manuals.",
	"Instead we pass the savings on to you by using the shareware concept.",
	"",
	"NEW TO WINDOWS - Just learning to use custom controls?  Buy the",
	"source code and you'll jumpstart your learning process.  Compare our",
	"prices to other company's that want $500+ just for their source code.",
	"Our kit provides quality controls & source for a very reasonable price.",
	"",
	"WINDOWS EXPERTS - Need high powered tools to cut your development",
	"time?  While delivering a great look and feel to your application?",
	"Our controls are thoroughly tested in our own applications before",
	"being made available as shareware.  We provide excellent technical",
	"support to all our customers via CIS, Internet or phone.  We",
	"understand the importance of having control over your investment so",
	"we make the source code available.",
	"",
	"We have several years of experience in OOPs, C/C++ and Windows",
	"programming.  If needed, we can also design and produce controls",
	"that are specific to your company's needs.",
	"",
	"                 CALL US NOW TO REGISTER @ 703-729-5936.",
/*
	line 4  bold    high quality       low cost
				line 7  color   NEW TO WINDOWS
				line 8  bold    jumpstart your learning
				line 12 color   WINDOWS EXPERTS
				line 12 bold    high powered tools
				line 13 bold    great look and feel
				line 24 color   (entire line)
*/
};



int RegisterInfoWindow()
{
	WNDCLASS wndclass;   // Structure used to register Windows class.

	wndclass.style         = CS_HREDRAW | CS_VREDRAW;
	wndclass.lpfnWndProc   = (WNDPROC)InfoWndProc;
	wndclass.cbClsExtra    = 0;
	// Reserve extra bytes for each instance of the window;
	// we will use these bytes to store the this pointer
	wndclass.cbWndExtra    = 0;
	wndclass.hInstance     = hInst;
	wndclass.hIcon         = NULL;
	wndclass.hCursor       = LoadCursor( NULL, IDC_ARROW );
	wndclass.hbrBackground = (HBRUSH)GetStockObject( LTGRAY_BRUSH );
	wndclass.lpszMenuName  = 0;
	wndclass.lpszClassName = infoClass;

	if( !RegisterClass( &wndclass ) )
		return 0;

	return 1;
}


LRESULT WINAPI InfoWndProc( HWND Window, UINT iMessage, WPARAM wParam, LPARAM lParam )
{
	LRESULT retVal = 0;

	switch( iMessage )
	{
		case WM_PAINT:
			InfoPaint( Window );
			break;

		case WM_SIZE:
			CheckInfoSize( Window, LOWORD(lParam), HIWORD(lParam) );
			break;

		default:
			retVal = DefWindowProc( Window, iMessage, wParam, lParam );
			break;
	}
	return retVal;
}


void CheckInfoSize( HWND HWindow, int width, int height )
{
	TEXTMETRIC tm;
	int w, h, cap, x, y;
	SIZE sz;
	HDC dc = GetDC( HWindow );
	GetTextMetrics( dc, &tm );
	w = 0;
	for( x = 0; x < 24; x++ )
	{
		GetTextExtentPoint( dc, InfoData[ x ], lstrlen(InfoData[x]), &sz );
		if( sz.cx > w )
			w = sz.cx;
	}
	ReleaseDC( HWindow, dc );
	h = tm.tmHeight + tm.tmExternalLeading;

	h = (h * 24) + 4;
	w = w + 4;
	cap = GetSystemMetrics( SM_CYCAPTION );
	x = ( GetSystemMetrics( SM_CXFULLSCREEN ) - w ) / 2;
	y = ( GetSystemMetrics( SM_CYFULLSCREEN ) - h ) / 2;

	if( h != height || w != width )
		MoveWindow( HWindow, x, y, w, h + cap, TRUE );
}


void InfoPaint( HWND HWindow )
{
	PAINTSTRUCT ps;
	RECT r;
	TEXTMETRIC tm;
	int x, y, h, i;


	// Always call beginPaint first
	HDC dc = BeginPaint( HWindow, &ps );
	GetClientRect( HWindow, &r );

	// Measurements
	GetTextMetrics( dc, &tm );
	h = tm.tmHeight + tm.tmExternalLeading;
	x = 2;
	y = 2;

	// Tools
	HBRUSH titBrush = CreateSolidBrush( RGB( 0, 255, 255 ) );
	HBRUSH oldBrush = (HBRUSH)SelectObject( dc, titBrush );
	HPEN oldPen = (HPEN)SelectObject( dc, GetStockObject( NULL_PEN ) );
	Rectangle( dc, r.left, r.top, r.right, r.top + h + h );
	SelectObject( dc, oldBrush );
	DeleteObject( titBrush );

	// Draw Text
	SetBkColor( dc, RGB( 0, 255, 255 ) );
	SetTextColor( dc, RGB( 0, 0, 0 ) );
	TextOut( dc, x, y + 2, InfoData[ 0 ], lstrlen(InfoData[ 0 ]) );
	y += ( h * 2 );

	SetBkColor( dc, RGB( 192, 192, 192 ) );
	SetTextColor( dc, RGB( 0, 0, 0 ) );
	for( i = 2; i < 24; i++ )
	{
		TextOut( dc, x, y, InfoData[ i ], lstrlen(InfoData[ i ]) );
		y += h;
	}

	// Put original tools back into shelf
	SelectObject( dc, oldBrush );
	SelectObject( dc, oldPen );

	// When done call endPaint
	EndPaint( HWindow, &ps );
}




int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR, int Show )
{
	hInst			= hInstance;
	hPrevInst = hPrevInstance;
	nCmdShow	= Show;

	if( !hPrevInst )
	{
		if( !RegisterMainWindow() )
		{
			MessageBox( 0,
			"Unable to register mainwindow class",
			"Registration Error", MB_OK );
			return -1;
		}
	}
	else
	{	// Will never come here for Windows NT
		MessageBox( 0,
		"An instance of this application is already running",
		"Existing Instance", MB_OK );
		return -1;
	}

	MainWindow mainWindow;
	if( !mainWindow.GetStatus() )
	{
		MessageBox( 0,
		"Unable to create main window", "Window Creation Error", MB_OK );
		return -1;
	}

	// Info stuff
	long wait = GetTickCount() + 3000;
	while( GetTickCount() < wait )
		;
	RegisterInfoWindow();
	CreateWindowEx( 0, infoClass, "CCCKIT INFORMATION",
					WS_POPUP|WS_VISIBLE|WS_CAPTION|WS_BORDER|WS_SYSMENU,
					CW_USEDEFAULT, CW_USEDEFAULT, 200, 200,
					mainWindow.GetMainWnd(), NULL, hInst, 0 );


	return MessageLoop();
}



// MainWindow Class Member Functions
MainWindow::MainWindow()
{
	ccck	= LoadLibrary( CCCkitName );
#if defined(__WIN32__) || defined(__FLAT__)
	char tmp[ 48 ];
	lstrcpy( tmp, "CCCKIT32.DLL should be in current directory" );
	if( ccck == NULL )
#else
	char tmp[ 48 ];
	lstrcpy( tmp, "CCCKIT.DLL should be in current directory" );
	if( (UINT)ccck <= 32 )
#endif
	{
		char err[ 96 ];
		wsprintf( err, "LoadLibrary : %d - ", (int)ccck );
		lstrcat( err, tmp );
		MessageBox( 0, err, "LoadLibrary Error", MB_OK );
		hWnd = 0;
		return;
	}
	hWnd = CreateWindowEx( 0, wClass, appName, WS_OVERLAPPEDWINDOW,
												 CW_USEDEFAULT, CW_USEDEFAULT,
												 CW_USEDEFAULT, CW_USEDEFAULT, NULL,
												 NULL, hInst, this );
	// Client should check status flag before getting into loop
	if( hWnd )
	{
		ShowWindow( hWnd, SW_SHOWMAXIMIZED );
		UpdateWindow( hWnd );
	}
}


MainWindow::~MainWindow()
{
#if defined(__WIN32__) || defined(__FLAT__)
	if( ccck )
		FreeLibrary( ccck );
#else
	if( (UINT)ccck > 32 )
		FreeLibrary( ccck );
#endif
}


LRESULT WINAPI MainWindow::WndProc( HWND Window, UINT iMessage, WPARAM wParam, LPARAM lParam )
{
	LRESULT retVal = 0;
	MainWindow *mw = (MainWindow *)GetWindowLong( Window, 0 );

	switch (iMessage)
	{
		case DLG_EXIT_ABOUT:
			if( aboutDlg )
			{
				delete aboutDlg;
				aboutDlg = 0;
			}
			break;

		case DLG_EXIT_PRICES:
			if( priceDlg )
			{
				delete priceDlg;
				priceDlg = 0;
			}
			break;

		case DLG_EXIT_SB:
			if( vsb )
			{
				delete vsb;
				vsb = 0;
			}
			break;

		case DLG_EXIT_SPIN:
			if( spinDlg )
			{
				delete spinDlg;
				spinDlg = 0;
			}
			break;

		case DLG_EXIT_LBOX:
			if( lboxDlg )
			{
				delete lboxDlg;
				lboxDlg = 0;
			}
			break;

		case DLG_EXIT_TABTOP:
			if( tabTop )
			{
				delete tabTop;
				tabTop = 0;
			}
			break;

		case DLG_EXIT_TABLEFT:
			if( tabLeft )
			{
				delete tabLeft;
				tabLeft = 0;
			}
			break;

		case DLG_EXIT_TABBOT:
			if( tabBot )
			{
				delete tabBot;
				tabBot = 0;
			}
			break;

		case DLG_EXIT_TABRIGHT:
			if( tabRight )
			{
				delete tabRight;
				tabRight = 0;
			}
			break;

		case DLG_EXIT_CAL:
			if( calDlg )
			{
				delete calDlg;
				calDlg = 0;
			}
			break;

		case DLG_EXIT_EDIT:
			if( editDlg )
			{
				delete editDlg;
				editDlg = 0;
			}
			break;

		case WM_CREATE:
			SetWindowLong( Window, 0, (LONG)(MainWindow*)(LPCREATESTRUCT)lParam );
			break;

		case WM_COMMAND:
			switch(GET_WM_COMMAND_ID(wParam, lParam))
			{
				case CM_SPINDEMO:
#				if defined(__WIN32__) || defined(__FLAT__)
					if( mw->ccck != NULL )
					{
#				else
					if( (UINT)mw->ccck > 32 )
					{
#				endif
						if( !spinDlg )
						{
							spinDlg = new TestSpin( Window, hInst, SPINTEST );
							spinDlg->Run( FALSE );
						}
						else
							SetFocus( spinDlg->GetWnd() );
					}
					else
						MessageBox( Window, "CCCKIT is not loaded", "DLL Error", MB_OK );
					break;

				case CM_SCROLLDEMO:
#				if defined(__WIN32__) || defined(__FLAT__)
					if( mw->ccck != NULL )
					{
#				else
					if( (UINT)mw->ccck > 32 )
					{
#				endif
						if( !vsb )
						{
							vsb = new VirtualScrollBars( Window, hInst, SCROLLBARTEST );
							vsb->Run( FALSE );
						}
						else
							SetFocus( vsb->GetWnd() );
					}
					else
						MessageBox( Window, "CCCKIT is not loaded", "DLL Error", MB_OK );
					break;

				case CM_CALENDARDEMO:
#				if defined(__WIN32__) || defined(__FLAT__)
					if( mw->ccck != NULL )
					{
#				else
					if( (UINT)mw->ccck > 32 )
					{
#				endif
						if( !calDlg )
						{
							calDlg = new TestCalendar( Window, hInst, CALTEST );
							calDlg->Run( FALSE );
						}
						else
							SetFocus( calDlg->GetWnd() );
					}
					else
						MessageBox( Window, "CCCKIT is not loaded", "DLL Error", MB_OK );
					break;

				case CM_LISTBOXDEMO:
#				if defined(__WIN32__) || defined(__FLAT__)
					if( mw->ccck != NULL )
					{
#				else
					if( (UINT)mw->ccck > 32 )
					{
#				endif
						if( !lboxDlg )
						{
							lboxDlg = new TestListBox( Window, hInst, LISTBOXTEST );
							lboxDlg->Run( FALSE );
						}
						else
							SetFocus( lboxDlg->GetWnd() );
					}
					else
						MessageBox( Window, "CCCKIT is not loaded", "DLL Error", MB_OK );
					break;

				case CM_TOPTAB:
#				if defined(__WIN32__) || defined(__FLAT__)
					if( mw->ccck != NULL )
					{
#				else
					if( (UINT)mw->ccck > 32 )
					{
#				endif
						if( !tabTop )
						{
							tabTop = new TestTab( Window, hInst, TABTOPDLGTEST );
							tabTop->Run( FALSE );
						}
						else
							SetFocus( tabTop->GetWnd() );
					}
					else
						MessageBox( Window, "CCCKIT is not loaded", "DLL Error", MB_OK );
				break;

				case CM_LEFTTAB:
#				if defined(__WIN32__) || defined(__FLAT__)
					if( mw->ccck != NULL )
					{
#				else
					if( (UINT)mw->ccck > 32 )
					{
#				endif
						if( !tabLeft )
						{
							tabLeft = new TestTab( Window, hInst, TABLEFTDLGTEST );
							tabLeft->Run( FALSE );
						}
						else
							SetFocus( tabLeft->GetWnd() );
					}
					else
						MessageBox( Window, "CCCKIT is not loaded", "DLL Error", MB_OK );
				break;

				case CM_BOTTOMTAB:
#				if defined(__WIN32__) || defined(__FLAT__)
					if( mw->ccck != NULL )
					{
#				else
					if( (UINT)mw->ccck > 32 )
					{
#				endif
						if( !tabBot )
						{
							tabBot = new TestTab( Window, hInst, TABBOTDLGTEST );
							tabBot->Run( FALSE );
						}
						else
							SetFocus( tabBot->GetWnd() );
					}
					else
						MessageBox( Window, "CCCKIT is not loaded", "DLL Error", MB_OK );
				break;

				case CM_RIGHTTAB:
#				if defined(__WIN32__) || defined(__FLAT__)
					if( mw->ccck != NULL )
					{
#				else
					if( (UINT)mw->ccck > 32 )
					{
#				endif
						if( !tabRight )
						{
							tabRight = new TestTab( Window, hInst, TABRIGHTDLGTEST );
							tabRight->Run( FALSE );
						}
						else
							SetFocus( tabRight->GetWnd() );
					}
					else
						MessageBox( Window, "CCCKIT is not loaded", "DLL Error", MB_OK );
				break;

				case CM_EDITCONTROL:
#				if defined(__WIN32__) || defined(__FLAT__)
					if( mw->ccck != NULL )
					{
#				else
					if( (UINT)mw->ccck > 32 )
					{
#				endif
						if( !editDlg )
						{
							editDlg = new TestEdit( Window, hInst, EDITDLGTEST );
							editDlg->Run( FALSE );
						}
						else
							SetFocus( editDlg->GetWnd() );
					}
					else
						MessageBox( Window, "CCCKIT is not loaded", "DLL Error", MB_OK );
				break;

				case CM_HELPABOUT:
					if( !aboutDlg )
					{
						aboutDlg = new AboutDlg( Window, hInst, IDD_ABOUT );
						aboutDlg->Run( FALSE );
					}
					else
						SetFocus( aboutDlg->GetWnd() );
					break;

				case CM_FILEPRICES:
					if( !priceDlg )
					{ 
						priceDlg = new CCCKPriceDlg( Window, hInst, CCCKITPRICES );
						priceDlg->Run( FALSE );
					}
					else
						SetFocus( priceDlg->GetWnd() );
					break;

				case CM_EXIT:
					CleanUpApp();
					DestroyWindow( Window );
					break;
			}
			break;

		case WM_CLOSE:
			CleanUpApp();
			DestroyWindow( Window );
			break;

		case WM_DESTROY:
			PostQuitMessage( 0 );
			break;

		default:
			retVal = DefWindowProc( Window, iMessage, wParam, lParam );
	}

	return retVal;
}


// About Dialog

AboutDlg::AboutDlg( HWND w, HINSTANCE hinst, int id ) :
					Dialog( w, hinst, id )
{
}


AboutDlg::~AboutDlg()
{
}


BOOL AboutDlg::WmInitDialog( HWND hwnd, HWND, LPARAM )
{
	SetWindowText( hwnd, aboutCaption );
	SetWindowText( GetDlgItem( hwnd, IDC_VERSION ), "Version 1.51" );
	return TRUE;
}


void AboutDlg::WmCommand( HWND, int id, HWND, UINT )
{
	if( id == IDOK || id == IDCANCEL )
		PostMessage( GetParent(), DLG_EXIT_ABOUT, (WPARAM)0, (LPARAM)0 );
}


// CCCKIT Prices

CCCKPriceDlg::CCCKPriceDlg( HWND w, HINSTANCE hinst, int id ) :
					Dialog( w, hinst, id )
{
}


CCCKPriceDlg::~CCCKPriceDlg()
{
}


void CCCKPriceDlg::WmCommand( HWND, int id, HWND, UINT )
{
	if( id == IDOK || id == IDCANCEL )
		PostMessage( GetParent(), DLG_EXIT_PRICES, (WPARAM)0, (LPARAM)0 );
}




