////////////////////////////////////////////////////////////////////////
//	Application	: Sample16.exe and Sample32.exe
//	File Name		: Dialog.hpp
//	Date				: March 14, 1995
//	Remarks			: This file contains a generic class for dialog boxes
////////////////////////////////////////////////////////////////////////
//	COPYRIGHT
//  	Sapient Technology, Inc.
//  	Copyright  1994, 1995. All Rights Reserved.
//	AUTHOR
//  	Ravi Prakash
////////////////////////////////////////////////////////////////////////
#ifndef __DIALOG__H
#define __DIALOG__H
#include <windows.h>
#include <windowsx.h>

// C function
extern "C" BOOL WINAPI DialogProc( HWND, UINT, WPARAM, LPARAM );

typedef struct DlgLink DLGLINK;
typedef struct DlgLink *LPDLGLINK;

struct DlgLink{
	HWND wnd;
	LPVOID dlgClass;
	LPDLGLINK nextStruct;
	LPDLGLINK prevStruct;
};

class ManageDlgLink {
	LPDLGLINK	dlgChain;
	short int numLinks;
public:
	ManageDlgLink() { numLinks = 0; dlgChain = 0; }
	~ManageDlgLink();

	short int NumLinks() const { return numLinks; }
	BOOL InsertLink( HWND, LPVOID );
	BOOL DeleteLink( HWND );
  LPDLGLINK FetchLink( HWND );
};


#define			NUM_USER_MESSAGE		16
class Dialog {
	HINSTANCE	dlgInst;
	HWND			dlgParent;
	HWND			dlgWnd;
	BOOL			isModal;
	int				dlgResId;
	short int numUserMsg;
	UINT			userMsg[ NUM_USER_MESSAGE ];

protected:
	BOOL			isCommandDone;

public:
	Dialog( HWND, HINSTANCE, int );
	virtual ~Dialog();

	BOOL	IsModal() const { return isModal; }
	HWND	GetWnd() const { return dlgWnd; }
	HWND	GetParent() const { return dlgParent; }
	int   Run( BOOL modal = TRUE );
	// Can overide to get data from controls etc.
	virtual void Destroy( int clsId = IDCANCEL );
  short int	RegisterUserMsg( UINT );

protected:
	virtual BOOL WmInitDialog(HWND hwnd, HWND hwndFocus, LPARAM lParam);
	virtual void WmCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify);
	virtual void WmParentNotify(HWND hwnd, UINT msg, HWND hwndChild, int idChild);
	virtual void WmHScroll(HWND hwnd, HWND hwndCtl, UINT code, int pos);
	virtual void WmVScroll(HWND hwnd, HWND hwndCtl, UINT code, int pos);
	virtual void WmDrawItem(HWND hwnd, const DRAWITEMSTRUCT FAR* lpDrawItem);
	virtual BOOL HandleUserMsg( HWND, UINT, WPARAM, LPARAM ){ return TRUE; };
	BOOL				 IsUserMsg( UINT );

private:
	// Special function for creating based on isModal
	virtual int Create();
	virtual BOOL ManageDlgMessage( HWND, UINT, WPARAM, LPARAM );

	// Making him friend will allow him to call destroy etc.
	friend BOOL WINAPI DialogProc( HWND, UINT, WPARAM, LPARAM );
};

#endif
