////////////////////////////////////////////////////////////////////////
//	Application	: Sample16.exe and Sample32.exe
//	File Name		: Data.hpp
//	Date				: March 14, 1995
//	Remarks			: Sample File Handler
////////////////////////////////////////////////////////////////////////
//	COPYRIGHT
//  	Sapient Technology, Inc.
//  	Copyright  1994, 1995. All Rights Reserved.
//	AUTHOR
//  	Ravi Prakash
////////////////////////////////////////////////////////////////////////

#ifndef SAMPLEDATA_HPP
#define SAMPLEDATA_HPP

#include <windows.h>
#include <ccckit.hpp>

#ifdef __cplusplus
extern "C" {
#endif
typedef struct {
	char FName	[ 16 ];
	char LName	[ 16 ];
	char Address[ 32 ];
	char City		[ 16 ];
	char State	[ 3 ];
	char Zip		[ 6 ];
} DATAREC, far *LPDATAREC;
#ifdef __cplusplus
}
#endif

//#define	DEBUG_VER


class DataBase {
	BOOL  	_fileOk;
	int 		_recCount;
	int 		_currRec;
	DATAREC _buffer;
public:
	DataBase();
	~DataBase();

	BOOL InitDb();

	LPDATAREC dbGoTop();
	LPDATAREC dbGoBottom();
	LPDATAREC dbGetRec();
	LPDATAREC dbGetRec( int );
	LPDATAREC dbGoNext();
	LPDATAREC dbGoPrev();

private:
	void CreateFile();
	void OpenFile();
	void CloseFile();
	BOOL Read( int );

protected:
	DataBase( const DataBase& );
	DataBase& operator=( const DataBase& );
};


// Function prototype helpers for listbox control
BOOL	ReadColWidth( LPVLBCOLUMNS );
BOOL	WriteColWidth( LPVLBCOLUMNS );

#endif
