//**************************************************************************
//
//  Title: WINAUX
//
//  Author: Jim Cash
//  Version: 1.1
//  Revision History:
//    Original version: February 1990
//    V1.1: April 1990
//
//  Purpose:
//      This app will poll the WINOX.SYS device driver and will display
//      the contents of its buffer every tenth of a second.
//
//**************************************************************************
#define _WINDOWS
#include <WINDOWS.H>
#include "WINAUX.H"

//*------------------------------------------------------------------------
//| Global Variables
//*------------------------------------------------------------------------
HANDLE  hInst;

//*------------------------------------------------------------------------
//| WinMain:
//|     Parameters:
//|         hInstance     - Handle to current Data Segment
//|         hPrevInstance - Handle to previous Data Segment (NULL if none)
//|         lpszCmdLine   - Long pointer to command line info
//|         CmdShow       - Integer value specifying how to start app.,
//|                            (Iconic or Normal)
//*------------------------------------------------------------------------
int PASCAL WinMain (HANDLE hInstance,
                    HANDLE hPrevInstance,
                    LPSTR  lpszCmdLine,
                    int    CmdShow)
{
int nReturn;

    if (Init(hInstance, hPrevInstance,lpszCmdLine,CmdShow))
    {
        nReturn = DoMain(hInstance);
    }
    return nReturn;
}

//*------------------------------------------------------------------------
//| Init
//|     Initialization for the program is done here:
//|     1)  Register the window class (if this is the first instance)
//|     2)  Create the desktop window for the app.
//|     3)  Show the desktop window in the manner requested by the User.
//|
//*------------------------------------------------------------------------
BOOL Init(HANDLE hInstance,   HANDLE hPrevInstance,
          LPSTR  lpszCmdLine, int    nCmdShow)
{
WNDCLASS    rClass;
HWND        hWnd1;
HMENU       hMenu;

    hInst = hInstance;

    if (!hPrevInstance)
    {
        /*  Register Class for First Overlapped Window  */
        rClass.lpszClassName = "MSU:OVERLAPPED1";
        rClass.hInstance     = hInst;
        rClass.lpfnWndProc   = OverlappedWindowProc1;
        rClass.hCursor       = LoadCursor(hInstance,"APPCURSOR");
        rClass.hIcon         = LoadIcon(hInstance,"APPICON");
        rClass.lpszMenuName  = NULL;
        rClass.hbrBackground = GetStockObject(BLACK_BRUSH);
        rClass.style         = CS_HREDRAW|CS_VREDRAW;
        rClass.cbClsExtra    = 0;
        rClass.cbWndExtra    = 0;

        if (!RegisterClass( &rClass))
            return FALSE;

    }

    hWnd1 = CreateWindow("MSU:OVERLAPPED1",
            "WINAUX",
            WS_OVERLAPPEDWINDOW,
            GetProfileInt("winaux","X",CW_USEDEFAULT),
            GetProfileInt("winaux","Y",CW_USEDEFAULT),
            GetProfileInt("winaux","CX",CW_USEDEFAULT),
            GetProfileInt("winaux","CY",CW_USEDEFAULT),
            NULL,
            NULL,
            hInstance,
            NULL);

    hMenu = GetSystemMenu(hWnd1,FALSE);
    AppendMenu(hMenu,MF_SEPARATOR,0,NULL);
    AppendMenu(hMenu,MF_STRING,IDSM_ABOUT,"&About...");

    ShowWindow(hWnd1,nCmdShow);
    return TRUE;
}

//*------------------------------------------------------------------------
//| DoMain:
//|     This is the main loop for the application:
//*------------------------------------------------------------------------
int  DoMain(HANDLE hInstance)
{
MSG msg;

    while (GetMessage(&msg,NULL,0,0))
    {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }
    return (msg.wParam);
}

//*------------------------------------------------------------------------
//| AboutProc:
//|
//*------------------------------------------------------------------------
BOOL FAR PASCAL AboutProc (HWND     hWnd,
                           unsigned uMsgID,
                           WORD     wParam,
                           LONG     lParam)
{
    switch (uMsgID)
    {
    case WM_INITDIALOG:
        return TRUE;

    case WM_COMMAND:
        EndDialog(hWnd,TRUE);
        return TRUE;
    }
    return FALSE;
}

//*------------------------------------------------------------------------
//| OverlappedWindowProc1
//|     WM_CREATE: Allocate space for a buffer that will contain the data
//|                received from the WINOX.SYS driver, and start a timer
//|                to go off every 100ms.
//|
//|     WM_TIMER:  Get the status info from the driver, and if anything
//|                has changed, then redraw the client area.
//|
//|     WM_PAINT:  Redraw the entire client area.
//|
//|     WM_SIZE:   Capture the current width and height of the client area.
//|
//*------------------------------------------------------------------------
long FAR PASCAL OverlappedWindowProc1 (HWND     hWnd,
                                       unsigned uMsgID,
                                       WORD     wParam,
                                       LONG     lParam)
{
PAINTSTRUCT ps;
TEXTMETRIC  tm;
LPSTR       lpTemp;
int         row;
LPAUXSTRUCT lpMem;
HANDLE      hFont;
char        szTemp[10];
RECT        rect;
int         nLineHeight;
FARPROC     lpfnAboutProc;

static  HANDLE hMem;
static  WORD wOldPtr = 0;
static  int nClientHeight;
static  int nClientWidth;

    switch (uMsgID)
    {
    case WM_SYSCOMMAND:
        switch (wParam)
        {
        case IDSM_ABOUT:
            lpfnAboutProc = MakeProcInstance(AboutProc,hInst);
            DialogBox(hInst,"ABOUT",hWnd,lpfnAboutProc);
            FreeProcInstance(lpfnAboutProc);
            break;

        default:
            return(DefWindowProc(hWnd, uMsgID, wParam, lParam));
        }
        break;

    case WM_CREATE:
        hMem = GlobalAlloc(GMEM_ZEROINIT|GMEM_MOVEABLE,(LONG) sizeof(AUXSTRUCT));
        lpMem = (LPAUXSTRUCT)GlobalLock(hMem);
        if (lpMem != NULL)
        {
            StartWinAux();
            SetTimer(hWnd,1,100,NULL);
            GlobalUnlock(hMem);
        }
        break;

    case WM_TIMER:
        lpMem = (LPAUXSTRUCT)GlobalLock(hMem);
        if (lpMem != NULL)
        {
            GetWinAuxInfo(lpMem,4);
            if (wOldPtr != lpMem->wScrPtr)
            {
                wOldPtr = lpMem->wScrPtr;
                if (!IsIconic(hWnd))
                    InvalidateRect(hWnd,NULL,FALSE);
            }
            GlobalUnlock(hMem);
        }
        break;

    case WM_SIZE:
        nClientHeight = HIWORD(lParam);
        nClientWidth  = LOWORD(lParam);
        break;

    case WM_DESTROY:
        if (hMem)
        {
            EndWinAux();
            GlobalFree(hMem);
        }
        if (!IsIconic(hWnd))
        {
            GetWindowRect(hWnd,&rect);

            wsprintf(szTemp,"%d",rect.left);
            WriteProfileString("winaux","X",szTemp);

            wsprintf(szTemp,"%d",rect.top);
            WriteProfileString("winaux","Y",szTemp);

            wsprintf(szTemp,"%d",rect.right-rect.left);
            WriteProfileString("winaux","CX",szTemp);

            wsprintf(szTemp,"%d",rect.bottom - rect.top);
            WriteProfileString("winaux","CY",szTemp);
        }
        PostQuitMessage(0);
        break;

    case WM_PAINT:
        BeginPaint(hWnd,&ps);
        lpMem = (LPAUXSTRUCT)GlobalLock(hMem);
        if (lpMem != NULL)
        {
            GetWinAuxInfo(lpMem,sizeof(AUXSTRUCT));

            hFont = GetStockObject(SYSTEM_FIXED_FONT);
            SelectObject(ps.hdc,hFont);
            GetTextMetrics(ps.hdc,&tm);
            nLineHeight = tm.tmHeight + tm.tmExternalLeading;

            SetTextColor(ps.hdc,RGB(0x00,0xff,0x00));
            SetBkColor(ps.hdc,RGB(0,0,0));

            for (lpTemp = (LPSTR) lpMem+24*80+4,row=1;row < 26;row++)
            {
                TextOut(ps.hdc,5,nClientHeight-row*nLineHeight,lpTemp,80);
                lpTemp -= 80;
            }
            GlobalUnlock(hMem);
        }
        EndPaint(hWnd,&ps);
        break;

    default:
        return(DefWindowProc(hWnd, uMsgID, wParam, lParam));
    }
    return(0);
}
