/*
    utils.c

    support routines
*/

#include    "defs.h"
#undef      NULL
#include    "stdio.h"

void    error(string)
char    *string;
{
    printf("ERROR : %s\n",string);
}

#define max(a,b)    ((a) > (b) ? (a) : (b))
#define min(a,b)    ((a) < (b) ? (a) : (b))

/*
    point operations
*/

BOOLEAN pt_in_rect(r, pt)
rect_t  *r;
point_t *pt;
{
    if( (pt->x <= r->right) &&
        (pt->x >= r->left)  &&
        (pt->y <= r->top)   &&
        (pt->y >= r->bottom))
        return(TRUE);
    else
        return(FALSE);
}

BOOLEAN loc_in_rect(r, x, y)
rect_t  *r;
int     x, y;
{
    if( (x <= r->right) &&
        (x >= r->left)  &&
        (y <= r->top)   &&
        (y >= r->bottom))
        return(TRUE);
    else
        return(FALSE);
}

/*
    rectangle operations
*/

BOOLEAN equal_rect(a, b)
rect_t  *a, *b;
{
    if(a == b)
        return(TRUE);

   else if( (a->left == b->left) &&
             (a->right == b->right) &&
             (a->top == b->top) &&
             (a->bottom == b->bottom))
        return(TRUE);

    else
        return(FALSE);
}

BOOLEAN sect_rect(a, b, c)
rect_t    *a, *b, *c;
{
    if(a->top < b->bottom ||
        a->right < b->left ||
        a->bottom > b->top ||
        a->left > b->right)
        return(FALSE);
    else
        {
        c->left = max(a->left, b->left);
        c->bottom = max(a->bottom, b->bottom);
        c->right = min(a->right, b->right);
        c->top = min(a->top, b->top);
        return(TRUE);
        }
}

void    union_rect(a, b, c)
rect_t    *a, *b, *c;
{
    c->left = min(a->left, b->left);
    c->bottom = min(a->bottom, b->bottom);
    c->right = max(a->right, b->right);
    c->top = max(a->top,b->top);
}

rect_t  *offset_rect(r, dh, dv)
rect_t  *r;
int     dh, dv;
{
    r->left   += dh;
    r->bottom += dv;
    r->right  += dh;
    r->top    += dv;
    return(r);
}

rect_t  *inset_rect(r, dh, dv)
rect_t  *r;
int     dh, dv;
{
    r->left   += dh;
    r->bottom += dv;
    r->right  -= dh;
    r->top    -= dv;
    return(r);
}

rect_t    *set_rect(r, left, bottom, right, top)
rect_t  *r;
int     left, bottom, right, top;
{
    r->left   = left;
    r->bottom = bottom;
    r->right  = right;
    r->top    = top;
    return(r);
}


rect_t    *copy_rect(or)
rect_t  *or;
{
rect_t  *nr, *inst_rect();

    nr = inst_rect(or->left,or->bottom,or->right,or->top);
    return(nr);
}

/*
    get bounding box: scans segment's data,
    sets local bboxes (in primitives)
    and global bboxes (in references)
*/

rect_t   *get_bbox(key)
key_t    *key;
{
void    set_bbox();
rect_t  *bbox, *kbb, *mf_bbox();
rect_t  *new_bbox(), *text_bbox(), *get_bbox();
seg_t   *rd_seg();
cpoint_t *cpt;
text_t  *tx;
ref_t   *rf;
poly_t  *py;
line_t  *ln;

    if(key == NULL)
        return(NULL);

    bbox = new_bbox();

    while(key != NULL)
        {
        switch(key->type)
            {
            case    POINT    :
                set_bbox(bbox,key->key.point->x,
                    key->key.point->y);
                break;

            case    LINE    :
                ln = key->key.line;
                set_bbox(bbox,ln->bbox->left,ln->bbox->bottom);
                set_bbox(bbox,ln->bbox->right,ln->bbox->top);
                break;

            case    OVAL    :
            case    RECT    :
                set_bbox(bbox,key->key.rect->left,
                    key->key.rect->bottom);

                set_bbox(bbox,key->key.rect->right,
                    key->key.rect->top);
                break;

            case    POLY    :
                py = key->key.poly;
                set_bbox(bbox, py->bbox->left,py->bbox->bottom);
                set_bbox(bbox, py->bbox->right,py->bbox->top);
                break;

            case    TEXT    :
                tx = key->key.text;
                kbb = tx->bbox;
                if(kbb == NULL)
                    tx->bbox = text_bbox(tx->text, tx->just[0], tx->just[1]);

                kbb = tx->bbox;
                if(kbb != NULL)
                    {
                    set_bbox(bbox, kbb->left + tx->origin.x,
                        kbb->bottom + tx->origin.y);
                    set_bbox(bbox, kbb->right + tx->origin.x,
                        kbb->top + tx->origin.y);
                    }
                break;

            case    REF    :
                rf = key->key.ref;

                if(rf->instance == NULL)
                    rf->instance = rd_seg(rf->name);

                if(rf->instance != NULL)
                    {
                    kbb = rf->instance->bbox;
                    set_bbox(bbox, kbb->left + rf->origin.x,
                        kbb->bottom + rf->origin.y);
                    set_bbox(bbox, kbb->right + rf->origin.x,
                        kbb->top + rf->origin.y);
                    }
                break;
            }

        key = key->next;
        }

    /* 1-bit border */
    inset_rect(bbox,-1,-1);
    return(bbox);
}

rect_t  *new_bbox()
{
rect_t  *bbox, *inst_rect();

    /* set initial bbox to unknown */
    bbox = inst_rect(BIG,BIG,NBIG,NBIG);
    return(bbox);
}

void    set_bbox(bbox,x,y)
rect_t  *bbox;
int     x, y;
{
    bbox->left =    min(bbox->left,x);
    bbox->bottom =  min(bbox->bottom,y);

    bbox->right =   max(bbox->right,x);
    bbox->top =     max(bbox->top,y);
}
