/*
    map.c

    window-to-viewport mapping
*/

#include "defs.h"

typedef	int	coord;

extern  rect_t  screen;

static  double  sx, sy;
static  int     wx, wy, vx, vy, map_status;

void    set_map(window, bitmap)
rect_t  *window, *bitmap;
{
double  n, d;

    if(equal_rect(window, bitmap))
        {
        /* mapping not needed */
        map_status = 0;
        return;
        }

    map_status = 1;

    wx = window->left;
    wy = window->bottom;

    vx = bitmap->left;
    vy = bitmap->bottom;

    n = (double) (bitmap->right - bitmap->left);
    d = (double) (window->right - window->left);
    sx = n / d;

    n = (double) (bitmap->top - bitmap->bottom);
    d = (double) (window->top - window->bottom);
    sy = n / d;
}

void    map(x, y)
int *x, *y;
{
    if(map_status)
        {
        *x = vx + (int) (sx * (*x - wx));
        *y = vy + (int) (sy * (*y - wy));
        }
/*
    Many computer graphics systems have the bit map origin
    at the upper left of the display. This world coordinate
    system "assumes" that the origin is at the lower left.
    If your display coordinate origin is at the upper left,
    add the following line.
*/
    *y = screen.top - *y;
}


/*
    The default mapping algorithm "assumes" that the
    entire window will be mapped into the bit-map viewport.
    Because the aspect ratios of the viewport and window
    may be different, this operation causes distortion.
    To prevent distortion, adjust the window so that

        1. The window's aspect ratio matches the viewport.
        2. None of the original window data is lost.

    This adjustment is made by calling the following
    mapping function:
*/

void    re_map( window, bitmap )
rect_t  *window, *bitmap;
{
double  bx, by, wx, wy, bar, war;
coord   ave, new;

    /* calculate the aspect ratio for the bit-map viewport */
    bx = (double) ( bitmap->right - bitmap->left );
    by = (double) ( bitmap->top - bitmap->bottom );
    bar = bx / by;

    /* calculate the aspect ratio for the clip window */
    wy = (double) ( window->top - window->bottom );
    wx = (double) ( window->right - window->left );
    war = wx / wy;

    if( bar > war )
        {
        /* calculate new window half-width */
        new = (coord) ((wy * bx ) / ( by * 2.0 ));

        /* calculate average horizontal point */
        ave = ( window->left + window->right ) / 2;

        /* reset new horizontal width */
        window->left = ave - new;
        window->right = ave + new;
        }
    else
        {
        /* calculate new window half-height */
        new = (coord) ((wx * by ) / ( bx * 2.0 ));

        /* calculate average vertical point */
        ave = ( window->top + window->bottom ) / 2;

        /* reset new vertical height */
        window->top = ave + new;
        window->bottom = ave - new;
        }
}
