//*                             Record.Cpp
//*
//*    Record Class to provide Functions that handle an Ascii Non-delimited
//*    file, field access, movement throughout the record, and inquiry
//*    information.
//*
//**************************************************************************

#include <stdlib.h>
#include <stdio.h>
#include "record.h"

//*************************************************************************
Record::Record(void)
{
	init();
}

//*************************************************************************

Record::Record(char *fldFile)
{
	init();
	char str[81];
	FILE *fp = fopen(fldFile,"rt");
        while(fgets(str,81,fp))
        {
		char *c = strchr(str,':');
		if (!c)
			continue;
		*c=0;
		addField(str,atoi(c+1));
	}
	fclose(fp);
}

//*************************************************************************

void Record::init(void)
{
	fldCount			= 0;
        fldArraySize                    = 0;
	recLen				= 0;
	Buffer				= NULL;
	fields				= NULL;
}

//*************************************************************************

Record::~Record(void)
{
        if (fields)
        {
                for (int i=0; i<fldCount; i++)
                {
			delete fields[i];
                }

            delete[] fields;
        }

	if (Buffer)
  	delete Buffer;
}


//*************************************************************************
int Record::addField(char *name, int width)
{
   if (fldCount==fldArraySize)
   {
        FieldDef  **tempfields = new FieldDef* [fldArraySize += 10];
        if (fields)
        {
              for (int i=0; i<fldCount; i++)
                    tempfields[i] = fields[i];
              delete fields;
        }
          fields=tempfields;
   }

    fields[fldCount++]= new FieldDef(name,width,recLen);
    recLen += width;

     if (Buffer)
            delete Buffer;
     Buffer = new char[recLen+2];

  return TRUE;
}

//*************************************************************************

int Record::Length(void)
{
	return recLen;
}

//*************************************************************************

int Record::getFieldNum(char *name)
{
	for (int i=0; i<fldCount; i++)
		if (!strcmp(name,fields[i]->Name))
			return(i);

	return -1;
}

//*************************************************************************

const char* Record::getFieldName(int fldNum)
{
	if (fldNum<0 || fldNum>=fldCount)
		return FALSE;

	return fields[fldNum]->Name;
}

//*************************************************************************

int Record::getField(int fldNum, char *field)
{
	if (fldNum<0 || fldNum>=fldCount)
		return FALSE;

	memcpy(field,Buffer+fields[fldNum]->Offset,fields[fldNum]->Width);
	field[fields[fldNum]->Width]=0;
  return TRUE;
}

//*************************************************************************

int Record::getField(char *name, char *field)
{
	int i = getFieldNum(name);
	if (i>=0)
		return(getField(i,field));

	return FALSE;
}

//*************************************************************************

int Record::getField(int fldNum, int &field)
{
	if (fldNum<0 || fldNum>=fldCount)
		return FALSE;

	char *fstr = new char[fields[fldNum]->Width+1];
	getField(fldNum,fstr);
	field=atoi(fstr);
	delete fstr;

  return TRUE;
}


//*************************************************************************

int Record::getField(char *name, int &field)
{
	int i = getFieldNum(name);
	if (i<0)
		return FALSE;

	return(getField(i,field));
}


//*************************************************************************

int Record::getField(int fldNum, long &field)
{
	if (fldNum<0 || fldNum>=fldCount)
		return FALSE;

	char *fstr = new char[fields[fldNum]->Width+1];
	getField(fldNum,fstr);
	field=atol(fstr);
	delete fstr;

  return TRUE;
}

//*************************************************************************

int Record::getField(char *name, long &field)
{
	int i = getFieldNum(name);
	if (i<0)
		return FALSE;

	return(getField(i,field));
}

//*************************************************************************

int Record::getField(int fldNum, float &field)
{
	if (fldNum<0 || fldNum>=fldCount)
		return FALSE;

	char *fstr = new char[fields[fldNum]->Width+1];
	getField(fldNum,fstr);
	field=(float)atof(fstr);
	delete fstr;

  return TRUE;
}

//*************************************************************************
int Record::getField(char *name, float &field)
{
	int i = getFieldNum(name);
	if (i<0)
		return FALSE;

	return(getField(i,field));
}

//*************************************************************************

int Record::getField(int fldNum, double &field)
{
	if (fldNum<0 || fldNum>=fldCount)
		return FALSE;

	char *fstr = new char[fields[fldNum]->Width+1];
	getField(fldNum,fstr);
        field=(double)atof(fstr);
	delete fstr;

  return TRUE;
}

//*************************************************************************
int Record::getField(char *name, double &field)
{
	int i = getFieldNum(name);
	if (i<0)
		return FALSE;

	return(getField(i,field));
}

//*************************************************************************

int Record::getFieldWidth(int fldNum)
{
	if (fldNum<0 || fldNum>=fldCount)
		return 0;

	return fields[fldNum]->Width;
}

//*************************************************************************

int Record::getFieldWidth(char *name)
{
	int i = getFieldNum(name);
	if (i>=0)
		return(getFieldWidth(i));

	return 0;
}
