#ifndef fallthrough		/* "fallthrough" is in opus.h */
typedef unsigned    char    byte;
typedef unsigned    int     word;
#endif


/****** General purpose Symbolic constants:  *********/
#define TRUE	1		/* general purpose true truth value */
#define FALSE	0		/* general purpose false truth value */
#define ERROR	-1		/* General "on error" return value */
#define OK	0		/* General "no error" return value */
#define EOS	'\0'		/* standard end of string */

#define MAX_PATH    78		/* max. length of full pathname		*/
#define MAX_DIR     66		/* max. length of full directory name	*/


/*----------------------------------------------------------------------*/
/*		 Information for file date conversion			*/
/*----------------------------------------------------------------------*/
#define MONTH_SHIFT     5
#define MONTH_MASK      0x0F
#define DAY_MASK	0x1F
#define YEAR_SHIFT      9
#define DOS_EPOCH       80
#define HOUR_SHIFT      11
#define HOUR_MASK       0x1F
#define MINUTE_SHIFT    5
#define MINUTE_MASK     0x3F


/*----------------------------------------------------------------------*/
/*			  archive list junk				*/
/*----------------------------------------------------------------------*/
#define ARCMARK 26	/* special archive marker */
#define ARCVER 10	/* highest compression code used */

#pragma pack(1)		/* req'd by MSC to keep struct byte aligned */ 
struct heads		/* archive entry header format */
{   
    char mbrname[13];	/* file name */
    long mbrsize;	/* size of file in archive, bytes */
    unsigned mbrdate;	/* creation date */
    unsigned mbrtime;	/* creation time */
    int mbrcrc;		/* cyclic redundancy check */
    long mbrlen;	/* true file size, bytes */
};
#pragma pack()		/* we now return to our regular programming */


/*--------------------------------------------------------------------------*/
/* Garbage for ZOO listing                                                  */
/*--------------------------------------------------------------------------*/

#define MAJOR_VER 1        /* needed to manipulate archive */
#define MINOR_VER 4

#define MAJOR_EXT_VER 1    /* needed to extract file */
#define MINOR_EXT_VER 0

#define CTRL_Z 26
#define ZOO_TAG ((unsigned long) 0xFDC4A7DC) /* A random choice */
#define TEXT "ZOO 1.50 Archive.\032"   /* Header text for archive. */
#define SIZ_TEXT  20                   /* Size of header text */

#define PATHSIZE 256                   /* Max length of pathname */
#define FNAMESIZE 13                   /* Size of DOS filename */
#define LFNAMESIZE 256                 /* Size of long filename */
#define ROOTSIZE 8                     /* Size of fname without extension */
#define EXTLEN 3                       /* Size of extension */
#define FILE_LEADER  "@)#("            /* Allowing location of file data */
#define SIZ_FLDR  5                    /* 4 chars plus null */
#define MAX_PACK 1                     /* max packing method we can handle */
#define BACKUP_EXT ".bak"              /* extension of backup file */

#ifdef OOZ
#define FIRST_ARG 2
#endif

#ifdef ZOO
#define FIRST_ARG 3        /* argument position of filename list */
#endif

/* WARNING:  Static initialization in zooadd.c or zooext.c depends on the 
   order of fields in struct zoo_header */
struct zoo_header {
   char text[SIZ_TEXT];       /* archive header text */
   unsigned long zoo_tag;     /* identifies archives           */
   long zoo_start;            /* where the archive's data starts        */
   long zoo_minus;      /* for consistency checking of zoo_start  */
   char major_ver;
   char minor_ver;            /* minimum version to extract all files   */
};

/* Note:  Microsoft C aligns data at word boundaries.  So, to keep things
   compact, always try to pair up character fields. */
struct direntry {
   unsigned long zoo_tag;     /* tag -- redundancy check */
   char type;                 /* type of directory entry.  always 1 for now */
   char packing_method;       /* 0 = no packing, 1 = normal LZW */
   long next;                 /* pos'n of next directory entry */
   long offset;               /* position of this file */
   unsigned int date;         /* DOS format date */
   unsigned int time;         /* DOS format time */
   unsigned int file_crc;     /* CRC of this file */
   long org_size;
   long size_now;
   char major_ver;
   char minor_ver;            /* minimum version needed to extract */
   char deleted;              /* will be 1 if deleted, 0 if not */
   char struc;                /* file structure if any */
   long comment;              /* points to comment;  zero if none */
   unsigned int cmt_size; /* length of comment, 0 if none */
   char fname[FNAMESIZE]; /* filename */

   int var_dir_len;           /* length of variable part of dir entry */
   char tz;                   /* timezone where file was archived */
   unsigned int dir_crc;      /* CRC of directory entry */

   /* fields for variable part of directory entry follow */
   char namlen;               /* length of long filename */
   char dirlen;               /* length of directory name */
   char lfname[LFNAMESIZE];   /* long filename */
   char dirname[PATHSIZE];    /* directory name */
   int system_id;             /* Filesystem ID */
};

/* Values for direntry.system_id */
#define SYSID_NIX       0     /* UNIX and similar filesystems */
#define SYSID_MS        1     /* MS-DOS filesystem */
#define SYSID_PORTABLE  2     /* Portable syntax */

/*-End of Zoo stuff---------------------------------------------------------*/
/*-Start of DWC stuff-------------------------------------------------------*/
#pragma pack(1)		/* req'd by MSC to keep struct byte aligned	*/ 

/* ENTRY - information that is stored for each file in the DWC archive.      */

struct dwc_entry {
   char     name[13];      /* ... File name, Note: path is not saved here    */
   long     size;          /* ... Size of file before compression in bytes   */
   long     time;          /* ... Time stamp on file before added to archive */
   long     new_size;      /* ... Size of compressed file                    */
   long     pos;           /* ... Position of file in archive file           */
   char     method;        /* ... Method of compression used on file         */
   char     sz_c;          /* ... Size of comment added to file              */
   char     sz_d;          /* ... Size of directory name recorded on add     */
   unsigned crc;           /* ... CRC value computed for this file           */
};

/* ARCHIVE - information that is stored at the end of every achive.          */

struct dwc_arc {
   unsigned size;          /* ... Size of archive structure, future expansion*/
   char     ent_sz;        /* ... Size of directory entry, future expansion  */
   char     header[13];    /* ... Name of Header file to print on listings   */
   long     time;          /* ... Time stamp of last modification to archive */
   long     entries;       /* ... Number of entries in archive               */
   char     id[3];         /* ... the string "DWC" to identify archive       */
};
#pragma pack()
/*-End of DWC stuff---------------------------------------------------------*/

