/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

/***
 *  Function    :  noDebug1 ... noDebug18
 *
 *  Description :  Destroy interrupt vectors used by MS-DOS debuggers
 *                 Replace them with another vector
 *                 ('divide by zero' or 'exit').
 *                 Several codings of the same functionalities
 *                 to ennoy hackers.
 *                 These macros have to be called several times
 *                 anywhere in you code (outside loops).
 *
 *  Parameters  :  none
 *
 *  Side-effects:  Warning, once used, it is impossible to debug the program.
 *
 *  Return      :  none
 *
 *  OS/Compiler :  MS-DOS
 ***/

#ifndef _NODEBUG1

#include <dos.h>   /* for MK_FP */

     /*    _NODEBUG*():  internal templates macros for all addresses    */

/* 4 bytes at a time */
#define _NODEBUG1( addr ) \
        ( *( (long far *) 0x04 ) = *( (long far *) 0x0C ) = \
           *( (long far *) addr ) \
        )

/* idem but other order */
#define _NODEBUG2( addr ) \
        ( *( (long far *) 0x0C ) = *( (long far *) 0x04 ) = \
           *( (long far *) addr ) \
        )

/* idem but 2 bytes at a time */
#define _NODEBUG3( addr ) \
        ( *( (short far *) 0x04 ) = *( (short far *) 0x0C ) = \
           *( (short far *) addr ) , \
          *( (short far *) 0x06 ) = *( (short far *) 0x0E ) = \
           *( (short far *) addr + 2 ) \
        )

/* idem but other order */
#define _NODEBUG4( addr ) \
        ( *( (short far *) 0x0C ) = *( (short far *) 0x04 ) = \
           *( (short far *) addr ) , \
          *( (short far *) 0x0E ) = *( (short far *) 0x06 ) = \
           *( (short far *) addr + 2 ) \
        )

/* idem but other order */
#define _NODEBUG5( addr ) \
        ( *( (short far *) 0x04 ) = *( (short far *) addr ),  \
          *( (short far *) 0x06 ) = *( (short far *) addr+2), \
          *( (short far *) 0x0C ) = *( (short far *) addr),   \
          *( (short far *) 0x0E ) = *( (short far *) addr+2)  \
        )

/* idem but other order */
#define _NODEBUG6( addr ) \
        ( *( (short far *) 0x0E ) = *( (short far *) addr+2), \
          *( (short far *) 0x0C ) = *( (short far *) addr),   \
          *( (short far *) 0x06 ) = *( (short far *) addr+2), \
          *( (short far *) 0x04 ) = *( (short far *) addr )   \
        )

/* idem but 1 byte at a time */
#define _NODEBUG7( addr ) \
        ( *( (char far *) 0x04 ) = *( (char far *) 0x0C ) = *( (char far *) addr ),  \
          *( (char far *) 0x05 ) = *( (char far *) 0x0D ) = *( (char far *) addr+1), \
          *( (char far *) 0x06 ) = *( (char far *) 0x0E ) = *( (char far *) addr+2), \
          *( (char far *) 0x07 ) = *( (char far *) 0x0F ) = *( (char far *) addr+3)  \
        )

/* idem but other order */
#define _NODEBUG8( addr ) \
        ( *( (char far *) 0x04 ) = *( (char far *) addr ),  \
          *( (char far *) 0x05 ) = *( (char far *) addr+1), \
          *( (char far *) 0x06 ) = *( (char far *) addr+2), \
          *( (char far *) 0x07 ) = *( (char far *) addr+3), \
          *( (char far *) 0x0C ) = *( (char far *) addr),   \
          *( (char far *) 0x0D ) = *( (char far *) addr+1), \
          *( (char far *) 0x0E ) = *( (char far *) addr+2)  \
          *( (char far *) 0x0F ) = *( (char far *) addr+3)  \
        )

/* idem but other order */
#define _NODEBUG9( addr ) \
        ( *( (char far *) 0x0C ) = *( (char far *) addr),   \
          *( (char far *) 0x07 ) = *( (char far *) addr+3), \
          *( (char far *) 0x0D ) = *( (char far *) addr+1), \
          *( (char far *) 0x06 ) = *( (char far *) addr+2), \
          *( (char far *) 0x0E ) = *( (char far *) addr+2), \
          *( (char far *) 0x05 ) = *( (char far *) addr+1), \
          *( (char far *) 0x0F ) = *( (char far *) addr+3), \
          *( (char far *) 0x04 ) = *( (char far *) addr )   \
        )
                           

/*  replace by 'divide by zero' vector  =>  stop the program  */
#define noDebug1()   _NODEBUG1( 0x00 )
#define noDebug2()   _NODEBUG2( 0x00 )
#define noDebug3()   _NODEBUG3( 0x00 )
#define noDebug4()   _NODEBUG4( 0x00 )
#define noDebug5()   _NODEBUG5( 0x00 )
#define noDebug6()   _NODEBUG6( 0x00 )
#define noDebug7()   _NODEBUG7( 0x00 )
#define noDebug8()   _NODEBUG8( 0x00 )
#define noDebug9()   _NODEBUG9( 0x00 )

/*  replace by 'Exit' vector  =>  stop the program  */
#define noDebug10()   _NODEBUG1( MK_FP(_psp, 0x0A) )
#define noDebug11()   _NODEBUG2( MK_FP(_psp, 0x0A) )
#define noDebug12()   _NODEBUG3( MK_FP(_psp, 0x0A) )
#define noDebug13()   _NODEBUG4( MK_FP(_psp, 0x0A) )
#define noDebug14()   _NODEBUG5( MK_FP(_psp, 0x0A) )
#define noDebug15()   _NODEBUG6( MK_FP(_psp, 0x0A) )
#define noDebug16()   _NODEBUG7( MK_FP(_psp, 0x0A) )
#define noDebug17()   _NODEBUG8( MK_FP(_psp, 0x0A) )
#define noDebug18()   _NODEBUG9( MK_FP(_psp, 0x0A) )
      

#endif