*-------------------------------------------------------------------------
* attrs.prg -- FORCE FAQ Undocumented function sample code
*-------------------------------------------------------------------------
#include io.hdr
#include math.hdr
#include string.hdr
#include system.hdr

#include defs.hdr
#include common.hdr
#include undoc.hdr
*-------------------------------------------------------------------------
VARDEF PRIVATE
   CHAR                 RCSid = "$Header: C:\TECH\FAQ\INCLUDE\SAMPLE\RCS\attrs.prg 1.1 1992/05/23 03:15:56 holmesda Exp holmesda $"

   CHAR(10)             Attribs[6] = "ReadOnly", ;
                                     "Hidden", ;
                                     "System", ;
                                     "Volume", ;
                                     "Subdir", ;
                                     "Archive"
ENDDEF
*-------------------------------------------------------------------------
* function: show_attributes()
*
* description: demonstrates the usage of the Interrupt() function by
*     calling INT 21h (DOS) with the function 0x4300, which returns the
*     attributes of the file in the CX register.  Then we do some
*     bit testing to figure out the attributes...
*
* Here's the specs on INT 21h/43
*
* Entry:    AL    = subfunction        ( 0 to read attrs, 1 to write'em )
*           CX    = Desired attributes ( if AL = 1 )
*           DS    = segment of file name path
*           DX    = offset of file name path
*
* Exit:     AX    = Error code
*           CX    = Current attributes
*
* Bit settings for File Attribute
*
*     CX: 76543210
*         00            -- Reserved
*           x           -- Is it archived?
*            0          -- Subdirectory?  Set to 0 for this service
*             0         -- Volume Label?  Set to 0 for this service
*              x        -- System?
*               x       -- Hidden?
*                x      -- Read-Only?
*-------------------------------------------------------------------------
PROCEDURE show_attributes
   PARAMETERS CONST CHAR file_name

   VARDEF
      UINT        ax,bx,cx,dx,si,di,bp,ds,es
      LONG        ptr
      INT         i
   ENDDEF

   *---
   * First, we need the address of the file name, so we use make_ptr
   * to get it.  Luckily for us, make_ptr() wants a segment and an
   * offset alias, so we just give him DS and DX, which is what
   * INT 21h/4300 wants.
   *---

   make_ptr( ds, dx, file_name )

   ax = 0x4300

   if .not. interrupt( 0x21, ax, bx, cx, dx, si, di, bp, ds, es )
      ? "Hm.  An error.  Code is: ", ax
      return
   endif

   ? "Attributes:"

   for i = 0 to 5
      if bittest( cx, i )
         ?? " " + Attribs[ i ]
      endif
   next

   ?
ENDPRO
*-------------------------------------------------------------------------
PROCEDURE force_main
   PARAMETERS CHAR(128) command_line

   VARDEF
      CHAR(65)             file_name
   ENDDEF

   scrn_dos()

   file_name = trim( command_line )
   if len(file_name) = 0
      ? "Whoa! Need a filename!  Use:"
      ?
      ? "    attrs filename "
      quit
   endif

   if .not. exist( file_name )
      ? file_name + " does not exist!"
      quit
   endif

   show_attributes( file_name )

ENDPRO
