;
; File......: WINICON.ASM
; Author....: J. David Reynolds
; CIS ID....: 73730,2047
; Date......: $Date$
; Revision..: $Revision$
; Log file..: $Logfile$
;
; This is an original work by J. David Reynolds and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
; $Log$
;

; $DOC$
; $FUNCNAME$
;    WinIcon()
; $CATEGORY$
;    Miscellaneous
; $ONELINER$
;    Displays a Microsoft Windows icon file in text mode
; $SYNTAX$
;    WinIcon( <cFilename>
;             [, <nScreenRow> ] [, <nScreenCol> ]
;             [, <nBackgroundColor> ] ) -> <lSuccess>
; $ARGUMENTS$
;    <cFilename>        is the icon filename to display; the extension,
;                       if any, must be included
;
;    <nScreenRow>       is the row at which to display the icon; the
;                       default is 0
;
;    <nScreenCol>       is the column at which to display the icon; the
;                       default is 0
;
;    <nBackgroundColor> is the background color to use for the icon; the
;                       default is 0 (black)
;
;                        0 = black         8 = dark grey
;                        1 = blue          9 = light blue
;                        2 = green        10 = light green
;                        3 = cyan         11 = light cyan
;                        4 = red          12 = light red
;                        5 = magenta      13 = light magenta
;                        6 = brown        14 = yellow
;                        7 = light grey   15 = white
; $RETURNS$
;    <lSuccess> is .t. if the icon was successfully displayed
; $DESCRIPTION$
;    This function displays a Microsoft Windows icon file (.ICO) in text
;    mode.  Icons are essentially 16-color bitmaps of 32 by 32 pixels.
;    WinIcon() uses character 220 () with appropriate foreground and
;    background colors to display an icon in text mode.
;
;    You can specify the row and column at which to display the icon, as
;    well as the background color to use.  If the icon contains high-
;    intensity colors (in the range 8 to 15 above), you should disable
;    blink support with setblink( .f. ) before calling WinIcon().
; $EXAMPLES$
;    setblink( .f. )
;    WinIcon( "FROG.ICO", ;
;       ( maxrow() - 16 ) / 2, ;
;       ( maxcol() - 32 ) / 2, ;
;       7 )
;    inkey( 0 )
;    setblink( .t. )
; $END$
;

.MODEL LARGE, C

TRUE        equ -1
FALSE       equ 0

WINICON     PROTO FAR PASCAL
WinIcon     PROTO FAR C, _pFilename:FAR PTR, \
                         _wScreenRow:WORD, _wScreenCol:WORD, \
                         _wBGColor:WORD
bbPlot      PROTO FAR C, _wx:WORD, _wy:WORD, _wColor:WORD
bbPMPtr     PROTO FAR C, _pwSel:FAR PTR, _dwAddr:DWORD, _wSize:WORD
_parc       PROTO FAR C, _wParam:WORD
_parni      PROTO FAR C, _wParam:WORD
_retl       PROTO FAR C, _wRet:WORD
_xalloc     PROTO FAR C, _wSize:WORD
_xfree      PROTO FAR C, _pPtr:FAR PTR
_gtPreExt   PROTO FAR C
_gtPostExt  PROTO FAR C

.DATA

   fColor         BYTE ?
   bColorTable    BYTE 0,  4,  2,  6,  1,  5,  3,  8
                  BYTE 7, 12, 10, 14,  9, 13, 11, 15
   wCols          WORD ?
   wVidPtr        WORD ?
   wVidSize       WORD ?

.CODE

;/****************************************************************************
;** WINICON()
;****************************************************************************/
WINICON PROC FAR PASCAL
   LOCAL _wBGColor:WORD
   LOCAL _wScreenCol:WORD
   LOCAL _wScreenRow:WORD
   LOCAL _pFilename:FAR PTR

   INVOKE _parni, 2
   mov _wScreenRow, ax

   INVOKE _parni, 3
   mov _wScreenCol, ax

   INVOKE _parni, 4
   mov _wBGColor, ax

   INVOKE _parc, 1
   mov WORD PTR _pFilename[2], dx
   mov WORD PTR _pFilename[0], ax

   INVOKE _gtPreExt
   INVOKE WinIcon, _pFilename, _wScreenRow, _wScreenCol, _wBGColor
   push ax
   INVOKE _gtPostExt
   pop ax

   INVOKE _retl, ax

   ret

   WINICON ENDP

;/****************************************************************************
;** WinIcon()
;****************************************************************************/
WinIcon PROC FAR C USES si di, _pFilename:FAR PTR, \
                               _wScreenRow:WORD, _wScreenCol:WORD, \
                               _wBGColor:WORD
   LOCAL _fAlloc:BYTE
   LOCAL _fOpen:BYTE
   LOCAL _fPMode:BYTE
   LOCAL _bBitPos:SBYTE
   LOCAL _wBIOSPtr:WORD
   LOCAL _wColOfs:WORD
   LOCAL _wHandle:WORD
   LOCAL _wRowOfs:WORD
   LOCAL _wx:WORD
   LOCAL _wy:SWORD
   LOCAL _pColorData:FAR PTR
   LOCAL _pPatternData:FAR PTR

   ; init flags
   mov wVidPtr, 0
   mov _wBIOSPtr, 0
   mov _fAlloc, FALSE
   mov _fOpen, FALSE
   mov _fPMode, TRUE

   ; test for protected mode
   mov ax, 1686h                       ; Mode Detection function number
   int 2Fh                             ; Multiplex interrupt
   .IF ( ax )
      mov _fPMode, FALSE
   .ENDIF

   ; get a protected-mode ptr to the BIOS Data Segment
   .IF ( _fPMode )
      xor cx, cx
      mov dx, 00400h
      INVOKE bbPMPtr, ADDR _wBIOSPtr, cx::dx, 768
      .IF ( ! ax )
         jmp Failure
      .ENDIF
      mov ax, _wBIOSPtr
   .ELSE
      mov ax, 40h
   .ENDIF
   mov es, ax

   ; get the screen width
   mov ax, WORD PTR es:[4Ah]
   mov wCols, ax

   ; get the size of the video regen buffer
   mov ax, WORD PTR es:[4Ch]
   mov wVidSize, ax

   ; test for color
   .IF ( WORD PTR es:[63h] == 03D4h )
      mov fColor, TRUE
   .ELSE
      mov fColor, FALSE
   .ENDIF

   ; get a protected-mode ptr to the video regen buffer
   .IF ( _fPMode )
      mov cx, 0000Bh
      .IF ( fColor )
         mov dx, 08000h
      .ELSE
         mov dx, 00000h
      .ENDIF
      INVOKE bbPMPtr, ADDR wVidPtr, cx::dx, wVidSize
      .IF ( ! ax )
         jmp Failure
      .ENDIF
   .ELSE
      .IF ( fColor )
         mov ax, 0B800h
      .ELSE
         mov ax, 0B000h
      .ENDIF
      mov wVidPtr, ax
   .ENDIF

   ; allocate memory for the icon data
   INVOKE _xalloc, 640
   .IF ( ( ! dx ) && ( ! ax ) )
      jmp Failure
   .ENDIF
   mov WORD PTR _pColorData[2], dx
   mov WORD PTR _pColorData[0], ax
   mov WORD PTR _pPatternData[2], dx
   add ax, 512
   mov WORD PTR _pPatternData[0], ax

   ; set allocation flag
   mov _fAlloc, TRUE

   ; open the file
   push ds
   mov ah, 3Dh                         ; Open File Using Handle function number
   xor al, al                          ; 00h=read-only
   lds dx, _pFilename
   int 21h                             ; DOS services
   pop ds
   jc Failure
   mov _wHandle, ax

   ; set file open flag
   mov _fOpen, TRUE

   ; seek to start of image
   mov ah, 42h                         ; Move File Pointer Using Handle function number
   xor al, al                          ; 00h=SEEK_SET
   mov bx, _wHandle
   xor cx, cx                          ; high-order part of offset
   mov dx, 126                         ; low-order part of offset
   int 21h                             ; DOS services
   jc Failure

   ; read the icon data
   push ds
   mov ah, 3Fh                         ; Read From File Using Handle function number
   mov bx, _wHandle
   mov cx, 640                         ; 640 bytes
   lds dx, _pColorData
   int 21h                             ; DOS services
   pop ds
   jc Failure

   ; calc screen row and col offsets
   mov ax, _wScreenRow
   shl ax, 1
   mov _wRowOfs, ax
   mov ax, _wScreenCol
   add ax, 31
   mov _wColOfs, ax

   ; draw the icon
   les di, _pColorData
   les si, _pPatternData
   mov _bBitPos, 7
   mov ax, _wRowOfs
   add ax, 31
   mov _wy, ax
   mov cx, _wRowOfs
   .WHILE ( _wy >= cx )

      mov ax, _wScreenCol
      mov _wx, ax
      mov cx, _wColOfs
      .WHILE ( _wx <= cx )

         ; plot the first pixel in this byte
         mov al, BYTE PTR es:[si]
         mov cl, _bBitPos
         shr al, cl
         and al, 00000001b
         .IF ( al )
            xor ah, ah
            mov al, BYTE PTR _wBGColor
         .ELSE
            xor ah, ah
            mov al, BYTE PTR es:[di]
            shr al, 1
            shr al, 1
            shr al, 1
            shr al, 1
            mov bx, OFFSET bColorTable ; translate the color
            xlat
         .ENDIF
         push es
         INVOKE bbPlot, _wx, _wy, ax
         pop es

         ; plot the second pixel in this byte
         inc _wx
         dec _bBitPos
         mov al, BYTE PTR es:[si]
         mov cl, _bBitPos
         shr al, cl
         and al, 00000001b
         .IF ( al )
            xor ah, ah
            mov al, BYTE PTR _wBGColor
         .ELSE
            xor ah, ah
            mov al, BYTE PTR es:[di]
            and al, 00001111b
            mov bx, OFFSET bColorTable ; translate the color
            xlat
         .ENDIF
         push es
         INVOKE bbPlot, _wx, _wy, ax
         pop es

         ; step to the next 2 pixels in the color data
         inc di

         ; step to the next 8 pixels in the pattern data?
         dec _bBitPos
         .IF ( _bBitPos < 0 )
            inc si
            mov _bBitPos, 7
         .ENDIF

         inc _wx
         mov cx, _wColOfs

      .ENDW

      dec _wy
      mov cx, _wRowOfs

   .ENDW

   Success:
      mov ax, TRUE
      jmp @F

   Failure:
      xor ax, ax

   @@:
      ; close the file
      .IF ( _fOpen )
         push ax
         mov ah, 3Eh                   ; Close File Using Handle function number
         mov bx, _wHandle
         int 21h                       ; DOS services
         pop ax
      .ENDIF

      ; free allocated memory
      .IF ( _fAlloc )
         push ax
         INVOKE _xfree, _pColorData
         pop ax
      .ENDIF

      ; free descriptor
      .IF ( _fPMode && wVidPtr )
         push ax
         mov ax, 1                     ; Free Descriptor function number
         mov bx, wVidPtr
         int 31h                       ; DPMI services
         pop ax
      .ENDIF

      ; free descriptor
      .IF ( _wBIOSPtr )
         push ax
         mov ax, 1                     ; Free Descriptor function number
         mov bx, _wBIOSPtr
         int 31h                       ; DPMI services
         pop ax
      .ENDIF

      ret

   WinIcon ENDP

;/****************************************************************************
;** static bbPlot()
;****************************************************************************/
bbPlot PROC FAR C PRIVATE uses di, _wx:WORD, _wy:WORD, _wColor:WORD
   LOCAL _bCurAttr:BYTE
   LOCAL _bNewAttr:BYTE
   LOCAL _fOdd:BYTE
   LOCAL _wHalfY:WORD

   mov ax, wCols
   dec ax
   .IF ( _wx > ax )
      jmp Failure
   .ENDIF

   ; is the y coord odd?
   mov ax, _wy
   and al, 00000001b
   mov _fOdd, al

   ; calc screen row
   mov ax, _wy
   shr ax, 1
   mov _wHalfY, ax

   ; get the current attribute
   mov bx, wVidPtr
   mov es, bx
   mov bx, wCols
   mul bl
   add ax, _wx
   shl ax, 1
   inc ax
   mov di, ax
   inc ax
   .IF ( ax > wVidSize )
      jmp Failure
   .ENDIF
   mov al, BYTE PTR es:[di]
   mov _bCurAttr, al

   ; calc the new attribute
   .IF ( _fOdd )
      ; nNewAttr := BitOR( BitAND( nColor, 15 ), BitAND( nCurAttr, 240 ) )
      mov al, _bCurAttr
      and al, 11110000b
      mov _bNewAttr, al
      mov ax, _wColor
      and al, 00001111b
      or al, _bNewAttr
   .ELSE
      ; nNewAttr := BitOR( nColor * 16, BitAND( nCurAttr, 15 ) )
      mov al, _bCurAttr
      and al, 00001111b
      mov _bNewAttr, al
      mov ax, _wColor
      shl al, 1
      shl al, 1
      shl al, 1
      shl al, 1
      or al, _bNewAttr
   .ENDIF

   ; write the new attribute
   mov BYTE PTR es:[di], al
   mov BYTE PTR es:[di - 1], ""

   Success:
      mov ax, TRUE
      jmp @F

   Failure:
      xor ax, ax

   @@:
      ret

   bbPlot ENDP

;/****************************************************************************
;** static bbPMPtr()
;****************************************************************************/
bbPMPtr PROC FAR C PRIVATE USES di, _pwSel:FAR PTR, _dwAddr:DWORD, _wSize:WORD
   LOCAL _fAlloc:BYTE
   LOCAL _wSel:WORD

   ; init flag
   mov _fAlloc, FALSE

   ; allocate descriptor
   xor ax, ax                          ; Allocate Descriptor function number
   mov cx, 1                           ; 1 descriptor
   int 31h                             ; DPMI services
   jc Failure

   ; set descriptor allocated flag
   mov _fAlloc, TRUE
   mov _wSel, ax

   ; set segment base address
   mov ax, 7                           ; Set Segment Base Address function number
   mov bx, _wSel
   mov cx, WORD PTR _dwAddr[2]         ; high-order part of physical linear address
   mov dx, WORD PTR _dwAddr[0]         ; low-order part of physical linear address
   int 31h                             ; DPMI services
   jc Failure

   ; set segment limit
   mov ax, 8                           ; Set Segment Limit function number
   mov bx, _wSel
   xor cx, cx                          ; high-order part of segment limit
   mov dx, _wSize                      ; low-order part of segment size
   int 31h                             ; DPMI services
   jc Failure

   Success:
      mov ax, TRUE
      jmp @F

   Failure:
      xor ax, ax

   @@:
      ; return selector through ptr
      .IF ( _fAlloc )
         mov bx, _wSel
      .ELSE
         xor bx, bx
      .ENDIF
       les di, _pwSel
       mov WORD PTR es:[di], bx

      ret

   bbPMPtr ENDP

END

