

PROCEDURE Demo()
LOCAL a1 := GetTree( "C", { |c| Qout( c ) } )
LOCAL a2
 ? "Ready"
 INKEY(0)
 a2 := BuildTree( a1 )
 aEVAL( a2, { |e| Qout( PADR( e[1],30 )+PADR(e[2],49) ) } )
RETURN



*===========================================================================*
* Auther     : Mathieu De Smet
* CIS        : 100140,1375
* Date       : 17 Aug 1994
* Function   : GetTree
* Parameters : cDrive  char       drivename, will read the tree from the drive
*                      nil        will read the tree from current drive
*              bOut    codeblock  output block when rereading tree
*              lFast   logical    read tree fast (only '*.' ) or slow (all '*.*')
* Output     : Nested Array
*       \DOS
*       \WINDOWS
*       \WINDOWS\SYSTEM
*       \WINDOWS\GAMES
*       \WINDOWS\GAMES\1
*       \WINDOWS\GAMES\2
*       \WINDOWS\GAMES\3
*       \UTIL
*   => makes array like this
*       { { "DOS",     {  } }, ;
*         { "WINDOWS", { { "SYSTEM", { } }, ;
*                        { "GAMES" , { { "1", { } }, ;
*                                      { "2", { } }, ;
*                                      { "2", { } }  ;
*                                    } ;
*                        }
*                      }
*         }, ;
*         { "UTIL",    { } } ;
*       }
*  looks difficult but it isn't, use debugger to understand
*------------------------------*
FUNCTION GetTree( cDrive, bOut, lFast )
RETURN _GetTree( IF( VALTYPE(cDrive) == "C", cDrive+":", ""         ), ;
                 IF( VALTYPE(bOut  ) == "B", bOut      , { || nil } ), ;
                 IF( VALTYPE(lFast ) == "L", lFast     , .T.        ) )
*------------------------------*
STATIC FUNCTION _GetTree( cCurr, bOut, lFast )
 LOCAL aDir  := DIRECTORY( cCurr+"\*."+IF( lFast, "", "*" ), "D" )
 LOCAL aTree := {}
 LOCAL n
  EVAL( bOut, cCurr )
  aSORT( aDir,,, { |x,y| x[1] < y[1] } )
  FOR n := 1 TO LEN( aDir )
      IF "D" $ aDir[ n,5 ]
         IF aDir[n,1] == "." .OR. aDir[n,1] == ".."
         ELSE
            aAdd( aTree, { aDir[n,1], _GetTree( cCurr+"\"+aDir[n,1], bOut, lFast ) } )
         ENDIF
      ENDIF
  NEXT
RETURN aTree
*===========================================================================*




*===========================================================================*
* Auther     : Mathieu De Smet
* CIS        : 100140,1375
* Date       : 17 Aug 1994
* Function   : BuildTree
* Purpose    : Make a nice 'tree' from the array fro GetTree
* Parameters : aTree   array      the tree from GetTree
*                      char       drivename, will read the tree from the drive
*                      nil        will read the tree from current drive
*              bOut    codeblock  output block when rereading tree
*              lFast   logical    read tree fast or slow
* Output     : array  { { cText, cPath }, ;
*                       ..., ;
*                       { cText, cPath } }
*---------------------------------*
FUNCTION BuildTree( aTree, bOut, lFast )
 LOCAL aNew := {}
  IF VALTYP( aTree ) != "A"
     aTree := GetTree( aTree, bOut, lFast )
  ENDIF
  _BuildTree( aNew, "", aTree, "" )
RETURN aNew
*--------------------------------*
STATIC PROCEDURE _BuildTree( aNew, cLead, aTree, cDir )
 LOCAL c1,c2
 LOCAL n

  FOR n := 1 TO LEN( aTree )
      IF n == LEN( aTree )
         c1 := " "
         c2 := "   "
      ELSE
         c1 := " "
         c2 := "  "
      ENDIF
      aAdd( aNew, {     cLead+c1 +aTree[n,1], cDir+"\"+aTree[n,1] } )
      _BuildTree( aNew, cLead+c2, aTree[n,2], cDir+"\"+aTree[n,1] )
  NEXT

RETURN
*===========================================================================*
