//-----------------------------------------------------------------------//
//  VISUAL ENGINE FOR CLIPPER - Ver 1.0
//  (c) 1993-4 Peyrona Soft
//  Authors: Manolo Caracuel Urbano
//           Francisco Morero Peyrona
//
//             VISUAL ENGINE FOR CLIPPER TUTOR ( CUSTOMIZING VEC )
//-----------------------------------------------------------------------//

#include "veSystem.ch"
#include "veMsg.ch"
#include "veCtrl.ch"
#include "veWindow.ch"
#include "veColors.ch"

//-----------------------------------------------------------------------//
// All colors and main keys can be customized in VEC, but in this example,
// we will show only how to change fonts and some CUA controls colors.
//-----------------------------------------------------------------------//

function Custom()

   local wndCustom, nFont
   local acFont := aReadDir( "", "*.FNT" )

   CREATE WINDOW wndCustom FROM 1,1 TO 11,43 ;
          TITLE If( lEsp(), "Personalizando", "Customizing" ) + " VEC"


   @  1, 1 COMBO    nFont      ;
           ITEMS    acFont     ;
           PROMPT   "&Fonts  " ;
           INITIAL  1          ;
           SIZE     6,16       ;
           HELPLINE "Select new font to display"

   @  1,24 BUTTON   " &Load Font " ;
           ACTION   App():SetFont( acFont[ nFont ] ) ;
           HELPLINE "Load selected font"


   @  6, 6 BUTTON   "  Open color &window  " ;
           ACTION   ClrWnd()                 ;
           HELPLINE "Open new window with different colors"

   OPEN WINDOW wndCustom

   //----------------------------------------------------------------//

   LessonWnd( wndCustom )               // For internal tutor use only

return nil

//-----------------------------------------------------------------------//

static func ClrWnd()

   static wndTest
   local  lVal, cColor, nRad, cClr

   if wndTest != nil
      wndTest:Kill()
   endif

   CREATE WINDOW wndTest FROM 1,46 TO 15,78 ;
                 TITLE "Color Test Window"  ;
                 NO HELPLINE  NO RESIZE     ;
                 COLOR RndClr( 9 )

   @  7, 3 RADIO    nRad                   ;
           ITEMS    "Opt. &1 ", "Opt. &2 " ;
           PROMPT   " Radio "              ;
           COLOR    RndClr( 7 )

   @  7,17 CHECKBOX lVal       ;
           PROMPT   "C&heck "  ;
           INITIAL  .T.        ;
           COLOR    RndClr( 5 )

   @  9,17 BUTTON   " &Button " ;
           ACTION   nil         ;
           COLOR    RndClr( 5 )

   @  2, 3 GET      cColor      ;
           PROMPT   "&Get "     ;
           INITIAL  Space( 50 ) ;
           PICTURE  "@S19"      ;
           COLOR    RndClr( 9 )

   OPEN WINDOW wndTest

   cClr = wndTest:GetColor( WND_CLR_HIGH_SAY )
   cClr = SubStr( cClr, At( "/", cClr ) + 1 )
   Box3D( 0,1, 4,29, cClr + "+," + cClr + "+,N,N," + cClr + "," + cClr )
   Box3D( 5,1,12,29, "N,N," + cClr + "+," + cClr + "+," + cClr + "," + cClr )

   LessonWnd( wndTest )                 // For internal tutor use only

return nil

//-----------------------------------------------------------------------//

static function RndClr( nItem )

   local i, cColor := ""
   local acColor := { "N", "B", "G", "BG", "R", "RB", "GR", "W" }

   for i = 1 to nItem
       cColor += acColor[ Random( 8 ) + 1 ]
       cColor += If( Random( 4 ) > 2, "+/", "/" )
       cColor += acColor[ Random( 8 ) + 1 ] + ","
   next

return Left( cColor, Len( cColor ) - 1 )

//-----------------------------------------------------------------------//

static func Random( nMax )

  static nRandom
  local nTemp

  if nRandom == nil
     nRandom = Seconds()
  endif

  nTemp   = ( nRandom * Seconds() ) % ( nMax )
  nRandom = nTemp + Seconds()

return Int( nTemp )

//-----------------------------------------------------------------------//

static function aReadDir( cPath, cMask )

   local aDir

   DEFAULT cPath := FullCurDir(), cMask := "*.*"

   aDir = Directory( cPath + cMask )

   aDir = AEval( aDir, { |aItem, i| aDir[ i ] := aDir[ i, 1 ] } )
   AEval( aDir, { |cItem, i| aDir[ i ] := FullNomFic( cItem ) } )

return ASort( aDir )

//-----------------------------------------------------------------------//

static function FullNomFic( cNomFic )

return If( "." $ cNomFic, ;
                 PadR( SubStr( cNomFic, 1, At( ".", cNomFic ) - 1 ), 8 ) +;
                       PadR( SubStr( cNomFic, At( ".", cNomFic ) ), 4 ), ;
                 PadR( cNomFic, 12 ) )

//-----------------------------------------------------------------------//
