//------------------------------------------------------------------------//
//  VISUAL ENGINE FOR CLIPPER - Ver 1.0
//  (c) 1993-4 Peyrona Soft
//  Authors: Manolo Caracuel Urbano
//           Francisco Morero Peyrona
//
//             VISUAL ENGINE FOR CLIPPER TUTOR ( SERVER MESSAGES )
//------------------------------------------------------------------------//

#include "veSystem.ch"
#include "veMsg.ch"
#include "veCtrl.ch"
#include "veMouse.ch"
#include "veWindow.ch"
#include "veColors.ch"

//-----------------------------------------------------------------------//

static nIDMsg
static wndMsg
static aMsgType, aMsgMsg

//-----------------------------------------------------------------------//

function ServerMsg()

   CREATE WINDOW wndMsg  FROM  0,10 TO 10,68 ;
          TITLE "Messages Viewer"            ;
          NO HELPLINE                        ;
          ON CLOSE ( App():oServer:DelBackProc( nIDMsg ), .F. )
          // At close window, we deinstall background procedure

   OPEN WINDOW wndMsg

   nIDMsg = App():oServer:AddBackProc( { |aMsg| ShowMsg( aMsg ) } )

   @ 0,1 veSAY "TYPE     WINDOW    MESSAGE           INFO";
         COLOR wndMsg:COLOR_LOW
   @ 1,1 veSAY Replicate( "", MaxCol() - 1 ) COLOR wndMsg:COLOR_LOW

   InitMsg()

   LessonWnd( wndMsg )                  // For internal tutor use only

return nil

//-----------------------------------------------------------------------//

static function ShowMsg( aMsg )

   local nWnd := VWSetOut( wndMsg:nHandle )
   local nPtr
   local cColor := SetColor( "W+/B" )

   if aMsg != MSG_NO_EVENT
      Scroll( 2, 0, MaxRow(), MaxCol(), 1 )

      if ( nPtr := AScan( aMsgType, { |x| x[1] == aMsg[EVT_TYPE] } ) ) > 0
         @ MaxRow(), 1 veSAY aMsgType[ nPtr, 2 ] COLOR wndMsg:COLOR_HIGH
      endif

      @ MaxRow(),10 veSAY PadL( aMsg[ EVT_WND ]:nHandle, 6 ) ;
                    COLOR wndMsg:COLOR_HIGH

      if ( nPtr := AScan( aMsgMsg, { |x| x[1] == aMsg[EVT_MSG] } ) ) > 0
         @ MaxRow(), 20 veSAY aMsgMsg[ nPtr, 2 ] COLOR wndMsg:COLOR_HIGH
      endif

      if aMsg[ EVT_TYPE ] == EVT_TYPE_MOUSE
         @ MaxRow(), 38 veSAY "{ " + ;
                        PadL( aMsg[ EVT_INFO, MS_BTN      ], 2 ) + "," + ;
                        PadL( aMsg[ EVT_INFO, MS_ROW      ], 3 ) + "," + ;
                        PadL( aMsg[ EVT_INFO, MS_COL      ], 3 ) + "," + ;
                        PadL( aMsg[ EVT_INFO, MS_BTN_STAT ], 2 ) + " }"  ;
           COLOR wndMsg:COLOR_HIGH

      elseif aMsg[ EVT_TYPE ] == EVT_TYPE_KEY
         @ MaxRow(), 38 veSAY PadL( aMsg[ EVT_INFO ], 4 ) ;
                        COLOR wndMsg:COLOR_HIGH
      endif
   endif

   VWSetOut( nWnd )
   SetColor( cColor )

return nil

//-----------------------------------------------------------------------//

static func InitMsg()

   aMsgType = { ;
                { EVT_TYPE_SERVER, "SERVER" }, ;
                { EVT_TYPE_WND,    "WND   " }, ;
                { EVT_TYPE_KEY,    "KEY   " }, ;
                { EVT_TYPE_MOUSE,  "MOUSE " }  ;
              }

    aMsgMsg = { ;
                { MSG_MS_PRESSED         , "MS_PRESSED         " },;
                { MSG_MS_RELEASED        , "MS_RELEASED        " },;
                { MSG_MS_DOUBLE          , "MS_DOUBLE          " },;
                { MSG_MS_HELD            , "MS_HELD            " },;
                { MSG_MS_DRAG            , "MS_DRAG            " },;
                { MSG_KEYPRESSED         , "KEYPRESSED         " },;
                { MSG_WND_ACTIVATE_MENU  , "WND_ACTIVATE_MENU  " },;
                { MSG_WND_CLOSE          , "WND_CLOSE          " },;
                { MSG_WND_CLICKOUT_TONE  , "WND_CLICKOUT_TONE  " },;
                { MSG_WND_DESELECT_WND   , "WND_DESELECT_WND   " },;
                { MSG_WND_DRAG           , "WND_DRAG           " },;
                { MSG_WND_EVAL_ACTION    , "WND_EVAL_ACTION    " },;
                { MSG_WND_KILL           , "WND_KILL           " },;
                { MSG_WND_MINIMIZE       , "WND_MINIMIZE       " },;
                { MSG_WND_MAXIMIZE       , "WND_MAXIMIZE       " },;
                { MSG_WND_NONE           , "WND_NONE           " },;
                { MSG_WND_OPEN           , "WND_OPEN           " },;
                { MSG_WND_RESIZE         , "WND_RESIZE         " },;
                { MSG_WND_RESTORE        , "WND_RESTORE        " },;
                { MSG_WND_SELECT_WND     , "WND_SELECT_WND     " },;
                { MSG_WND_TOGGLE_MENUCTRL, "WND_TOGGLE_MENUCTRL" },;
                { MSG_SRV_HALT           , "SRV_HALT           " },;
                { MSG_SRV_SUSPEND        , "SRV_SUSPEND        " },;
                { MSG_SRV_TERMINATE      , "SRV_TERMINATE      " },;
                { MSG_SRV_WND_DEREGISTER , "SRV_WND_DEREGISTER " },;
                { MSG_SRV_WND_NEXT       , "SRV_WND_NEXT       " },;
                { MSG_SRV_WND_PREVIOUS   , "SRV_WND_PREVIOUS   " },;
                { MSG_SRV_WND_REGISTER   , "SRV_WND_REGISTER   " },;
                { MSG_SRV_WND_SELECT     , "SRV_WND_SELECT     " } ;
              }

return nil

//-----------------------------------------------------------------------//
