//-----------------------------------------------------------------------//
//  VISUAL ENGINE FOR CLIPPER - Ver 1.0
//  (c) 1993-4 Peyrona Soft
//  Authors: Manolo Caracuel Urbano
//           Francisco Morero Peyrona
//
//                 VISUAL ENGINE FOR CLIPPER TUTOR ( MENU DEMO )
//-----------------------------------------------------------------------//

#include "Inkey.ch"
#include "veSystem.ch"
#include "veMouse.ch"
#include "veCtrl.ch"
#include "veMsg.ch"
#include "veWindow.ch"
#include "vePopUp.ch"
#include "veColors.ch"

//-----------------------------------------------------------------------//

static nMCrs   := MS_CRS_ARROW
static nWP     := 1
static wndTutor

//-----------------------------------------------------------------------//

function Menu( wndLesson )

   local wndTest

   /*------------------------
     See previous chapters to know why this part is REM

     INIT SYSTEM         
   ------------------------*/

   wndTutor = wndLesson       // To avoid a user mistake changing video mode

   CREATE WINDOW wndTest FROM 1,18 TO 13,65     ;
          TITLE "Menu Demo"                     ;
          ON CLOSE  { |oWnd| CloseWnd( oWnd ) }
   
   DefCrsClock()    // Defines user mouse cursor for 25 lines mode
   DefCrsMouse()    // Defines user mouse cursor for 43 and 50 lines modes

   LoadMenu( wndTest )

   OPEN WINDOW wndTest

   LessonWnd( wndTest )                 // For internal tutor use only

   @ 1,1 veSAY "You can use all normal keys with the menu:" ;
         COLOR wndTest:COLOR_LOW

   @ 2, 1 veSAY "Alt + <HotKey>"   COLOR wndTest:COLOR_HIGH
   @ 2,16 veSAY "to open any item" COLOR wndTest:COLOR_LOW

   @ 3, 1 veSAY "<HotKey>"         COLOR wndTest:COLOR_HIGH
   @ 3,10 veSAY "to activate item when menu is open" ;
                                   COLOR wndTest:COLOR_LOW

   @ 4, 1 veSAY "F10"              COLOR wndTest:COLOR_HIGH
   @ 4, 5 veSAY "to activate menu" COLOR wndTest:COLOR_LOW

   @ 5, 1 veSAY "Alt + Enter"               COLOR wndTest:COLOR_HIGH
   @ 5,13 veSAY "to open window close menu" COLOR wndTest:COLOR_LOW

   @ 7,1 veSAY "Or using the mouse (try to drag it)" ;
         COLOR wndTest:COLOR_LOW

   /*---------------------------
     See previous chapters to know why this part is REM

   ACTIVATE WINDOWS

   DEINIT SYSTEM
   --------------------------*/

return nil

//-----------------------------------------------------------------------//

func DefCrsClock()

   //--------- Bit map definition ------------
   // OR MASK
   //          0000011111000000
   //          0000011111000000
   //          0000011111000000
   //          0000111111100000
   //          0001000000010000
   //          0010000100001000
   //          0100000100000100
   //          0100000100000111
   //          0100000111100111
   //          0100000000000100
   //          0010000000001000
   //          0001000000010000
   //          0000111111100000
   //          0000011111000000
   //          0000011111000000
   //          0000011111000000
   //
   // AND MASK
   //          1111011111011111
   //          1111011111011111
   //          1110011111001111
   //          1100111111100111
   //          1001000000010011
   //          0010000100001001
   //          0100000100000100
   //          0100000100000111
   //          0100000111100111
   //          0100000000000100
   //          0010000000001001
   //          1001000000010011
   //          1100111111101111
   //          1110011111001111
   //          1111011111011111
   //          1111011111011111
   //-----------------------------------------

   MDefGCrs( ; // OR Mask
             Chr( 007 ) + Chr( 192 ) + Chr( 007 ) + Chr( 192 ) + ;
             Chr( 007 ) + Chr( 192 ) + Chr( 015 ) + Chr( 224 ) + ;
             Chr( 016 ) + Chr( 016 ) + Chr( 033 ) + Chr( 008 ) + ;
             Chr( 065 ) + Chr( 004 ) + Chr( 065 ) + Chr( 007 ) + ;
             Chr( 065 ) + Chr( 231 ) + Chr( 064 ) + Chr( 004 ) + ;
             Chr( 032 ) + Chr( 008 ) + Chr( 016 ) + Chr( 016 ) + ;
             Chr( 015 ) + Chr( 224 ) + Chr( 007 ) + Chr( 192 ) + ;
             Chr( 007 ) + Chr( 192 ) + Chr( 007 ) + Chr( 192 ) + ;
             ;  // AND Mask
             Chr( 247 ) + Chr( 223 ) + Chr( 247 ) + Chr( 223 ) + ;
             Chr( 231 ) + Chr( 207 ) + Chr( 207 ) + Chr( 231 ) + ;
             Chr( 144 ) + Chr( 019 ) + Chr( 033 ) + Chr( 009 ) + ;
             Chr( 065 ) + Chr( 004 ) + Chr( 065 ) + Chr( 007 ) + ;
             Chr( 065 ) + Chr( 231 ) + Chr( 064 ) + Chr( 004 ) + ;
             Chr( 032 ) + Chr( 009 ) + Chr( 144 ) + Chr( 019 ) + ;
             Chr( 207 ) + Chr( 231 ) + Chr( 231 ) + Chr( 207 ) + ;
             Chr( 247 ) + Chr( 223 ) + Chr( 247 ) + Chr( 223 ), 25 )

return nil

//-----------------------------------------------------------------------//

func DefCrsMouse()

   //--------- Bit map definition ------------
   // OR MASK
   //          0000000000000100
   //          0000000000001000
   //          0000000000000100
   //          0000110111100010
   //          0001101111110010
   //          0010111111111010
   //          0111111111111110
   //          0000011000110000
   //
   // AND MASK
   //          1111111111100101
   //          1111111111101001
   //          1110000000000100
   //          1100110111100010
   //          1001101111110010
   //          0010111111111010
   //          0111111111111110
   //          0000011000110000
   //-----------------------------------------
   MDefGCrs( ; // OR Mask
             Chr( 000 ) + Chr( 004 ) + ;
             Chr( 000 ) + Chr( 008 ) + ;
             Chr( 000 ) + Chr( 004 ) + ;
             Chr( 013 ) + Chr( 226 ) + ;
             Chr( 027 ) + Chr( 242 ) + ;
             Chr( 047 ) + Chr( 250 ) + ;
             Chr( 127 ) + Chr( 254 ) + ;
             Chr( 006 ) + Chr( 048 ) + ;
             ; // AND Mask
             Chr( 255 ) + Chr( 229 ) + ;
             Chr( 255 ) + Chr( 233 ) + ;
             Chr( 224 ) + Chr( 004 ) + ;
             Chr( 205 ) + Chr( 226 ) + ;
             Chr( 155 ) + Chr( 242 ) + ;
             Chr( 047 ) + Chr( 250 ) + ;
             Chr( 127 ) + Chr( 254 ) + ;
             Chr( 006 ) + Chr( 048 ), 50 )

return nil

//-----------------------------------------------------------------------//

static func LoadMenu( wndTest )

   DEFINE POPUP MENU OF wndTest
      ADD ITEM   LABEL    " &Mouse "                    ;
                 HELPLINE  "Changes mouse cursor shape"

      DEFINE MENU
         ADD ITEM   LABEL    "  &Predefined   F2  " ;
                    SHORTCUT K_F2                   ;
                    HELPLINE "Changes to one of the predefined cursors"
         DEFINE MENU
            ADD ITEM   LABEL    "  &Arrow   F3  "     ;
                       SHORTCUT K_F3                       ;
                       HELPLINE "Changes to normal cursor" ;
                       CHECKED  nMCrs == MS_CRS_ARROW      ;
                       ACTION  ( MChgCrs( MS_CRS_ARROW ), ;
                                  nMCrs := MS_CRS_ARROW )

            ADD ITEM   LABEL    "  &Hand    F4  "            ;
                       SHORTCUT K_F4                         ;
                       HELPLINE "Changes to a pointing hand" ;
                       CHECKED  nMCrs == MS_CRS_HAND         ;
                       ACTION  ( MChgCrs( MS_CRS_HAND ),    ;
                                  nMCrs := MS_CRS_HAND )


            ADD ITEM   LABEL    "  &Clock   F5  "               ;
                       SHORTCUT K_F5                            ;
                       HELPLINE "Changes to a sand clock"       ;
                       CHECKED  nMCrs == MS_CRS_SAND_CLOCK      ;
                       ACTION  ( MChgCrs( MS_CRS_SAND_CLOCK ), ;
                                 nMCrs := MS_CRS_SAND_CLOCK )


            ADD ITEM   LABEL    "  &Cross   F6  "            ;
                       SHORTCUT K_F6                         ;
                       HELPLINE "Changes to 'moving' cursor" ;
                       CHECKED  nMCrs == MS_CRS_CROSS        ;
                       ACTION  ( MChgCrs( MS_CRS_CROSS  ),  ;
                                  nMCrs := MS_CRS_CROSS )


            ADD ITEM   LABEL    "  &Resize  F7  "            ;
                       SHORTCUT K_F7                         ;
                       HELPLINE "Changes to 'resize' cursor" ;
                       CHECKED  nMCrs == MS_CRS_RESIZE       ;
                       ACTION  ( MChgCrs( MS_CRS_RESIZE ),   ;
                                  nMCrs := MS_CRS_RESIZE )

         END MENU
                             
         ADD ITEM   LABEL    "  C&ustom       F8  "           ;
                    SHORTCUT K_F8                             ;
                    HELPLINE "Changes to user defined cursor" ;
                    CHECKED  nMCrs == MS_CRS_USER_DEF         ;
                    ACTION  ( nMCrs := MS_CRS_USER_DEF,       ;
                              MChgCrs( MS_CRS_USER_DEF ) )

      END MENU

      ADD ITEM   LABEL   " &WallPaper "           ;
                 HELPLINE "Changes de Wall paper"

      DEFINE MENU
         ADD ITEM   LABEL    "  WallPaper &A  Shift-F2 "       ;
                    SHORTCUT K_SH_F2                           ;
                    HELPLINE "Changes WallPaper to type A"     ;
                    CHECKED  nWP == 1                          ;
                    ACTION  ( App():SetWallPaper( 1 ), nWP := 1 )

         ADD ITEM   LABEL    "  WallPaper &B  Shift-F3 "       ;
                    SHORTCUT K_SH_F3                           ;
                    HELPLINE "Changes WallPaper to type B"     ;
                    CHECKED  nWP == 2                          ;
                    ACTION  ( App():SetWallPaper( 2 ), nWP := 2 )

         ADD ITEM   LABEL    "  WallPaper &C  Shift-F4 "       ;
                    SHORTCUT K_SH_F4                           ;
                    HELPLINE "Changes WallPaper to type C"     ;
                    CHECKED  nWP == 3                          ;
                    ACTION  ( App():SetWallPaper( 3 ), nWP := 3 )
      END MENU

      ADD ITEM   LABEL   " &Video "           ;
                 HELPLINE "Changes Video Mode"

      DEFINE MENU
         ADD ITEM   LABEL    " &25 * 80  Ctrl-F2 "          ;
                    SHORTCUT K_CTRL_F2                       ;
                    HELPLINE "Changes to 25 Rows * 80 Cols " ;
                    ACTIVE   MaxScrRow() != 24               ;
                    ACTION  ( App():SetVideoMode( 25, 80 ) )

         ADD ITEM   LABEL    " &43 * 80  Ctrl-F3 "          ;
                    SHORTCUT K_CTRL_F3                       ;
                    HELPLINE "Changes to 43 Rows * 80 Cols " ;
                    ACTIVE   MaxScrRow() != 42               ;
                    ACTION  ( App():SetVideoMode( 43, 80 ) )

         ADD ITEM   LABEL    " &50 * 80  Ctrl-F4 "          ;
                    SHORTCUT K_CTRL_F4                       ;
                    HELPLINE "Changes to 50 Rows * 80 Cols " ;
                    ACTIVE   MaxScrRow() != 49               ;
                    ACTION  ( App():SetVideoMode( 50, 80 ) )
      END MENU

      ADD ITEM   LABEL    " E&xit "                                 ;
                 HELPLINE "Closes the window and returns to index " ;
                 ACTION   CloseWnd( wndTest )

   END MENU

return nil

//-----------------------------------------------------------------------//

static func CloseWnd( oWnd )

   nMCrs = MS_CRS_ARROW
   nWP   = 1

   MChgCrs( nMCrs )
   App():SetWallPaper( nWP )
   App():SetVideoMode( 25, 80 )

   // When the user changes the video mode to 43 or 50 rows and drag the
   // text window to the bottom of the screen and changes again the video
   // mode to 25 rows, the text window will dissapear. Nothing is working
   // wrong, but the user could think that there is a mistake, so we move
   // it to its original position in a visible screen area.

   wndTutor:Move( 11, 0 )

return .F.

//-----------------------------------------------------------------------//
