*ͻ*
*   Module Name:   TBGETS.PRG                                      *
*   Description:   An example of editing cells of a TBrowse.       *
*   Notes......:   COMPILE with the /n switch.                     *
*   Author.....:   Micheal Todd Charron                            *
*   Date.......:   June 13, 1991                                   *
*   History....:   Just decided it was something I had to do.      *
*                                                                  *
*   Copyright..:   (c) The people at Nantucket Canada, 1991        *
*ͼ*
#include "inkey.ch"

FUNCTION MAIN()
    	LOCAL nI, nKey
	LOCAL oBrowse := TBROWSEDB( 4, 3, 23, 76 ), oColumn, oGet

	CLS
	SETCURSOR( 0 )

	USE JUNK

	FOR nI := 1 TO FCOUNT()
		oBrowse:ADDCOLUMN( TBCOLUMNNEW( FIELD( nI ),;
			FIELDBLOCK( FIELD( nI ) ) ) )
	NEXT nI

	DO WHILE nKey != K_ESC

		DO WHILE ! oBrowse:stabilize()
		ENDDO

		nKey := INKEY( 0 )

		DO CASE
		CASE nKey == K_DOWN
			oBrowse:down()
		CASE nKey == K_UP
			oBrowse:up()
		CASE nKey == K_LEFT
			oBrowse:left()
		CASE nKey == K_RIGHT
			oBrowse:right()
		CASE nKey == K_ENTER
			oColumn := oBrowse:getColumn( oBrowse:colPos )
			oGet := GETNEW( ROW(), COL(), oColumn:block )

			SETCURSOR( 1 )
			READMODAL( { oGet } )
			SETCURSOR( 0 )

			oBrowse:refreshCurrent()
		ENDCASE

	ENDDO

	SETCURSOR( 1 )
RETURN Nil

/******************************************************************************
The program TBSIMPLE.PRG should be studied before taking a look at this program
as this program builds upon it.  Only lines that are different from those in
TBSIMPLE.PRG will be explained.

			         ********

The following lines will be invoked when the user moves to the cell to be
edited and presses the ENTER key.

        ͸
Line 44   oColumn := oBrowse:getColumn( oBrowse:colPos )                    
        ;
The first step in creating gets for a TBrowse is to extract the reference to
the current TBrowse column's object.  The instance variable oBrowse:colPos will
return the column position of the highlite bar as an integer.  The
oBrowse:getColumn() method with the column position as the method's parameter
will return the reference to the column object.

        ͸
Line 45   oGet := GETNEW( ROW(), COL(), oColumn:block )                     
        ;
The GETNEW() function is used to create the GET object for the current cell.
The ROW() and COL() functions are used to position the GET.  The oColumn:block
instance variable will hold the code block used to display the data in the
current column.  By using the FIELDBLOCK() function to create the columns we
had also created a code block that will assign the value of the edit to the
database field.  The code block will look like this:

       { | setVal | IF( setVal == Nil, <field>, <field> := setVal ) }

Confused yet?  (see below for explaination of this code block)

        ͸
Line 47   SETCURSOR( 1 )                                                    
Line 48   READMODAL( { oGet } )                                             
Line 49   SETCURSOR( 0 )                                                    
        ;
The cursor is turned on to show that the get is active.  The GET object is then
passed into the READMODAL() function as a literal array.  The reason for this
is the READMODAL() function processes GETs in an array so that it can move
forward and backward between them.  In this case there is one GET so we pass a
one element array to the READMODAL() function.

The READMODAL() function handles the editing of the GET.  The READMODAL()
function's code can be found in the GetSys.prg file in the /SOURCE/SYS
subdirectory of your Clipper 5.01 directory.

Finally the cursor is set off to indicate that the cell is no longer editable.
*******************************************************************************

    ͸
      { | setVal | IF( setVal == Nil, <field>, <field> := setVal ) }    
    ;
The code block above serves a very special purpose.  When you are using this
code block in a TBROWSE it evaluates the code block without passing any 
parameters into it.  Since the variable "setVal" is equal to Nil (nothing was
passed to the code blocks parameter) the first part of the IF() function is
processed which just returns the value in the field.  The same method is used
to initialize a GET object.

I'm going to let you in on a little secret.  When you are editing a GET the
first thing it does is set up two buffers.  One is the Original buffer which 
will always hold the original value while your editing the GET and the Editing
buffer which holds the value which you are editing.  So while editing the GET
you have the Original buffer, the Editing buffer and the field (variable).

When you accept the value in the GET (ENTER OR DOWN) the code block above is
passed the value in the Editing buffer and evaluated.  Since the value in the
Editing buffer is passed to the code block, the variable "setVal" does not
equal Nil.  The second part of the IF() function is processed which assigns
the value in setVal (the Editing buffer) to <field>.
******************************************************************************/