/****
* dbed.prg
* a sample program to demonstrate conversion to tbrowse
*
*/

#include "dbedit.ch"
#include "inkey.ch"

FUNCTION DBEd
   LOCAL acCols[3], acPics[3], acHeads[3], acFoots[3]
   LOCAL cColSep, cFootSep, cHeadSep

   acCols[1] :=  "Rolo->Name"
   acCols[2] :=  "CalcAge(Rolo->BirthDate)"
   acCols[3] :=  "Rolo->PhoneNum"

   acPics[1] := ""
   acPics[2] := ""
   acPics[3] := "@R 999-9999"

   acHeads[1] := acFoots[1] := "Name"
   acHeads[2] := acFoots[2] := "Age"
   acHeads[3] := acFoots[3] := "Phone #"

   cHeadSep := ''
   cColSep  := '  '
   cFootSep := ''

   CLEAR SCREEN
   USE ROLO

   @ 3, 10 TO 21, 70

   @ 22, 11 SAY 'Alt-B: Beginning, Alt-E: End'
   DBEDIT( 4, 11, 20, 69, acCols, "MyUdf", acPics, acHeads, cHeadSep, ;
           cColSep, cFootSep, acFoots )

   RETURN NIL


FUNCTION MyUdf( nMode, nCol )
   LOCAL nRet := DE_CONT
   LOCAL cString
   LOCAL nKey := LASTKEY()

   DO CASE
   CASE nMode == DE_IDLE
      cString := STR(RECNO(),3) + '/' + STR(LASTREC(),3)
      @ 22, 70-LEN(cString) SAY cString   

   CASE nMode == DE_HITTOP
      TONE( 523.3, 9 )

   CASE nMode == DE_HITBOTTOM
      TONE( 523.3, 9 )

   CASE nMode == DE_EXCEPT
      DO CASE
      CASE nKey == K_ESC
         nRet := DE_ABORT

      CASE nKey == K_ALT_E
         GO BOTTOM
         nRet := DE_REFRESH

      CASE nKey == K_ALT_B
         GO TOP
         nRet := DE_REFRESH

      ENDCASE

   ENDCASE

   RETURN (nRet)

FUNCTION CalcAge(dBirth)
   LOCAL lPast := .F.

   IF (MONTH(DATE()) > MONTH(dBirth)) .AND. (DAY(DATE()) >= DAY(dBirth))
      lPast := .T.
   ENDIF
   
   RETURN( YEAR(DATE())-YEAR(dBirth) - IIF(lPast, 0, 1) )
   
