/***
* two.prg
* Same as one.prg, except with more color support
*
*/                 

#include "inkey.ch"

FUNCTION Two( cMono )
   LOCAL lMono

   IF cMono != NIL .AND. LEFT(cMono,2) == "/m"
      lMono := .T.
   ELSE
      lMono := !ISCOLOR()
   ENDIF

   CLEAR SCREEN

   @ 3, 10 TO 21, 70

   BrowseRolo( 4, 11, 20, 69, IF(lMono, "W/N,N/W,W/N*,N/W*", ;
                                        "W/N,N/W,R/N, R/W" ))   // NOTE!

   RETURN NIL

FUNCTION BrowseRolo( nTop, nLeft, nBottom, nRight, cColor )
   LOCAL oBrowse, oColumn
   LOCAL lCont
   LOCAL nKey
   LOCAL cString
   LOCAL nCursSave

   USE ROLO
   @ nBottom+2, nLeft SAY 'Alt-B: Beginning, Alt-E: End'

   /* Set cursor off */
   nCursSave := SETCURSOR(0)                     

	/* make new browse object */
   oBrowse := TBrowseDB(nTop, nLeft, nBottom, nRight)

   /* add columns            */
   oColumn := TBColumnNew("Name", {|| Rolo->Name})
   oColumn:footing := oColumn:heading
   oBrowse:addColumn(oColumn)

   oColumn := TBColumnNew("Age", {|| CalcAge(Rolo->BirthDate)})
   oColumn:footing := oColumn:heading
   oColumn:defColor := {1,2}                                    // NOTE!
   oColumn:colorBlock := {|nAge| IF(nAge < 40, {3,4}, {1,2})}   // NOTE!
   oBrowse:addColumn(oColumn)

   oColumn := TBColumnNew("Phone #", ;
                          {|| TRANSFORM(Rolo->PhoneNum,'@R 999-9999')})
   oColumn:footing := oColumn:heading
   oBrowse:addColumn(oColumn)  

   /* "customize" browse    */
   oBrowse:headSep := ''
   oBrowse:colSep  := '  '
   oBrowse:footSep := ''

   oBrowse:colorSpec := cColor                              // NOTE!
   oBrowse:defColor  := { 1, 2 }                            // NOTE!

   // enter main browse loop
   lCont := .T.
   DO WHILE lCont
      /* stabilization
      * 
      * Stabilization causes all pending actions to be resolved.  No 
      * movement actually takes place until stabilization is done.  One
      * row is updated at a time, headings are not affected.
      */
      DO WHILE .NOT. oBrowse:stabilize()
      ENDDO

      IF oBrowse:hitBottom
         TONE( 523.3, 9 )
      ENDIF
      IF oBrowse:hitTop
         TONE( 523.3, 9 )
      ENDIF

      /* Idle event area */
      cString := STR(RECNO(),3) + '/' + STR(LASTREC(),3)
      @ nBottom+2, nRight-LEN(cString) SAY cString   

      nKey := INKEY(0)

      /* keystroke exception area */
      DO CASE
      CASE nKey == K_UP
         oBrowse:up()
      CASE nKey == K_DOWN
         oBrowse:down()
      CASE nKey == K_LEFT
         oBrowse:left()
      CASE nKey == K_RIGHT
         oBrowse:right()
      CASE nKey == K_PGUP
         oBrowse:pageUp()
      CASE nKey == K_PGDN
         oBrowse:pageDown()
      CASE nKey == K_HOME
         oBrowse:home()
      CASE nKey == K_END
         oBrowse:end()
      CASE nKey == K_CTRL_PGUP
         oBrowse:goTop()
      CASE nKey == K_CTRL_PGDN
         oBrowse:goBottom()
      CASE nKey == K_CTRL_LEFT
         oBrowse:panLeft()
      CASE nKey == K_CTRL_RIGHT
         oBrowse:panRight()
      CASE nKey == K_CTRL_HOME
         oBrowse:panHome()
      CASE nKey == K_CTRL_END
         oBrowse:panEnd()
      /***
      * Add your keys here
      */
      CASE nKey == K_ESC
         lCont := .F.
      CASE nKey == K_ALT_E
         oBrowse:goBottom()
      CASE nKey == K_ALT_B
         oBrowse:goTop()
      ENDCASE
   ENDDO

   /* Restore cursor */
   SETCURSOR(nCursSave)
   RETURN (NIL)

FUNCTION CalcAge(dBirth)
   LOCAL lPast := .F.

   IF (MONTH(DATE()) > MONTH(dBirth)) .AND. (DAY(DATE()) >= DAY(dBirth))
      lPast := .T.
   ENDIF
   
   RETURN( YEAR(DATE())-YEAR(dBirth) - IIF(lPast, 0, 1) )
   
