************
*
*	Filename..:  DBEDDEMO.PRG
*	Author....:  Dennis L. Dias
*	Date......:  9/03/87
*
*	Purpose...:  demonstrate DBEDIT
*
************
parameters datafile, indexfile
local n
private field_list, headings, footings, pics

IF ValType(datafile) = "U"
	?
	? "Must enter name of data file on command line."
	?
	QUIT

ENDIF

IF .NOT. (FILE(datafile) .OR. FILE(datafile + ".DBF"))
	?
	? "File not found."
	?
	QUIT

ENDIF

CLEAR SCREEN

* file exists
IF Valtype (indexfile) = "C" .AND.;
   (FILE(indexfile) .OR. FILE(indexfile + INDEXEXT()))
	USE &datafile INDEX &indexfile

ELSE
	USE &datafile

ENDIF

* create an array of field names
field_list := Array(FCOUNT() + 1)
headings := Array(FCOUNT() + 1)
footings := Array(FCOUNT() + 1)
pics := Array(FCOUNT() + 1)

field_list[1] = "F()"
headings[1] = "Record#"
footings[1] = ""

FOR n = 1 TO FCOUNT()
	* each element contains one field name
	field_list[n + 1] = FIELDNAME(n)
	headings[n + 1] = "This is;" + FIELDNAME(n)
	footings[n + 1] = "That was;" + FIELDNAME(n)

	DO CASE

		CASE Type(FIELDNAME(n)) = "C"
			pics[n + 1] = ""

		CASE Type(FIELDNAME(n)) = "N"
			pics[n + 1] = "9,999,999.99"

	ENDCASE
NEXT

* draw box to illustrate window
* @ 2, 5, 20, 74 BOX "͸Գ"
@ 2, 5, 20, 74 BOX "͸ Գ"
@ 5, 5  SAY ""
@ 5, 74 SAY ""

* edit the file
DBEDIT(3, 6, 22, 73, field_list, "ed", pics, headings, .T., .T., "", footings)

@ 23,0 SAY " "
QUIT


******
*	ed()
*
*	user defined function to be called from DBEDIT
******
FUNCTION ed(mode, i)
*private cur_field, r, keyexpr, keyeval
memvar r, keyexpr, keyeval, field_list, pics

* assume continue dbedit
r = 1

* get the name of the current field into a regular variable
cur_field = field_list[i]

DO CASE
	* case action can be implemented for each mode

	CASE mode = 0
		* idle mode..display record number
		@ 1,62 SAY "Record " + LTRIM(STR(RECNO())) + "    "

	CASE mode = 1
		@ 1,62 SAY "Record " + "Bof "

	CASE mode = 2
		@ 1,62 SAY "Record " + "Eof "

	CASE mode = 3
		@ 1,62 SAY "Record " + "None"

	CASE mode = 4
		* mode 4..a keystroke not handled by DBEDIT

		DO CASE

			CASE LASTKEY() = 27
				* escape key..quit
				r = 0

			CASE LASTKEY() = 13
				* enter key..edit the current field
				* ..current row and col are correct

				IF i > 1
*					keyexpr = INDEXKEY(0)	&& get the controlling index key

*					IF .NOT. EMPTY(keyexpr)
*						keyeval = &keyexpr

*					ENDIF

					* can't edit a user function
					@ ROW(), COL() GET &cur_field PICTURE pics[i]

					* DBEDIT turns off the cursor until it returns
					* control to the calling procedure above
					SET CURSOR ON
					READ
					SET CURSOR OFF

*					IF .NOT. EMPTY(keyexpr)
						* careful not to macro expand a null string

*						IF .NOT. keyeval = &keyexpr
							* change in key..force refresh
*							r = 2

*						ENDIF
*					ENDIF
				ENDIF

				* return a right arrow to advance cursor on return
				* ..any cursor key can be returned this way
				KEYBOARD CHR(4)

			OTHERWISE
				IF LASTKEY() >= 32 .AND. LASTKEY() <= 126
					KEYBOARD CHR(13) + CHR(LASTKEY())

				ENDIF
		ENDCASE
ENDCASE

RETURN r


******
*	f()
*
*	a user function
******
FUNCTION f

RETURN STR(RECNO(), 7)


* EOF DBEDDEMO.PRG
