// ===========================================================================
// Version 1.00.00 of Sept 24, 1992
//
// TASK.PRG: This set of functions is designed to activate a revolving beach-
// --------- ball wait symbol as like Apple(TM)'s System7 for Macintosh
//           It's a quick-and-dirty function set, but it will work on most
//           cases.
//
//           The ball can be activated while a message is displayed and a task
//           is executed. The ball turns once each time a particular task is
//           executed.
//
// Contents: TASK    .PRG (You may alter this on your needs)
// --------- BALLFONT.OBJ (contains the font information)
//
// Compile/link:
// -------------
// I compiled this using /m/n/w parameters and linked with RTLink using
// "FILE <main>,task,nt2gr50 LIB nt250", where <main> is my main program
// file.
//
// Restrictions:
// -------------
// To display the ball font in text mode, 8 characters are used to draw it.
// Thus, the program should not use them for other than ball output.
// However, you can alter the area where the ball is stored, by just entering
// the first character's ordinal number in START_CHAR.
//
// TASK only works with 14 and 16 lines per char. An 8 lines mode is not sup-
// ported but may in the future, if necessary.
//
// Miscellaneous:
// --------------
// You may throw away this header 'cause it wastes many bytes and makes the
// program unreadable. But please note the following before you do it:
//
// This program was designed quick-and-dirty by:
//
// Michael Kochendoerfer
// Postfach 23
// D-7119 Doerzbach
//
// CI$-ID: 100023,2604 (business)
//         100112,3337 (private)
//
// (To all of them who find that's worth the time to write this tool: I NEVER
// restrict your right to send me any money, but: I also NEVER suggest you to
// do it !)
// ===========================================================================

#define START_CHAR           226
#define CHAR_1               (Chr(START_CHAR+0)+Chr(START_CHAR+1))
#define CHAR_2               (Chr(START_CHAR+2)+Chr(START_CHAR+3))
#define CHAR_3               (Chr(START_CHAR+4)+Chr(START_CHAR+5))
#define CHAR_4               (Chr(START_CHAR+6)+Chr(START_CHAR+7))

// ===========================================================================
// !! Call this AFTER any FONTLOAD() or xxxPALETTE() functions !!
//
// <nFontArea>:  Area (1 to n) where the ball's stored
//
Function  TaskInit( nFontArea )

Local     cFontSet
Local     x


Do Case
Case CharPix() == 14;  cFontSet := BallFont14()
Case CharPix() == 16;  cFontSet := BallFont16()
Endcase

For x := 0 To 8
   SetFont( Substr( cFontSet, x * CharPix() + 1, CharPix() ), nFontArea, ;
            x + START_CHAR, 1 )
Next x

Return NIL
// ===========================================================================
// TASK() will open a window when called with <nMode>=0. The window's been
// left open, but if you'll need to select another one until the next call,
// receive the return value (that's the window handle), save it, open or
// select your window and then switch back before you do the next task.
//
// You're suggested to call in the following manner:
//
// Task( 0, ... your positions ... )
// : task loop
//   Task( 1 )
// : task loop end
// Task( 2 )
//
// <nMode>:  0 to init window, 1 to perform a task, 2 to close window
// <nZ1>  :  row of upper left corner of window
// <nS1>  :  column of upper left corner of window
// <nZ2>  :  row of lower right corner of window
// <nS2>  :  column of lower right corner of window
// <nBox> :  box form (-1 if no box is needed)
// <nBZ>  :  row where the ball is displayed
// <nBS>  :  column where the ball is displayed
//
Function  Task( nMode, nZ1, nS1, nZ2, nS2, nBox, nBZ, nBS )

Static    nTaskChar, nPrevWin, nsBZ, nsBS
Static    nWin
Local     aTaskChar := { CHAR_1, CHAR_2, CHAR_3, CHAR_4 }


// type check on <nMode>, set to 1 if no parameter given
nMode := If( ValType( nMode ) # "N", 1, nMode )

Do Case
Case nMode == 0              // open and init
   // type check on all others
   nZ1  := If( ValType( nZ1 )  # "N",        0, nZ1 )
   nS1  := If( ValType( nS1 )  # "N",        0, nS1 )
   nZ2  := If( ValType( nZ2 )  # "N", MaxRow(), nZ2 )
   nS2  := If( ValType( nS2 )  # "N", MaxCol(), nS2 )
   nBox := If( ValType( nBox ) # "N",       -1, nBox )
   nBZ  := If( ValType( nBZ )  # "N",        0, nBZ )
   nBS  := If( ValType( nBS )  # "N",        0, nBS )

   // set up static vars ...
   nTaskChar := 1
   nsBZ      := nBZ
   nsBS      := nBS

   // save prev window and open new one ...
   nPrevWin := WSelect();  WSelect( 0 )
   nWin     := WOpen( nZ1, nS1, nZ2, nS2, .T. )

   // draw a box if needed
   If nBox >= 0;  WBox( nBox );  Endif

   // first time output of ball ...
   @ nsBZ,nsBS Say aTaskChar[ nTaskChar ]

Case nMode == 1              // update the task ball
   // count for the next ball view ...
   nTaskChar++
   nTaskChar := If( nTaskChar > Len( aTaskChar ), 1, nTaskChar )

   // output of ball ...
   @ nsBZ,nsBS Say aTaskChar[ nTaskChar ]

Otherwise                    // close window
   WClose()
   WSelect( nPrevWin )

Endcase

Return ( nWin )
// ===========================================================================
