; File......: INP.ASM
; Author....: Ted Means
; Date......: $Date:   15 Aug 1991 23:06:50  $
; Revision..: $Revision:   1.2  $
; Log file..: $Logfile:   E:/nanfor/src/inp.asv  $
; 
; This function is an original work by Ted Means and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
; $Log:   E:/nanfor/src/inp.asv  $
;  
;     Rev 1.2   15 Aug 1991 23:06:50   GLENN
;  Forest Belt proofread/edited/cleaned up doc
;  
;     Rev 1.1   14 Jun 1991 19:54:34   GLENN
;  Minor edit to file header
;  
;     Rev 1.0   01 Apr 1991 01:03:22   GLENN
;  Nanforum Toolkit
;  


;  $DOC$
;  $FUNCNAME$
;      FT_INP()
;  $CATEGORY$
;      DOS/BIOS
;  $ONELINER$
;      Retrieve a byte from a specified I/O port
;  $SYNTAX$
;      FT_INP( <nPort> ) -> nValue
;  $ARGUMENTS$
;     <nPort> is the port from which to retrieve the byte.  If it is
;     invalid in any way, the function will return zero.
;  $RETURNS$
;     The byte retrieved.
;  $DESCRIPTION$
;     It may sometimes be useful to read a byte from a port without having
;     to resort to C or assembler.  This function allows you to do so.
;
;     The source code is written to adhere to Turbo Assembler's IDEAL mode.
;     To use another assembler, you will need to rearrange the PROC and
;     SEGMENT directives, and also the ENDP and ENDS directives (a very
;     minor task).
;  $EXAMPLES$
;     byte := FT_INP( 100 )   // read a byte from port 100 (064h)
;  $SEEALSO$
;     FT_OUTP()
;  $END$
;


         IDEAL

Public   FT_Inp

Extrn    __ParInfo:Far
Extrn    __ParNI:Far
Extrn    __RetNI:Far

Segment  _NanFor   Word      "CODE"
         Assume    CS:_NanFor

Proc     FT_Inp    Far

         Xor       AX,AX                     ; Request param count
         Push      AX                        ; Put request on stack
         Call      __ParInfo                 ; Get param count
         Add       SP,2                      ; Realign stack
         Or        AX,AX                     ; Zero params?
         JZ        Exit                      ; If not, exit

         Mov       AX,1                      ; Specify first param
         Push      AX                        ; Put param # on stack
         Call      __ParInfo                 ; Get param type
         Add       SP,2                      ; Realign stack
         Test      AX,2                      ; Numeric?
         JNZ       GetParam                  ; Yes, so continue
         Xor       AX,AX                     ; Set return value to zero
         JMP       Short Exit                ; Quit

GetParam:Mov       AX,1                      ; Specify first param
         Push      AX                        ; Put param # on stack
         Call      __ParNI                   ; Get value
         Add       SP,2                      ; Realign stack
         Mov       DX,AX                     ; Move port # to DX
         In        AL,DX                     ; Get a byte from the port
         Mov       AH,0                      ; Clear high byte

Exit:    Push      AX                        ; Put return value on stack
         Call      __RetNI                   ; Return it to Clipper app
         Add       SP,2                      ; Realign stack
         Ret
Endp     FT_Inp
Ends     _NanFor
End
