/*
 Ŀ
  This is a copy of the ft_scrtile() function as originally submitted for  
  inclusion in the Nanforum Toolkit.                                       
                                                                           
  To test the function, compile, link and run as follows (note that        
  "FT_TEST" must be upper case:                                            
                                                                           
    clipper scrtile /n /dFT_TEST                                           
    rtlink fi scrtile                                                      
    scrtile                                                                
                                                                           
  Recompile without the "/dFT_TEST" when you're ready to link it into your 
  program.                                                                 
 
*/


/*
 * File......: SCRTILE.PRG
 * Author....: Todd C. MacDonald
 * CIS ID....: 72274,2252 (formerly 73767,2242)
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Todd C. MacDonald and is hereby
 * placed in the public domain.
 *
 * Modification history:
 * ---------------------
 * 04-21-93 01:00am v1.00 TCM - Original version.
 *
 * 11-11-93 01:01am v1.01 TCM - Changed docs to reflect my new CIS ID.
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      ft_scrtile()
 *  $CATEGORY$
 *      To be assigned
 *  $ONELINER$
 *      Paint a "tiled" text pattern over a specified screen region.
 *  $SYNTAX$
 *      ft_scrtile( <acTile>, <nColor>, ;
 *        [<nT>], [<nL>], [<nB>], [<nR>] ) -> NIL
 *  $ARGUMENTS$
 *      <acTile> is a single or multi-dimensional array of
 *      character strings to be used as a "tile" which will be
 *      replicated to cover the specified screen region.
 *
 *      <nColor> is an integer representing the color attribute.
 *      The formula is: nFore + ( nBack * 16 )
 *
 *      <nT>, <nL>, <nB>, and <nR> are the optional coordinates of
 *      the screen region you wish to "tile" over.  The defaults
 *      for each if not passed are 0, 0, maxrow(), and maxcol()
 *      respectively.
 *  $RETURNS$
 *      NIL
 *  $DESCRIPTION$
 *      This function may be used to paint an attractive backdrop or
 *      "desktop" surface on which to display your windows or other
 *      screen objects.
 *  $EXAMPLES$
 *      ft_scrtile( { '' }, 20 )     // Fills the screen with R/B ''s.
 *                                    // "@...box" might be a better choice
 *                                    // in this case.
 *
 *      ft_scrtile( { ;               // Fills the region specified with
 *        '', ;               // the pattern shown in Yellow on
 *        '', ;               // Magenta.
 *        '', ;
 *        '' }, ;
 *        94, 2, 4, maxrow() - 3, maxcol() - 4 )
 *
 *      ft_scrtile( { ;               // Fills the screen with the pattern
 *        '        ', ;             // shown in White on Cyan.
 *        '         ', ;
 *        '        ', ;
 *        '         ', ;
 *        '         ' }, 63 )
 *
 *      ft_scrtile( { ;               // You get the idea.
 *        '                    ', ;
 *        '  NanForum         ', ;
 *        '                    ', ;
 *        '                    ', ;
 *        '          ToolKit  ', ;
 *        '                    ' }, 31 )
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */


#ifdef FT_TEST


//--------------------------------------------------------------------------//
  FUNCTION TestDriver
//--------------------------------------------------------------------------//

#command WAIT => ;
  @ maxrow(), 0 ;;
  @ maxrow(), int( ( maxcol() - 16 ) / 2 ) say 'press any key...' ;;
  inkey( 0 )

// I know, a total waste of time and disk space, but it's fun to watch...

LOCAL aFTlogo := { ;
  { '                    ','  NanForum         ','                    ', ;
    '                    ','          Toolkit  ','                    ' }, ;
  { '                    ','    NanForum       ','                    ', ;
    '                    ','        Toolkit    ','                    ' }, ;
  { '                    ','      NanForum      ','                   ', ;
    '                   ','       Toolkit      ','                    ' }, ;
  { '                    ','       NanForum    ','                    ', ;
    '                    ','     Toolkit       ','                    ' }, ;
  { '                    ','         NanForum  ','                    ', ;
    '                    ','   Toolkit         ','                    ' }, ;
  { '                    ','           NanFor  ','                 u  ', ;
    '  T              m  ','  oolkit           ','                    ' }, ;
  { '                    ','  T          NanF  ','  o              o  ', ;
    '  o              r  ','  lkit         mu  ','                    ' }, ;
  { '                    ','  ooT          Na  ','  l              n  ', ;
    '  k              F  ','  it         muro  ','                    ' }, ;
  { '                    ','  klooT            ','  i              N  ', ;
    '  t              a  ','           muroFn  ','                    ' }, ;
  { '                    ','  tiklooT          ','                    ', ;
    '                    ','         muroFnaN  ','                    ' }, ;
  { '                    ','    tiklooT        ','                    ', ;
    '                    ','       muroFnaN    ','                    ' }, ;
  { '                    ','      tiklooT       ','                   ', ;
    '                   ','      muroFnaN      ','                    ' }, ;
  { '                    ','       tiklooT     ','                    ', ;
    '                    ','    muroFnaN       ','                    ' }, ;
  { '                    ','         tiklooT   ','                    ', ;
    '                    ','  muroFnaN         ','                    ' }, ;
  { '                    ','           tikloo  ','  m              T  ', ;
    '  u                 ','  roFnaN           ','                    ' }, ;
  { '                    ','  um         tikl  ','  r              o  ', ;
    '  o              o  ','  FnaN          T  ','                    ' }, ;
  { '                    ','  orum         ti  ','  F              k  ', ;
    '  n              l  ','  aN          Too  ','                    ' }, ;
  { '                    ','  nForum           ','  a              t  ', ;
    '  N              i  ','            Toolk  ','                    ' } }

LOCAL lExited := .f., n

ft_scrtile( { '' }, 20 )

wait

ft_scrtile( { ;
  '', ;
  '', ;
  '', ;
  '' }, 94, 2, 4, maxrow() - 3, maxcol() - 4 )

wait

ft_scrtile( { ;
  '        ', ;
  '         ', ;
  '        ', ;
  '         ', ;
  '         ' }, 63 )

wait

WHILE !lExited

  FOR n := 1 TO 18

    ft_scrtile( aFTlogo[ n ], 31,,, maxrow() - 1 )

    IF inkey() != 0

      lExited := .t.

      EXIT

    ENDIF

  NEXT

END

ft_scrtile( aFTlogo[ 1 ], 31,,, maxrow() - 1 )

@ maxrow(), 0

setpos( maxrow() - 1, 0 )

RETURN nil
//--------------------------------------------------------------------------//


#endif


//--------------------------------------------------------------------------//
  FUNCTION ft_scrtile( acTile, nColor, nT, nL, nB, nR )
//--------------------------------------------------------------------------//

LOCAL acPattern := aclone( acTile )
LOCAL cColor    := chr( nColor )
LOCAL nPattRows := len( acPattern )
LOCAL nPattCols := len( acPattern[ 1 ] ) * 2
LOCAL nPattRow  := 0
LOCAL cScrReg   := ''

LOCAL nMaxCol, nNbrReps, nY, nX, nRow

IF nT = nil; nT := 0;        ENDIF
IF nL = nil; nL := 0;        ENDIF
IF nB = nil; nB := maxrow(); ENDIF
IF nR = nil; nR := maxcol(); ENDIF

nMaxCol  := nR - nL + 1
nNbrReps := int( nMaxCol / ( nPattCols / 2 ) ) + 1

// insert color attribute into background pattern
FOR nY := 1 to nPattRows

  FOR nX := 2 to nPattCols step 2

    acPattern[ nY ] = stuff( acPattern[ nY ], nX, 0, cColor )

  NEXT

NEXT

// replicate background pattern and attributes for screen region
FOR nRow := nT to nB

  nPattRow := iif( nPattRow + 1 <= nPattRows, nPattRow + 1, 1 )

  cScrReg += left( replicate( acPattern[ nPattRow ], nNbrReps ), nMaxCol * 2 )

NEXT

// paint the tile pattern over the specified screen region
restscreen( nT, nL, nB, nR, cScrReg )

RETURN nil
//--------------------------------------------------------------------------//
