* WNDOLIB - file display window udf() for Clipper Autumn '86

* courtesy of Pete Orner
*             PRO microSystems
*             San Diego, California

* created 5/05/87

function SCRLFILE
* udf() to scroll thru a .dbf file using scrlwndo.asm and movebar.asm
* if <esc> pressed, returns 0, pointing to initial record
* if <enter> pressed, returns selection bar position 1...NRLINES,
*    pointing to selected record
* UpArrow/DnArrow move selection bar, LtArrow/RtArrow scroll the window
* Home restarts scroll

parameters TROW,LCOL,BROW,RCOL,FRSTMTCH,CHEKSTR,DATASTR,LOGO,;
           LOCOLR,HICOLR,DELCOLR,_LOCOLR,_BARCOLR,;
           MROW,MCOL,MSGSTR,MSGCOLR,REALMENU

* TROW,TCOL     Top left corner of window
* BROW,BCOL     Bottom right corner of window
* FRSTMTCH      1st matching record for search (not necessarily bof())
* CHEKSTR       string describing 'do while' condition for search,
*               e.g. ".not. eof()", "lastname='JONES'", etc
* DATASTR       string describing fields to be displayed in window,
*               e.g. "trim(firstname)+' '+trim(lastname)"
* LOGO          title to be centered in top border of window,
*               e.g. " List of Accounts "
* LOCOLR        color of listed text
* HICOLR        color of double border of window
* DELCOLR       color of "DEL" message displayed after DATASTR if deleted()
* _LOCOLR       color of listed text, integer for .asm routine
* _BARCOLR      color of menu selection bar, integer for .asm routine
* MROW,MCOL     starting location for message line
* MSGSTR        string describing fields to be displayed in message line,
*               e.g. "account_id+' '+str(balance_due)"
* MSGCOLR       color of message line
* REALMENU      flag=.t. if routine is to return selection bar position,
*               .f. if to return 0 always

* Note - _LOCOLR and _BARCOLR are passed to .asm routines and are integers
*  LOCOLR,HICOLR,DELCOLR,MSGCOLR are Clipper color strings: "w/n",etc
*  REALMENU=.f. => returns 0, and displays selection bar only if
*  there is a message line, i.e. LENMSG>0.  

        external SCRLWNDO,MOVEBAR,CURSOR

* SCRLWNDO and MOVEBAR are in the file SCRLMNU.OBJ

private TROW,LCOL,BROW,RCOL,MROW,MCOL,MSGSTR,DATASTR,CHEKSTR,LOGO
private LOCOLR,HICOLR,DELCOLR,MSGCOLR,_LOCOLR,_BARCOLR,_BCOLOR
private RECNO,NRRECS,LASTREC,CURSOR,SMALLNR,SMALL,SFLG,IN_KEY
private NRLINES,LENBAR,LENMSG,FRSTMTCH,FRSTPASS,ROW,REALMENU,SHOWBAR

LENBAR=len(&DATASTR)
LENMSG=len(MSGSTR)
* show menu bar only if active menu or look only w/message line
SHOWBAR=REALMENU .or. LENMSG>0

do CURSOR with "99"     && cursor off
set color to &HICOLR
@ TROW,LCOL to BROW,RCOL double
set color to &LOCOLR
@ TROW,LCOL+(RCOL-LCOL-len("&LOGO"))/2 say "&LOGO"
NRLINES=BROW-TROW-1
@ TROW+1,LCOL+2 say "Searching..."
goto FRSTMTCH
NRRECS=0
do while &CHEKSTR
  NRRECS=NRRECS+1
  skip
enddo
declare _RECORD[NRRECS]
declare _DATA[NRRECS]
if LENMSG>0
  declare _MESSAGE[NRRECS]
endif
FRSTPASS=.t.

do while .t.
  if FRSTPASS
    goto FRSTMTCH
  endif
  ROW=TROW
  RECNO=0
  do while RECNO<NRLINES .and. RECNO<NRRECS
    RECNO=RECNO+1
    if FRSTPASS
      if deleted()
        * negative entry in _RECORD[] => deleted
        _RECORD[RECNO]=-recno()
      else
        _RECORD[RECNO]=recno()
      endif
      _DATA[RECNO]=&DATASTR
      if LENMSG>0
        _MESSAGE[RECNO]=&MSGSTR
      endif
      LASTREC=RECNO
      skip
    endif
    @ ROW+1,LCOL+2 say _DATA[RECNO]
    if _RECORD[RECNO]<0
      set color to &DELCOLR
      @ row(),col()+1 say 'DEL'
      set color to &LOCOLR
    endif
    ROW=row()
  enddo
  SMALLNR=RECNO
  SMALL=(RECNO<NRLINES)
  CURSOR=RECNO-int(RECNO/2)
  if SHOWBAR
    do MOVEBAR with 0,TROW+CURSOR,LCOL+2,LENBAR,_LOCOLR,_BARCOLR
  endif
  do SHOWMSG
  FRSTPASS=.f.
  SFLG=0
  do while .t.

    IN_KEY=0
    do while IN_KEY=0
      IN_KEY=inkey()
    enddo
    keyboard ""         && flush buffer

    do case
      * <escape> or <enter>
      case IN_KEY=27 .or. IN_KEY=13
        exit
      * rightarrow - scroll up one line
      case IN_KEY=4 .and. .not. SMALL .and. RECNO<NRRECS
        RECNO=RECNO+1
        if RECNO>LASTREC
          if deleted()
            _RECORD[RECNO]=-recno()
          else
            _RECORD[RECNO]=recno()
          endif
          _DATA[RECNO]=&DATASTR
          if LENMSG>0
            _MESSAGE[RECNO]=&MSGSTR
          endif
          LASTREC=RECNO
          skip
        endif
        SFLG=1
        do SHOWMSG
      * leftarrow - scroll down one line
      case IN_KEY=19 .and. .not. SMALL .and. RECNO>NRLINES
        SFLG=-1
        do SHOWMSG
        RECNO=RECNO-1
      * home - blank window
      case IN_KEY=1 .and. .not. SMALL .and. RECNO>NRLINES
        SFLG=0
      * downarrow - move hilite bar down
      case IN_KEY=24 .and. CURSOR<NRLINES .and. CURSOR<RECNO
        if SHOWBAR
          do MOVEBAR with 1,TROW+CURSOR,LCOL+2,LENBAR,_LOCOLR,_BARCOLR
        endif
        CURSOR=CURSOR+1
        do SHOWMSG
        loop
      * uparrow - move hilite bar up
      case IN_KEY=5 .and. CURSOR>1
        if SHOWBAR
          do MOVEBAR with -1,TROW+CURSOR,LCOL+2,LENBAR,_LOCOLR,_BARCOLR
        endif
        CURSOR=CURSOR-1
        do SHOWMSG
        loop
      otherwise
        loop
    endcase

    if SHOWBAR
      _BCOLOR=_BARCOLR
    else
      * make bar invisible
      _BCOLOR=_LOCOLR
    endif

    do SCRLWNDO with SFLG,TROW+1,LCOL+2,BROW-1,RCOL-2,LENBAR,;
        TROW+CURSOR,_LOCOLR,_BCOLOR
    set color to &LOCOLR

    do case
      case SFLG=0
        * home - exit with IN_KEY=1
        exit
      case SFLG=1
        * scroll up
        @ BROW-1,LCOL+2 say _DATA[RECNO]
        if _RECORD[RECNO]<0
          set color to &DELCOLR
          @ row(),col()+1 say 'DEL'
          set color to &LOCOLR
        endif
      case SFLG=-1
        * scroll down
        @ TROW+1,LCOL+2 say _DATA[RECNO-NRLINES+1]
        if _RECORD[RECNO-NRLINES+1]<0
          set color to &DELCOLR
          @ row(),col()+1 say 'DEL'
          set color to &LOCOLR
        endif
    endcase
    if CURSOR=1 .or. CURSOR=NRLINES
      * first or last row, restore hi_attr which has scrolled off screen
      if SHOWBAR
        do MOVEBAR with 0,TROW+CURSOR,LCOL+2,LENBAR,_LOCOLR,_BARCOLR
      endif
    endif
  enddo

  do case
    case IN_KEY=1
      loop
    case IN_KEY=27
      CURSOR=0
      exit
    case IN_KEY=13
      if REALMENU
        if SMALL
          RECNO=RECNO-SMALLNR+CURSOR
        else        
          RECNO=RECNO-NRLINES+CURSOR
        endif
        goto ABS(_RECORD[RECNO])
        exit
      else
        CURSOR=0
        exit
      endif
  endcase

enddo
if CURSOR=0
  goto FRSTMTCH
endif
return CURSOR

procedure SHOWMSG
if LENMSG>0
  set color to &MSGCOLR
  @ MROW,MCOL say _MESSAGE[RECNO+CURSOR-min(NRLINES,SMALLNR)]
  set color to w
endif
return
