; SCRLMENU.ASM - scroll-a-menu routines SCRLWNDO,MOVEBAR
; For Clipper Aut'86

; Courtesy of Pete Orner
;             PRO microSystems
;             San Diego, California

; 4:59PM  3/21/1987
; 6:53PM  5/13/1987

;         PARAMETERS
;  <TopRow>,<LtCol>=upper left coords of window
;  <BotRow>,<RtCol>=lower right coords of window
;  <LenBar>=length (#chars) of line to be hilited
;  <HiAttr>=hilite bar text attribute, <LoAttr>=window text attribute
;  <CursorRow>=row where hilite bar is currently located

;          SYNTAX
; scroll a window <#lines> up/dn with stationary hilited bar
;  do SCRLWNDO with <#lines>,<TopRow>,<LtCol>,<BotRow>,<RtCol>,
;    <LenBar>,<CursorRow>,<LoAttr>,<HiAttr>

; move hilited bar <#lines> up/dn, preserving text
;  do MOVEBAR with <#lines>,<CursorRow>,<LtCol>,<LenBar>,<LoAttr>,<HiAttr>

;*** equates for CGA or monochrome ***
cga_buffer      equ     0b800h ;CGA, 4 pages of 4k ea @ b800,b900,ba00,bb00
mono_buffer     equ     0b000h ;monochrome, 1 page of 4k at b000
mono_80         equ     7      ;mode nrs returned by _vstate service
cga_bw_80       equ     2
cga_color_80    equ     3
page_size       equ     1000h  ;1 page = 4k
cga_control     equ     3d8h            ;cga control port
mono_control    equ     3b8h            ;monochrome control port
video_on        equ     00001001b       ;80x25 text - enable
video_off       equ     00000001b       ;    "      - disable

;video service equates (only some used here)
video           equ     10h
_vmode          equ     00h
_vsetcurs       equ     02h
_vpage          equ     05h
_vscrollup      equ     06h
_vscrolldn      equ     07h
_vreadchar      equ     08h
_vwritechar     equ     09h
_vcolor         equ     0bh
_vstate         equ     0fh
_vpalette       equ     10h

        public  SCRLWNDO,MOVEBAR
        extrn   _PARNI:FAR

prg_seg segment byte
        assume  cs:prg_seg
SCRLWNDO        proc    far
        push    bp
        mov     bp,sp
        push    ds
        push    es
        push    ax
        push    cx
        jmp     do_scroll

video_control   dw      0       ;control port, CGA or mono
video_buffer    dw      0       ;refresh buffer, CGA or mono
video_mode      db      0       ;mode - e.g. mono, cga, ...
line_size       db      0       ;nr of columns
page_nr         db      0
lo_attr         db      0
hi_attr         db      0
top_row         db      ?       ;top row of window
left_col        db      ?       ;left col of window
bottom_row      db      ?       ;bottom row of window
right_col       db      ?       ;right col of window
cursor_row      db      ?       ;row location of hilite bar
cursor_offset   dw      ?
scrl_count      db      ?       ;nr of lines to scroll; +=up,-=dn,0=blank
length_bar      dw      ?       ;nr of chars in hilite bar

;get integer parameter from Clipper, N=nr of param=1,2,...
get_int macro   N
        mov     ax,N
        push    ax
        call    _PARNI  ;Clipper extend function - get integer
        add     sp,2
        endm

do_scroll:
;set video display parameters
        call    set_video_parm
;get window parameters
        get_int 1
        mov     scrl_count,al
        get_int 2
        mov     top_row,al
        get_int 3
        mov     left_col,al
        get_int 4
        mov     bottom_row,al
        get_int 5
        mov     right_col,al
        get_int 6
        mov     length_bar,ax
        get_int 7
        mov     cursor_row,al
        get_int 8
        mov     lo_attr,al
        get_int 9
        mov     hi_attr,al

;calculate hilite bar location in video memory
        call    find_bar

;reset hilite bar attribute bytes to lo_attr
        mov     al,lo_attr
        call    set_bar_attr

;do the scroll
        mov     ch,top_row              ;ch,cl = row,col of upper left corner
        mov     cl,left_col
        mov     dh,bottom_row           ;dh,dl = row,col of lower right corner
        mov     dl,right_col
        mov     al,scrl_count
        mov     bh,lo_attr
        cmp     al,0
        mov     ah,_vscrollup
        jge     scrlit                  ;scroll up with lo_attr if 0 or >0
        mov     ah,_vscrolldn           ;else, scroll down
        neg     al
scrlit: int     video

;if not at top or bottom, reset hilite bar to hi_attr
        mov     al,cursor_row
        cmp     al,bottom_row
        je      finis
        cmp     al,top_row
        je      finis
        mov     al,hi_attr
        call    set_bar_attr

finis:  pop     cx
        pop     ax
        pop     es
        pop     ds
        pop     bp
        ret
SCRLWNDO        endp

;moves hilite bar up/down
MOVEBAR proc    far
        push    bp
        mov     bp,sp
        push    ds
        push    es
        push    ax
        push    cx
        call    set_video_parm
        get_int 2
        mov     cursor_row,al
        push    ax
        get_int 3
        mov     left_col,al
        get_int 4
        mov     length_bar,ax
        call    find_bar
        ;restore current hilite bar to lo_attr
        get_int 5               ;al=lo_attr
        call    set_bar_attr
        ;move to new position
        get_int 1               ;al=displ, +=dn,-=up
        pop     bx
        add     ax,bx
        mov     cursor_row,al
        call    find_bar
        ;set new position to hi_attr
        get_int 6               ;al=hi_attr
        call    set_bar_attr
        pop     cx
        pop     ax
        pop     es
        pop     ds
        pop     bp
        ret
MOVEBAR endp

;calculate hilite bar location in video memory
find_bar        proc
        mov     ax,page_size    ;offset = pagesize*pagenumber
        xor     bx,bx
        mov     bl,page_nr
        mul     bx
        push    ax
        xor     cx,cx
        mov     cl,cursor_row   ;        + row*linesize*2
        xor     ax,ax
        mov     al,line_size
        shl     ax,1
        mul     cx
        xor     bx,bx
        mov     bl,left_col
        shl     bx,1            ;        + column*2
        add     ax,bx
        pop     bx
        add     ax,bx
        mov     cursor_offset,ax
        ret
find_bar        endp

;set hilite bar attribute bytes to AL (direct to memory)
set_bar_attr    proc
        cli                     ;clear interrupts
        push    ax
        mov     ax,video_buffer
        mov     es,ax
        mov     dx,video_control
        mov     al,video_off
        out     dx,al           ;disable video
        pop     ax
        mov     di,cursor_offset
        mov     cx,length_bar   ;# chars in hilite bar
setb1:  inc     di              ;change all attr bytes to AL
        stosb                   ; char,attr,char,attr,...
        loop    setb1
        mov     dx,video_control
        mov     al,video_on
        out     dx,al           ;enable video
        sti
        ret
set_bar_attr    endp

;set video display parameters
set_video_parm  proc
        mov     ah,_vstate
        int     video
        mov     line_size,ah
        mov     video_mode,al
        mov     page_nr,bh
        mov     cx,mono_buffer          ;mono display
        mov     dx,mono_control
        cmp     al,mono_80
        je      setprm
        mov     cx,cga_buffer           ;otherwise, assume CGA display
        mov     dx,cga_control
setprm: mov     video_buffer,cx         ;refresh buffer
        mov     video_control,dx        ;control port
        ret
set_video_parm  endp

prg_seg ends
        end
