* MAKEWNDO - for Clipper Autumn '86
* program to design windows for SCRLFILE()

* courtesy of Pete Orner
*             PRO microSystems
*             San Diego, California

* created 5/05/1987

external SCRLWNDO

* masks for screen attribute byte
* "f_"=foreground, "b_"=background
  f_blink=128     && 80h     blinking
  b_red=64        && 40h
  b_green=32      && 20h
  b_blue=16       && 10h
  f_int=8         && 08h     intensity
  f_red=4         && 04h
  f_green=2       && 02h
  f_blue=1        && 01h

MEMFILE=space(30)
DBFNAME=""
INDEXNAME=""
FRSTREC=""
CKSTR=".not. eof()"
DTSTR=""
MSTR=""
LOGO=""
TROW=4
LCOL=6
BROW=16
RCOL=60
MROW=0
MCOL=0
_LOCOLR="f_green"
_BARCOLR="b_red+b_green+b_blue"
HICOLR="g+/n"
LOCOLR="g/n"
DELCOLR="w/r"
MSGCOLR="w/n"
REALMENU=.t.

do while .t.
  set color to w+
  clear
  @ 0,0 say "MakeWindow - Pete Orner/PRO microSystems/4-87"
  set color to w/n,n/w
  @ 24,0 say "MEM file"
  MEMFILE=MEMFILE+space(60-len(MEMFILE))
  @ row(),col()+1 get MEMFILE
  read
  MEMFILE=trim(MEMFILE)
  if len(MEMFILE)>0 .and. file("&MEMFILE"+".mem")
    restore from &MEMFILE additive
  endif
  @ 1,0 say "DBF file"
  DBFNAME=DBFNAME+space(60-len(DBFNAME))
  @ row(),col()+1 get DBFNAME
  @ 2,0 say "Index file"
  INDEXNAME=INDEXNAME+space(60-len(INDEXNAME))
  @ row(),col()+1 get INDEXNAME
  @ 3,0 say "Start At"
  FRSTREC=FRSTREC+space(60-len(FRSTREC))
  @ row(),col()+1 get FRSTREC
  @ 4,0 say "Do While"
  CKSTR=CKSTR+space(120-len(CKSTR))
  @ row(),col()+1 get CKSTR
  @ 6,0 say "Data "
  DTSTR=DTSTR+space(200-len(DTSTR))
  @ row(),col()+1 get DTSTR
  @ 9,0 say "Message "
  MSTR=MSTR+space(200-len(MSTR))
  @ row(),col()+1 get MSTR
  @ 12,0 say "Logo"
  LOGO=LOGO+space(70-len(LOGO))
  @ row(),col()+1 get LOGO
  @ 13,0 say "TopRow"
  @ row(),col()+1 get TROW pict "###"
  @ row(),col()+1 say "LeftCol"
  @ row(),col()+1 get LCOL pict "###"
  @ row(),col()+1 say "BottomRow"
  @ row(),col()+1 get BROW pict "###"
  @ row(),col()+1 say "RightCol"
  @ row(),col()+1 get RCOL pict "###"
  @ 14,0 say "Message: Row"
  @ row(),col()+1 get MROW pict "###"
  @ row(),col()+1 say "Col"
  @ row(),col()+1 get MCOL pict "###"
  ?
  ? "_HI/_LOCOLR = f_blink f_int f_red f_green f_blue b_red b_green b_blue"
  ? "HI/LO/DEL/MSGCOLR = g+/n w/r etc"
  @ 18,0 say "_LOCOLR"
  _LOCOLR=_LOCOLR+space(65-len(_LOCOLR))
  @ row(),col()+1 get _LOCOLR
  @ 19,0 say "_BARCOLR"
  _BARCOLR=_BARCOLR+space(65-len(_BARCOLR))
  @ row(),col()+1 get _BARCOLR
  @ 20,0 say "HICOLR"
  HICOLR=HICOLR+space(10-len(HICOLR))
  @ row(),col()+1 get HICOLR
  @ row(),col()+1 say "LOCOLR"
  LOCOLR=LOCOLR+space(10-len(LOCOLR))
  @ row(),col()+1 get LOCOLR
  @ row(),col()+1 say "DELCOLR"
  DELCOLR=DELCOLR+space(10-len(DELCOLR))
  @ row(),col()+1 get DELCOLR
  @ row(),col()+1 say "MSGCOLR"
  MSGCOLR=MSGCOLR+space(10-len(MSGCOLR))
  @ row(),col()+1 get MSGCOLR
  @ 21,0 say "Real menu (Y/N)?"
  @ row(),col()+1 get REALMENU pict "@L Y"
  read

  @ 18,75 say str(&_LOCOLR,3)
  @ 19,75 say str(&_BARCOLR,3)
  @ 24,0
  ANSWER=' '
  @ 24,0 say "S(crlFile), R(estart), Q(uit)? "
  @ row(),col()+1 get ANSWER pict "@!" valid (ANSWER $ "SRQ")
  read
  do case
    case ANSWER='R'
      loop
    case ANSWER='Q'
      exit
  endcase

  DBFNAME=trim(DBFNAME)
  INDEXNAME=trim(INDEXNAME)
  if file("&DBFNAME"+".dbf") .and. file("&INDEXNAME"+".ntx")
    use &DBFNAME index &INDEXNAME
  else
    set color to w+
    @ 23,0 say "Database and/or Index file not found"
    set color to w
    @ 24,0
    @ 24,0 say "Q(uit), R(estart)? "
    ANSWER1=' '
    @ row(),col()+1 get ANSWER1 pict "@!" valid (ANSWER1 $ "QR")
    read
    do case
      case ANSWER1='R'
        loop
      case ANSWER1='Q'
        exit
    endcase
  endif
    
  goto top
  FMATCH=recno()
  FRSTREC=trim(FRSTREC)
  if len(FRSTREC)>0
    do while .not. &FRSTREC
      skip
    enddo
    FMATCH=recno()
  endif

  CKSTR=trim(CKSTR)
  DTSTR=trim(DTSTR)
  MSTR=trim(MSTR)
  LOGO=trim(LOGO)
  _LOCOLR=trim(_LOCOLR)
  _BARCOLR=trim(_BARCOLR)
  HICOLR=trim(HICOLR)
  LOCOLR=trim(LOCOLR)
  DELCOLR=trim(DELCOLR)
  MSGCOLR=trim(MSGCOLR)

  set escape on
  do SCRLWNDO with 0,TROW+1,LCOL+1,BROW-1,RCOL-1,1,TROW+1,&_LOCOLR,&_BARCOLR
  ITEMNR=SCRLFILE(TROW,LCOL,BROW,RCOL,FMATCH,CKSTR,DTSTR," "+LOGO+" ",;
    LOCOLR,HICOLR,DELCOLR,&_LOCOLR,&_BARCOLR,MROW,MCOL,MSTR,;
    MSGCOLR,REALMENU)
  if ITEMNR>0
    set color to w
    @ 23,0 say '#'+ltrim(str(ITEMNR))+':'
    set color to w+
    @ row(),col()+1 say &DTSTR
  endif
  call CURSOR with "76"
  set color to w/n,n/w
  @ 24,0
  @ 24,0 say "Save to Memory File:"
  MEMFILE=MEMFILE+space(30-len(MEMFILE))
  @ row(),col()+1 get MEMFILE
  read
  MEMFILE=trim(MEMFILE)
  if len(MEMFILE)>0
    save to &MEMFILE
  endif
  @ 24,60 say "M(ore), Q(uit)?"
  ANSWER=' '
  @ row(),col()+1 get ANSWER pict "@!" valid (ANSWER $ "MQ")
  read
  if .not. ANSWER = "M"
    exit
  endif
enddo
